/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.testUtil.ScaffoldingForRollingTests;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SizeBasedRollingTest
extends ScaffoldingForRollingTests {
    RollingFileAppender<Object> rfa = new RollingFileAppender();
    FixedWindowRollingPolicy fwrp = new FixedWindowRollingPolicy();
    SizeBasedTriggeringPolicy<Object> sizeBasedTriggeringPolicy = new SizeBasedTriggeringPolicy();
    EchoEncoder<Object> encoder = new EchoEncoder();

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.fwrp.setContext(this.context);
        this.fwrp.setParent(this.rfa);
        this.rfa.setContext(this.context);
        this.sizeBasedTriggeringPolicy.setContext(this.context);
    }

    private void initRFA(String filename) {
        this.rfa.setEncoder(this.encoder);
        if (filename != null) {
            this.rfa.setFile(filename);
        }
    }

    @Test
    public void activeFileNameNotSet() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            this.sizeBasedTriggeringPolicy.setMaxFileSize(new FileSize(100L));
            this.sizeBasedTriggeringPolicy.start();
            this.fwrp.setFileNamePattern("target/test-output/sizeBased-test1.%i");
            this.fwrp.start();
        });
    }

    void generic(String testName, String fileName, String filenamePattern, List<String> expectedFilenameList) throws InterruptedException, IOException {
        this.rfa.setName("ROLLING");
        this.initRFA(this.randomOutputDir + fileName);
        this.sizeBasedTriggeringPolicy.setMaxFileSize(new FileSize(100L));
        this.sizeBasedTriggeringPolicy.setCheckIncrement(Duration.buildByMilliseconds((double)50.0));
        this.fwrp.setMinIndex(0);
        this.fwrp.setFileNamePattern(this.randomOutputDir + filenamePattern);
        this.rfa.triggeringPolicy = this.sizeBasedTriggeringPolicy;
        this.rfa.rollingPolicy = this.fwrp;
        this.fwrp.start();
        this.sizeBasedTriggeringPolicy.start();
        this.rfa.start();
        int runLength = 40;
        String prefix = "hello";
        for (int i = 0; i < runLength; ++i) {
            Thread.sleep(10L);
            this.rfa.doAppend((Object)(prefix + i));
        }
        this.rfa.stop();
        StatusPrinter.print((Context)this.context);
        SizeBasedRollingTest.existenceCheck(expectedFilenameList);
        SizeBasedRollingTest.reverseSortedContentCheck(this.randomOutputDir, runLength, prefix);
    }

    @Test
    public void smoke() throws IOException, InterruptedException {
        this.expectedFilenameList.add(this.randomOutputDir + "a-sizeBased-smoke.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sizeBased-smoke.0");
        this.expectedFilenameList.add(this.randomOutputDir + "sizeBased-smoke.1");
        this.generic("zipped", "a-sizeBased-smoke.log", "sizeBased-smoke.%i", this.expectedFilenameList);
    }

    @Test
    public void gz() throws IOException, InterruptedException {
        this.expectedFilenameList.add(this.randomOutputDir + "a-sbr-gzed.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-gzed.0.gz");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-gzed.1.gz");
        this.generic("gzed", "a-sbr-gzed.log", "sbr-gzed.%i.gz", this.expectedFilenameList);
    }

    @Test
    public void zipped() throws IOException, InterruptedException {
        this.expectedFilenameList.add(this.randomOutputDir + "a-sbr-zipped.log");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-zipped.0.zip");
        this.expectedFilenameList.add(this.randomOutputDir + "sbr-zipped.1.zip");
        this.generic("zipped", "a-sbr-zipped.log", "sbr-zipped.%i.zip", this.expectedFilenameList);
        List<String> zipFiles = this.filterElementsInListBySuffix(".zip");
        this.zipEntryNameCheck(zipFiles, "sbr-zipped.20\\d{2}-\\d{2}-\\d{2}_\\d{4}");
    }
}

