/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.util.Iterator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AppenderAttachableImplTest {
    private AppenderAttachableImpl<TestEvent> aai;

    @BeforeEach
    public void setUp() throws Exception {
        this.aai = new AppenderAttachableImpl();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.aai = null;
    }

    @Test
    public void testAddAppender() throws Exception {
        TestEvent event = new TestEvent();
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        ta = new NOPAppender();
        ta.setName("test");
        ta.start();
        this.aai.addAppender((Appender)ta);
        int size = this.aai.appendLoopOnAppenders((Object)event);
        Assertions.assertTrue((size == 2 ? 1 : 0) != 0, (String)"Incorrect number of appenders");
    }

    @Test
    public void testIteratorForAppenders() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Iterator iter = this.aai.iteratorForAppenders();
        int size = 0;
        while (iter.hasNext()) {
            ++size;
            Appender app = (Appender)iter.next();
            Assertions.assertTrue((app == ta || app == tab ? 1 : 0) != 0, (String)"Bad Appender");
        }
        Assertions.assertTrue((size == 2 ? 1 : 0) != 0, (String)"Incorrect number of appenders");
    }

    @Test
    public void getGetAppender() throws Exception {
        NOPAppender test = new NOPAppender();
        test.setName("test");
        test.start();
        this.aai.addAppender((Appender)test);
        NOPAppender testOther = new NOPAppender();
        testOther.setName("testOther");
        testOther.start();
        this.aai.addAppender((Appender)testOther);
        Appender a = this.aai.getAppender("testOther");
        Assertions.assertNotNull((Object)a, (String)"Could not find appender");
        Assertions.assertTrue((a == testOther ? 1 : 0) != 0, (String)"Wrong appender");
        a = this.aai.getAppender("test");
        Assertions.assertNotNull((Object)a, (String)"Could not find appender");
        Assertions.assertTrue((a == test ? 1 : 0) != 0, (String)"Wrong appender");
        a = this.aai.getAppender("NotThere");
        Assertions.assertNull((Object)a, (String)"Appender was returned");
    }

    @Test
    public void testIsAttached() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assertions.assertTrue((boolean)this.aai.isAttached((Appender)ta), (String)"Appender is not attached");
        Assertions.assertTrue((boolean)this.aai.isAttached((Appender)tab), (String)"Appender is not attached");
    }

    @Test
    public void testDetachAndStopAllAppenders() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assertions.assertTrue((boolean)tab.isStarted(), (String)"Appender was not started");
        this.aai.detachAndStopAllAppenders();
        Assertions.assertNull((Object)this.aai.getAppender("test"), (String)"Appender was not removed");
        Assertions.assertFalse((boolean)tab.isStarted(), (String)"Appender was not stopped");
    }

    @Test
    public void testDetachAppender() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assertions.assertTrue((boolean)this.aai.detachAppender((Appender)tab), (String)"Appender not detached");
        Assertions.assertNull((Object)this.aai.getAppender("test"), (String)"Appender was not removed");
        Assertions.assertFalse((boolean)this.aai.detachAppender((Appender)tab), (String)"Appender detach error");
    }

    @Test
    public void testDetachAppenderByName() throws Exception {
        NOPAppender ta = new NOPAppender();
        ta.setName("test1");
        ta.start();
        this.aai.addAppender((Appender)ta);
        NOPAppender tab = new NOPAppender();
        tab.setName("test");
        tab.start();
        this.aai.addAppender((Appender)tab);
        Assertions.assertTrue((boolean)this.aai.detachAppender("test"));
        Assertions.assertTrue((boolean)this.aai.detachAppender("test1"));
        Assertions.assertFalse((boolean)this.aai.detachAppender("test1"));
    }

    private static class TestEvent {
        private TestEvent() {
        }
    }
}

