package ${package}.adapter.impl;

import com.hc.springboot.core.dto.base.BaseRequestDTO;
import com.hc.springboot.core.dto.base.BaseResponseDTO;
import com.hc.springboot.core.service.base.ServiceExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

public abstract class MyServiceExecutor<REQUEST extends BaseRequestDTO, RESPONSE extends BaseResponseDTO>
		extends ServiceExecutor<REQUEST, RESPONSE> {
	private final Logger logger = LoggerFactory.getLogger( this.getClass() );

	@Override
	protected void handleException( Exception e ) {
		TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
	}

}
