package ${package}.sdk.feign;

import com.hc.common.config.ContentType;
import com.hc.common.config.code.ResponseCode;
import com.hc.springboot.core.dto.base.BaseResponseDTO;
import com.hc.springboot.core.dto.base.BaseRequestDTO;
import org.springframework.cloud.openfeign.FallbackFactory;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;

@FeignClient( name = "$#{system-config.feign-name.${rootArtifactId}:${rootArtifactId}}",path="$#{system-config.feign-path.${rootArtifactId}:}", url = "$#{system-config.base-url.${rootArtifactId}:#{null}}", fallbackFactory = ${ClassPre}ClientFeign.HystrixClientFallbackFactory.class )
public interface ${ClassPre}ClientFeign {

	static final String URL_BASE = "";

	@ResponseBody
	@RequestMapping( value = URL_BASE + "/test/url", method = RequestMethod.POST, produces = {
			ContentType.APPLICATION_JSON_UTF_8 } )
	@ApiOperation( value = "获取管理员可以管理且已经开通对应功能的应用列表" )
	BaseResponseDTO getAdminFuncApp( @RequestBody BaseRequestDTO requestDTO );


	@Component
	class HystrixClientFallbackFactory implements FallbackFactory<${ClassPre}ClientFeign> {
		private final Logger LOGGER = LoggerFactory.getLogger( this.getClass() );

		@Override
		public ${ClassPre}ClientFeign create( final Throwable e ) {

			return new ${ClassPre}ClientFeign() {

				@Override
				public BaseResponseDTO getAdminFuncApp( BaseRequestDTO requestDTO ) {
					return this.handleException( new BaseResponseDTO() );
				}

				private <DTO extends BaseResponseDTO> DTO handleException( DTO dto ) {
					LOGGER.error( "feign http ${rootArtifactId} exception", e );
					dto.failed( new ResponseCode( "${rootArtifactId}-FEIGN-FAILED", "请求${rootArtifactId}失败" ) ).setErrorMsg( e.getMessage() );
					return dto;
				}
			};
		}
	}
}
