/*
 * Decompiled with CFR 0.152.
 */
package cn.springcloud.dubbo.core;

import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.DubboFeignBuilder;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.FeignClientToDubboProviderBeanPostProcessor;
import feign.Feign;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true, havingValue="true")
@ConditionalOnClass(value={AbstractConfig.class})
public class SpringCloudDubboAutoConfiguration {
    @ConditionalOnProperty(name={"dubbo.scan.basePackages"})
    @ConditionalOnClass(value={ConfigurationPropertySources.class})
    @Bean
    public FeignClientToDubboProviderBeanPostProcessor feignClientToDubboProviderBeanPostProcessor(Environment environment) {
        Set packagesToScan = (Set)environment.getProperty("dubbo.scan.basePackages", Set.class, Collections.emptySet());
        return new FeignClientToDubboProviderBeanPostProcessor(packagesToScan);
    }

    @Bean
    public Feign.Builder feignDubboBuilder() {
        return new DubboFeignBuilder();
    }
}

