/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Contract;
import feign.Feign;
import feign.MethodMetadata;
import feign.Types;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;

public abstract class VenusBaseContract
extends Contract.BaseContract {
    protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        MethodMetadata data = new MethodMetadata();
        data.returnType(Types.resolve(targetType, targetType, (Type)method.getGenericReturnType()));
        data.configKey(Feign.configKey(targetType, (Method)method));
        if (targetType.getInterfaces().length == 1) {
            this.processAnnotationOnClass(data, targetType.getInterfaces()[0]);
        }
        this.processAnnotationOnClass(data, targetType);
        for (Annotation methodAnnotation : method.getAnnotations()) {
            this.processAnnotationOnMethod(data, methodAnnotation, method);
        }
        Util.checkState((data.template().method() != null ? 1 : 0) != 0, (String)"Method %s not annotated with HTTP method type (ex. GET, POST)", (Object[])new Object[]{method.getName()});
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        int count = parameterAnnotations.length;
        for (int i = 0; i < count; ++i) {
            boolean isHttpAnnotation = false;
            if (parameterAnnotations[i] != null) {
                isHttpAnnotation = this.processAnnotationsOnParameter(data, parameterAnnotations[i], i);
            }
            if (parameterTypes[i] == URI.class) {
                data.urlIndex(Integer.valueOf(i));
                continue;
            }
            if (isHttpAnnotation) continue;
            Util.checkState((data.bodyIndex() == null ? 1 : 0) != 0, (String)"Method has too many Body parameters: %s", (Object[])new Object[]{method});
            data.bodyIndex(Integer.valueOf(i));
            data.bodyType(Types.resolve(targetType, targetType, (Type)genericParameterTypes[i]));
        }
        if (data.headerMapIndex() != null) {
            VenusBaseContract.checkMapString("HeaderMap", parameterTypes[data.headerMapIndex()], genericParameterTypes[data.headerMapIndex()]);
        }
        if (data.queryMapIndex() != null) {
            VenusBaseContract.checkMapString("QueryMap", parameterTypes[data.queryMapIndex()], genericParameterTypes[data.queryMapIndex()]);
        }
        return data;
    }

    private static void checkMapString(String name, Class<?> type, Type genericType) {
        Util.checkState((boolean)Map.class.isAssignableFrom(type), (String)"%s parameter must be a Map: %s", (Object[])new Object[]{name, type});
        Type[] parameterTypes = ((ParameterizedType)genericType).getActualTypeArguments();
        Class keyClass = (Class)parameterTypes[0];
        Util.checkState((boolean)String.class.equals((Object)keyClass), (String)"%s key must be a String: %s", (Object[])new Object[]{name, keyClass.getSimpleName()});
    }
}

