/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InferenceEndpoint
implements JsonpSerializable {
    private final String service;
    private final JsonData serviceSettings;
    private final JsonData taskSettings;
    public static final JsonpDeserializer<InferenceEndpoint> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceEndpoint::setupInferenceEndpointDeserializer);

    protected InferenceEndpoint(AbstractBuilder<?> builder) {
        this.service = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).serviceSettings, this, "serviceSettings");
        this.taskSettings = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).taskSettings, this, "taskSettings");
    }

    public static InferenceEndpoint inferenceEndpointOf(Function<Builder, ObjectBuilder<InferenceEndpoint>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String service() {
        return this.service;
    }

    public final JsonData serviceSettings() {
        return this.serviceSettings;
    }

    public final JsonData taskSettings() {
        return this.taskSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service");
        generator.write(this.service);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        generator.writeKey("task_settings");
        this.taskSettings.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupInferenceEndpointDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::service, JsonpDeserializer.stringDeserializer(), "service");
        op.add(AbstractBuilder::serviceSettings, JsonData._DESERIALIZER, "service_settings");
        op.add(AbstractBuilder::taskSettings, JsonData._DESERIALIZER, "task_settings");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String service;
        private JsonData serviceSettings;
        private JsonData taskSettings;

        public final BuilderT service(String value) {
            this.service = value;
            return (BuilderT)this.self();
        }

        public final BuilderT serviceSettings(JsonData value) {
            this.serviceSettings = value;
            return (BuilderT)this.self();
        }

        public final BuilderT taskSettings(JsonData value) {
            this.taskSettings = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceEndpoint> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceEndpoint build() {
            this._checkSingleUse();
            return new InferenceEndpoint(this);
        }
    }
}

