/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.KnnRetriever;
import co.elastic.clients.elasticsearch._types.RRFRetriever;
import co.elastic.clients.elasticsearch._types.RetrieverVariant;
import co.elastic.clients.elasticsearch._types.RuleRetriever;
import co.elastic.clients.elasticsearch._types.StandardRetriever;
import co.elastic.clients.elasticsearch._types.TextSimilarityReranker;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Retriever
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<Retriever> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Retriever::setupRetrieverDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Retriever(RetrieverVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._retrieverKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Retriever(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Retriever of(Function<Builder, ObjectBuilder<Retriever>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isStandard() {
        return this._kind == Kind.Standard;
    }

    public StandardRetriever standard() {
        return (StandardRetriever)TaggedUnionUtils.get(this, Kind.Standard);
    }

    public boolean isKnn() {
        return this._kind == Kind.Knn;
    }

    public KnnRetriever knn() {
        return (KnnRetriever)TaggedUnionUtils.get(this, Kind.Knn);
    }

    public boolean isRrf() {
        return this._kind == Kind.Rrf;
    }

    public RRFRetriever rrf() {
        return (RRFRetriever)TaggedUnionUtils.get(this, Kind.Rrf);
    }

    public boolean isTextSimilarityReranker() {
        return this._kind == Kind.TextSimilarityReranker;
    }

    public TextSimilarityReranker textSimilarityReranker() {
        return (TextSimilarityReranker)TaggedUnionUtils.get(this, Kind.TextSimilarityReranker);
    }

    public boolean isRule() {
        return this._kind == Kind.Rule;
    }

    public RuleRetriever rule() {
        return (RuleRetriever)TaggedUnionUtils.get(this, Kind.Rule);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRetrieverDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::standard, StandardRetriever._DESERIALIZER, "standard");
        op.add(Builder::knn, KnnRetriever._DESERIALIZER, "knn");
        op.add(Builder::rrf, RRFRetriever._DESERIALIZER, "rrf");
        op.add(Builder::textSimilarityReranker, TextSimilarityReranker._DESERIALIZER, "text_similarity_reranker");
        op.add(Builder::rule, RuleRetriever._DESERIALIZER, "rule");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Retriever> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<Retriever> standard(StandardRetriever v) {
            this._kind = Kind.Standard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Retriever> standard(Function<StandardRetriever.Builder, ObjectBuilder<StandardRetriever>> fn) {
            return this.standard(fn.apply(new StandardRetriever.Builder()).build());
        }

        public ObjectBuilder<Retriever> knn(KnnRetriever v) {
            this._kind = Kind.Knn;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Retriever> knn(Function<KnnRetriever.Builder, ObjectBuilder<KnnRetriever>> fn) {
            return this.knn(fn.apply(new KnnRetriever.Builder()).build());
        }

        public ObjectBuilder<Retriever> rrf(RRFRetriever v) {
            this._kind = Kind.Rrf;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Retriever> rrf(Function<RRFRetriever.Builder, ObjectBuilder<RRFRetriever>> fn) {
            return this.rrf(fn.apply(new RRFRetriever.Builder()).build());
        }

        public ObjectBuilder<Retriever> textSimilarityReranker(TextSimilarityReranker v) {
            this._kind = Kind.TextSimilarityReranker;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Retriever> textSimilarityReranker(Function<TextSimilarityReranker.Builder, ObjectBuilder<TextSimilarityReranker>> fn) {
            return this.textSimilarityReranker(fn.apply(new TextSimilarityReranker.Builder()).build());
        }

        public ObjectBuilder<Retriever> rule(RuleRetriever v) {
            this._kind = Kind.Rule;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Retriever> rule(Function<RuleRetriever.Builder, ObjectBuilder<RuleRetriever>> fn) {
            return this.rule(fn.apply(new RuleRetriever.Builder()).build());
        }

        @Override
        public Retriever build() {
            this._checkSingleUse();
            return new Retriever(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Standard("standard"),
        Knn("knn"),
        Rrf("rrf"),
        TextSimilarityReranker("text_similarity_reranker"),
        Rule("rule");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

