/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch.core.MsearchTemplateResponse;
import co.elastic.clients.elasticsearch.core.msearch_template.RequestItem;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MsearchTemplateRequest
extends RequestBase
implements NdJsonpSerializable,
JsonpSerializable {
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    private final List<String> index;
    @Nullable
    private final Long maxConcurrentSearches;
    @Nullable
    private final SearchType searchType;
    private final List<RequestItem> searchTemplates;
    public static final SimpleEndpoint<MsearchTemplateRequest, ?> _ENDPOINT = new SimpleEndpoint<MsearchTemplateRequest, MsearchTemplateResponse<Object>>("es/msearch_template", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_msearch");
            buf.append("/template");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_msearch");
            buf.append("/template");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typed_keys", "true");
        if (request.maxConcurrentSearches != null) {
            params.put("max_concurrent_searches", String.valueOf(request.maxConcurrentSearches));
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.jsonValue());
        }
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, MsearchTemplateResponse._DESERIALIZER);

    private MsearchTemplateRequest(Builder builder) {
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.maxConcurrentSearches = builder.maxConcurrentSearches;
        this.searchType = builder.searchType;
        this.searchTemplates = ApiTypeHelper.unmodifiableRequired(builder.searchTemplates, (Object)this, "searchTemplates");
    }

    public static MsearchTemplateRequest of(Function<Builder, ObjectBuilder<MsearchTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Iterator<?> _serializables() {
        return this.searchTemplates.iterator();
    }

    @Nullable
    public final Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Long maxConcurrentSearches() {
        return this.maxConcurrentSearches;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    public final List<RequestItem> searchTemplates() {
        return this.searchTemplates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (RequestItem item0 : this.searchTemplates) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public static <TDocument> Endpoint<MsearchTemplateRequest, MsearchTemplateResponse<TDocument>, ErrorResponse> createMsearchTemplateEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(MsearchTemplateResponse.createMsearchTemplateResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MsearchTemplateRequest> {
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private List<String> index;
        @Nullable
        private Long maxConcurrentSearches;
        @Nullable
        private SearchType searchType;
        private List<RequestItem> searchTemplates;

        public final Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder maxConcurrentSearches(@Nullable Long value) {
            this.maxConcurrentSearches = value;
            return this;
        }

        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public final Builder searchTemplates(List<RequestItem> list) {
            this.searchTemplates = Builder._listAddAll(this.searchTemplates, list);
            return this;
        }

        public final Builder searchTemplates(RequestItem value, RequestItem ... values) {
            this.searchTemplates = Builder._listAdd(this.searchTemplates, value, values);
            return this;
        }

        public final Builder searchTemplates(Function<RequestItem.Builder, ObjectBuilder<RequestItem>> fn) {
            return this.searchTemplates(fn.apply(new RequestItem.Builder()).build(), new RequestItem[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MsearchTemplateRequest build() {
            this._checkSingleUse();
            return new MsearchTemplateRequest(this);
        }
    }
}

