/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FlushJobResponse
implements JsonpSerializable {
    private final boolean flushed;
    @Nullable
    private final Integer lastFinalizedBucketEnd;
    public static final JsonpDeserializer<FlushJobResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlushJobResponse::setupFlushJobResponseDeserializer);

    private FlushJobResponse(Builder builder) {
        this.flushed = ApiTypeHelper.requireNonNull(builder.flushed, (Object)this, "flushed", false);
        this.lastFinalizedBucketEnd = builder.lastFinalizedBucketEnd;
    }

    public static FlushJobResponse of(Function<Builder, ObjectBuilder<FlushJobResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean flushed() {
        return this.flushed;
    }

    @Nullable
    public final Integer lastFinalizedBucketEnd() {
        return this.lastFinalizedBucketEnd;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("flushed");
        generator.write(this.flushed);
        if (this.lastFinalizedBucketEnd != null) {
            generator.writeKey("last_finalized_bucket_end");
            generator.write(this.lastFinalizedBucketEnd.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFlushJobResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::flushed, JsonpDeserializer.booleanDeserializer(), "flushed");
        op.add(Builder::lastFinalizedBucketEnd, JsonpDeserializer.integerDeserializer(), "last_finalized_bucket_end");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FlushJobResponse> {
        private Boolean flushed;
        @Nullable
        private Integer lastFinalizedBucketEnd;

        public final Builder flushed(boolean value) {
            this.flushed = value;
            return this;
        }

        public final Builder lastFinalizedBucketEnd(@Nullable Integer value) {
            this.lastFinalizedBucketEnd = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FlushJobResponse build() {
            this._checkSingleUse();
            return new FlushJobResponse(this);
        }
    }
}

