/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules.test;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class QueryRulesetMatchedRule
implements JsonpSerializable {
    private final String rulesetId;
    private final String ruleId;
    public static final JsonpDeserializer<QueryRulesetMatchedRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRulesetMatchedRule::setupQueryRulesetMatchedRuleDeserializer);

    private QueryRulesetMatchedRule(Builder builder) {
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
        this.ruleId = ApiTypeHelper.requireNonNull(builder.ruleId, this, "ruleId");
    }

    public static QueryRulesetMatchedRule of(Function<Builder, ObjectBuilder<QueryRulesetMatchedRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("ruleset_id");
        generator.write(this.rulesetId);
        generator.writeKey("rule_id");
        generator.write(this.ruleId);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryRulesetMatchedRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rulesetId, JsonpDeserializer.stringDeserializer(), "ruleset_id");
        op.add(Builder::ruleId, JsonpDeserializer.stringDeserializer(), "rule_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryRulesetMatchedRule> {
        private String rulesetId;
        private String ruleId;

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        public final Builder ruleId(String value) {
            this.ruleId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRulesetMatchedRule build() {
            this._checkSingleUse();
            return new QueryRulesetMatchedRule(this);
        }
    }
}

