/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class SimulatedActions
implements JsonpSerializable {
    private final List<String> actions;
    private final SimulatedActions all;
    private final boolean useAll;
    public static final JsonpDeserializer<SimulatedActions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulatedActions::setupSimulatedActionsDeserializer);

    private SimulatedActions(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
        this.all = ApiTypeHelper.requireNonNull(builder.all, this, "all");
        this.useAll = ApiTypeHelper.requireNonNull(builder.useAll, (Object)this, "useAll", false);
    }

    public static SimulatedActions of(Function<Builder, ObjectBuilder<SimulatedActions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final SimulatedActions all() {
        return this.all;
    }

    public final boolean useAll() {
        return this.useAll;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartArray();
            for (String item0 : this.actions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("all");
        this.all.serialize(generator, mapper);
        generator.writeKey("use_all");
        generator.write(this.useAll);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSimulatedActionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "actions");
        op.add(Builder::all, _DESERIALIZER, "all");
        op.add(Builder::useAll, JsonpDeserializer.booleanDeserializer(), "use_all");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SimulatedActions> {
        private List<String> actions;
        private SimulatedActions all;
        private Boolean useAll;

        public final Builder actions(List<String> list) {
            this.actions = Builder._listAddAll(this.actions, list);
            return this;
        }

        public final Builder actions(String value, String ... values) {
            this.actions = Builder._listAdd(this.actions, value, values);
            return this;
        }

        public final Builder all(SimulatedActions value) {
            this.all = value;
            return this;
        }

        public final Builder all(Function<Builder, ObjectBuilder<SimulatedActions>> fn) {
            return this.all(fn.apply(new Builder()).build());
        }

        public final Builder useAll(boolean value) {
            this.useAll = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimulatedActions build() {
            this._checkSingleUse();
            return new SimulatedActions(this);
        }
    }
}

