/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.CCSUsageTimeValue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CCSUsageClusterStats
implements JsonpSerializable {
    private final int total;
    private final int skipped;
    private final CCSUsageTimeValue took;
    public static final JsonpDeserializer<CCSUsageClusterStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CCSUsageClusterStats::setupCCSUsageClusterStatsDeserializer);

    private CCSUsageClusterStats(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0);
        this.skipped = ApiTypeHelper.requireNonNull(builder.skipped, (Object)this, "skipped", 0);
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
    }

    public static CCSUsageClusterStats of(Function<Builder, ObjectBuilder<CCSUsageClusterStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int total() {
        return this.total;
    }

    public final int skipped() {
        return this.skipped;
    }

    public final CCSUsageTimeValue took() {
        return this.took;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("skipped");
        generator.write(this.skipped);
        generator.writeKey("took");
        this.took.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCCSUsageClusterStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::skipped, JsonpDeserializer.integerDeserializer(), "skipped");
        op.add(Builder::took, CCSUsageTimeValue._DESERIALIZER, "took");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CCSUsageClusterStats> {
        private Integer total;
        private Integer skipped;
        private CCSUsageTimeValue took;

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder skipped(int value) {
            this.skipped = value;
            return this;
        }

        public final Builder took(CCSUsageTimeValue value) {
            this.took = value;
            return this;
        }

        public final Builder took(Function<CCSUsageTimeValue.Builder, ObjectBuilder<CCSUsageTimeValue>> fn) {
            return this.took(fn.apply(new CCSUsageTimeValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CCSUsageClusterStats build() {
            this._checkSingleUse();
            return new CCSUsageClusterStats(this);
        }
    }
}

