/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class VoyageAIServiceSettings
implements JsonpSerializable {
    @Nullable
    private final Integer dimensions;
    private final String modelId;
    @Nullable
    private final RateLimitSetting rateLimit;
    @Nullable
    private final Float embeddingType;
    public static final JsonpDeserializer<VoyageAIServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VoyageAIServiceSettings::setupVoyageAIServiceSettingsDeserializer);

    private VoyageAIServiceSettings(Builder builder) {
        this.dimensions = builder.dimensions;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.rateLimit = builder.rateLimit;
        this.embeddingType = builder.embeddingType;
    }

    public static VoyageAIServiceSettings of(Function<Builder, ObjectBuilder<VoyageAIServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer dimensions() {
        return this.dimensions;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Nullable
    public final Float embeddingType() {
        return this.embeddingType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dimensions != null) {
            generator.writeKey("dimensions");
            generator.write(this.dimensions.intValue());
        }
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        if (this.embeddingType != null) {
            generator.writeKey("embedding_type");
            generator.write((double)this.embeddingType.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupVoyageAIServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dimensions, JsonpDeserializer.integerDeserializer(), "dimensions");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::embeddingType, JsonpDeserializer.floatDeserializer(), "embedding_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<VoyageAIServiceSettings> {
        @Nullable
        private Integer dimensions;
        private String modelId;
        @Nullable
        private RateLimitSetting rateLimit;
        @Nullable
        private Float embeddingType;

        public final Builder dimensions(@Nullable Integer value) {
            this.dimensions = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder embeddingType(@Nullable Float value) {
            this.embeddingType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public VoyageAIServiceSettings build() {
            this._checkSingleUse();
            return new VoyageAIServiceSettings(this);
        }
    }
}

