/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.messaging.amf.io.util;

import com.exadel.flamingo.flex.messaging.amf.io.util.Converter;
import com.exadel.flamingo.flex.messaging.amf.io.util.DefaultConverter;
import com.exadel.flamingo.flex.messaging.amf.io.util.MapProperty;
import com.exadel.flamingo.flex.messaging.amf.io.util.Property;
import com.exadel.flamingo.flex.messaging.amf.io.util.externalizer.Externalizer;
import com.exadel.flamingo.flex.messaging.amf.io.util.instanciator.AbstractInstanciator;
import java.util.ArrayList;
import java.util.List;

public abstract class ActionScriptClassDescriptor {
    protected final String type;
    protected final byte encoding;
    protected final Externalizer externalizer;
    protected final Converter converter;
    protected final List<Property> properties;

    protected ActionScriptClassDescriptor(String type, byte encoding) {
        this.type = type == null ? "" : type;
        this.encoding = encoding;
        this.externalizer = this.findExternalizer();
        this.converter = new DefaultConverter();
        this.properties = new ArrayList<Property>();
    }

    private Externalizer findExternalizer() {
        return null;
    }

    public String getType() {
        return this.type;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public boolean isExternalizable() {
        return this.encoding == 1;
    }

    public boolean isDynamic() {
        return this.encoding == 2;
    }

    public abstract void defineProperty(String var1);

    public abstract Object newJavaInstance();

    public int getPropertiesCount() {
        return this.properties.size();
    }

    public String getPropertyName(int index) {
        return this.properties.get(index).getName();
    }

    public void setPropertyValue(int index, Object instance, Object value) {
        Property prop = this.properties.get(index);
        if (value instanceof AbstractInstanciator) {
            ((AbstractInstanciator)value).addReferer(instance, prop);
        } else {
            prop.setProperty(instance, value);
        }
    }

    public void setPropertyValue(String name, Object instance, Object value) {
        MapProperty prop = new MapProperty(this.converter, name);
        if (value instanceof AbstractInstanciator) {
            ((AbstractInstanciator)value).addReferer(instance, prop);
        } else {
            ((Property)prop).setProperty(instance, value);
        }
    }

    public String toString() {
        return this.getClass().getName() + " {\n  type=" + this.type + ",\n  encoding=" + this.encoding + ",\n  externalizer=" + this.externalizer + ",\n  converter=" + this.converter + ",\n  properties=" + this.properties + "\n}";
    }
}

