/*
 * Decompiled with CFR 0.152.
 */
package com.ats.flex.messaging.amf.io;

import com.ats.AtsLog;
import com.ats.flex.amf.AMF3Constants;
import com.ats.flex.messaging.amf.io.util.ActionScriptClassDescriptor;
import com.ats.flex.messaging.amf.io.util.DefaultActionScriptClassDescriptor;
import com.ats.flex.messaging.amf.io.util.externalizer.Externalizer;
import com.ats.flex.messaging.amf.io.util.instanciator.AbstractInstanciator;
import com.ats.flex.messaging.util.StringUtil;
import com.ats.flex.messaging.util.XMLUtil;
import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class AMF3Deserializer
extends DataInputStream
implements ObjectInput,
AMF3Constants {
    protected static final Log log = new AtsLog();
    protected static final Log logMore = new AtsLog();
    protected final boolean debug = false;
    protected final boolean debugMore = false;
    protected final List<String> storedStrings = new ArrayList<String>();
    protected final List<Object> storedObjects = new ArrayList<Object>();
    protected final List<ActionScriptClassDescriptor> storedClassDescriptors = new ArrayList<ActionScriptClassDescriptor>();
    protected final XMLUtil xmlUtil = new XMLUtil();

    public AMF3Deserializer(InputStream in) {
        super(in);
    }

    @Override
    public Object readObject() throws IOException {
        int type = this.readAMF3Integer();
        return this.readObject(type);
    }

    protected Object readObject(int type) throws IOException {
        switch (type) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 3: {
                return Boolean.TRUE;
            }
            case 4: {
                return this.readAMF3Integer();
            }
            case 5: {
                return this.readAMF3Double();
            }
            case 6: {
                return this.readAMF3String();
            }
            case 7: {
                return this.readAMF3Xml();
            }
            case 8: {
                return this.readAMF3Date();
            }
            case 9: {
                return this.readAMF3Array();
            }
            case 10: {
                return this.readAMF3Object();
            }
            case 11: {
                return this.readAMF3XmlString();
            }
            case 12: {
                return this.readAMF3ByteArray();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected int readAMF3Integer() throws IOException {
        int n;
        int result = 0;
        int b = this.readUnsignedByte();
        for (n = 0; (b & 0x80) != 0 && n < 3; ++n) {
            result <<= 7;
            result |= b & 0x7F;
            b = this.readUnsignedByte();
        }
        if (n < 3) {
            result <<= 7;
            result |= b;
        } else {
            result <<= 8;
            if (((result |= b) & 0x10000000) != 0) {
                result |= 0xE0000000;
            }
        }
        return result;
    }

    protected Double readAMF3Double() throws IOException {
        double d = this.readDouble();
        Double result = Double.isNaN(d) ? null : Double.valueOf(d);
        return result;
    }

    protected String readAMF3String() throws IOException {
        String result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredStrings(type >> 1);
        } else {
            int length = type >> 1;
            if (length > 0) {
                byte[] utfBytes = new byte[length];
                char[] utfChars = new char[length];
                this.readFully(utfBytes);
                int iBytes = 0;
                int iChars = 0;
                block4: while (iBytes < length) {
                    int c;
                    if ((c = utfBytes[iBytes++] & 0xFF) <= 127) {
                        utfChars[iChars++] = (char)c;
                        continue;
                    }
                    switch (c >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = utfBytes[iBytes++];
                            if ((c2 & 0xC0) != 128) {
                                throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 2));
                            }
                            utfChars[iChars++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            continue block4;
                        }
                        case 14: {
                            byte c2 = utfBytes[iBytes++];
                            byte c3 = utfBytes[iBytes++];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 3));
                            }
                            utfChars[iChars++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            continue block4;
                        }
                    }
                    throw new UTFDataFormatException("Malformed input around byte " + (iBytes - 1));
                }
                result = new String(utfChars, 0, iChars);
                this.addToStoredStrings(result);
            } else {
                result = "";
            }
        }
        return result;
    }

    protected Date readAMF3Date() throws IOException {
        Date result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = (Date)this.getFromStoredObjects(type >> 1);
        } else {
            result = new Date((long)this.readDouble());
            this.addToStoredObjects(result);
        }
        return result;
    }

    protected Object readAMF3Array() throws IOException {
        Object result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int size = type >> 1;
            String key = this.readAMF3String();
            if (key.length() == 0) {
                Object[] objects = new Object[size];
                this.addToStoredObjects(objects);
                for (int i = 0; i < size; ++i) {
                    objects[i] = this.readObject();
                }
                result = objects;
            } else {
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                this.addToStoredObjects(map);
                while (key.length() > 0) {
                    map.put(key, this.readObject());
                    key = this.readAMF3String();
                }
                for (int i = 0; i < size; ++i) {
                    map.put(i, this.readObject());
                }
                result = map;
            }
        }
        return result;
    }

    protected Object readAMF3Object() throws IOException {
        Object result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredObjects(type >> 1);
        } else {
            int i;
            boolean inlineClassDef = (type >> 1 & 1) != 0;
            ActionScriptClassDescriptor desc = null;
            if (inlineClassDef) {
                int propertiesCount = type >> 4;
                byte encoding = (byte)(type >> 2 & 3);
                String className = this.readAMF3String();
                desc = new DefaultActionScriptClassDescriptor(className, encoding);
                this.addToStoredClassDescriptors(desc);
                for (i = 0; i < propertiesCount; ++i) {
                    String name = this.readAMF3String();
                    desc.defineProperty(name);
                }
            } else {
                desc = this.getFromStoredClassDescriptors(type >> 2);
            }
            byte objectEncoding = desc.getEncoding();
            Externalizer externalizer = desc.getExternalizer();
            if (externalizer != null) {
                try {
                    result = externalizer.newInstance(desc.getType(), this);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate type: " + desc.getType(), e);
                }
            } else {
                result = desc.newJavaInstance();
            }
            int index = this.addToStoredObjects(result);
            if ((objectEncoding & 1) != 0) {
                if (externalizer != null) {
                    try {
                        externalizer.readExternal(result, this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not read externalized object: " + String.valueOf(result), e);
                    }
                } else {
                    try {
                        ((Externalizable)result).readExternal(this);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not read externalizable object: " + String.valueOf(result), e);
                    }
                }
            } else {
                Object value;
                if (desc.getPropertiesCount() > 0) {
                    for (i = 0; i < desc.getPropertiesCount(); ++i) {
                        byte vType = this.readByte();
                        value = this.readObject(vType);
                        if ("bound".equals(desc.getPropertyName(i))) {
                            System.out.println("ok");
                        }
                        desc.setPropertyValue(i, result, value);
                    }
                }
                if (objectEncoding == 2) {
                    String name;
                    while ((name = this.readAMF3String()).length() != 0) {
                        byte vType = this.readByte();
                        value = this.readObject(vType);
                        desc.setPropertyValue(name, result, value);
                    }
                }
            }
            if (result instanceof AbstractInstanciator) {
                try {
                    result = ((AbstractInstanciator)result).resolve();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate object: " + String.valueOf(result), e);
                }
                this.setStoredObject(index, result);
            }
        }
        return result;
    }

    protected Document readAMF3Xml() throws IOException {
        String xml = this.readAMF3XmlString();
        Document result = this.xmlUtil.buildDocument(xml);
        return result;
    }

    protected String readAMF3XmlString() throws IOException {
        String result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = this.getFromStoredStrings(type >> 1);
        } else {
            byte[] bytes = this.readBytes(type >> 1);
            result = new String(bytes, "UTF-8");
            this.addToStoredStrings(result);
        }
        return result;
    }

    protected byte[] readAMF3ByteArray() throws IOException {
        byte[] result = null;
        int type = this.readAMF3Integer();
        if ((type & 1) == 0) {
            result = (byte[])this.getFromStoredObjects(type >> 1);
        } else {
            result = this.readBytes(type >> 1);
            this.addToStoredObjects(result);
        }
        return result;
    }

    protected void addToStoredStrings(String s) {
        this.storedStrings.add(s);
    }

    protected String getFromStoredStrings(int index) {
        String s = this.storedStrings.get(index);
        return s;
    }

    protected int addToStoredObjects(Object o) {
        int index = this.storedObjects.size();
        this.storedObjects.add(o);
        return index;
    }

    protected void setStoredObject(int index, Object o) {
        this.storedObjects.set(index, o);
    }

    protected Object getFromStoredObjects(int index) {
        Object o = this.storedObjects.get(index);
        return o;
    }

    protected void addToStoredClassDescriptors(ActionScriptClassDescriptor desc) {
        this.storedClassDescriptors.add(desc);
    }

    protected ActionScriptClassDescriptor getFromStoredClassDescriptors(int index) {
        ActionScriptClassDescriptor desc = this.storedClassDescriptors.get(index);
        return desc;
    }

    protected byte[] readBytes(int count) throws IOException {
        byte[] bytes = new byte[count];
        this.readFully(bytes);
        return bytes;
    }

    protected void debug(Object ... msgs) {
        this.debug(null, msgs);
    }

    protected void debug(Throwable t, Object ... msgs) {
        String message = "";
        if (msgs != null && msgs.length > 0) {
            if (msgs.length == 1) {
                message = String.valueOf(msgs[0]);
            } else {
                StringBuilder sb = new StringBuilder();
                for (Object o : msgs) {
                    if (o instanceof String) {
                        sb.append(o);
                        continue;
                    }
                    sb.append(StringUtil.toString(o));
                }
                message = sb.toString();
            }
        }
        if (t != null) {
            log.debug((Object)message, t);
        } else {
            log.debug((Object)message);
        }
    }
}

