/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class AtsLauncher {
    private static String atsToolsServerUrl = "https://actiontestscript.com/";
    private static String atsToolsServerUrlPath = "tools/versions.php";
    private static String suiteFiles = "suite";
    private static String reportLevel = "1";
    private static String target = "target";
    private static String atsOutput = target + "/ats-output";
    private static final ArrayList<AtsToolEnvironment> atsToolsEnv = new ArrayList();
    private static final Path atsToolsPath = Paths.get(System.getProperty("user.home"), ".actiontestscript", "tools");
    private static String atsHomePath = null;
    private static String jdkHomePath = null;

    public static void main(String[] args) throws Exception, InterruptedException {
        String jenkinsToolsUrl = null;
        boolean buildEnvironment = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-buildEnvironment")) {
                buildEnvironment = true;
                continue;
            }
            if (args[i].startsWith("-suiteXmlFiles=")) {
                suiteFiles = args[i].substring(15);
                continue;
            }
            if (args[i].startsWith("-ats-report=")) {
                reportLevel = args[i].substring(12);
                continue;
            }
            if (args[i].startsWith("-reportsDirectory=")) {
                atsOutput = args[i].substring(18);
                continue;
            }
            if (!args[i].startsWith("-jenkinsUrl=")) continue;
            jenkinsToolsUrl = args[i].substring(12);
        }
        AtsLauncher.deleteDirectory(Paths.get(target, new String[0]));
        AtsLauncher.deleteDirectory(Paths.get("test-output", new String[0]));
        ArrayList<CallSite> envList = new ArrayList<CallSite>();
        atsToolsEnv.add(new AtsToolEnvironment("ats"));
        atsToolsEnv.add(new AtsToolEnvironment("jasper"));
        atsToolsEnv.add(new AtsToolEnvironment("jdk"));
        if (jenkinsToolsUrl != null) {
            AtsLauncher.checkAtsToolsVersions(jenkinsToolsUrl, true, "userContent", "tools", "versions.csv");
        } else {
            AtsLauncher.checkAtsToolsVersions(atsToolsServerUrl, false, atsToolsServerUrlPath);
        }
        atsToolsEnv.stream().forEach(e -> AtsLauncher.installAtsTool(e, envList));
        if (buildEnvironment) {
            Path buildProperties = Paths.get("build.properties", new String[0]);
            Files.deleteIfExists(buildProperties);
            Files.write(buildProperties, String.join((CharSequence)"\n", envList).getBytes(), StandardOpenOption.CREATE);
        } else {
            Map<String, String> userEnv = System.getenv();
            for (String envName : userEnv.keySet()) {
                envList.add(0, (CallSite)((Object)(envName + "=" + userEnv.get(envName))));
            }
            String[] envArray = envList.toArray(new String[envList.size()]);
            File currentDirectory = Paths.get("", new String[0]).toAbsolutePath().toFile();
            Path generatedPath = Paths.get(target, "generated");
            File generatedSourceDir = generatedPath.toFile();
            String generatedSourceDirPath = generatedSourceDir.getAbsolutePath();
            generatedSourceDir.mkdirs();
            AtsLauncher.printLog("Current directory -> " + currentDirectory.getAbsolutePath());
            AtsLauncher.printLog("Generated java files -> " + generatedSourceDirPath);
            FullLogConsumer logConsumer = new FullLogConsumer();
            StringBuilder javaBuild = new StringBuilder("\"").append(Paths.get(jdkHomePath, new String[0]).toAbsolutePath().toString()).append("/bin/java");
            AtsLauncher.execute(new StringBuilder(javaBuild).append("\" -cp ").append(atsHomePath).append("/libs/* com.ats.generator.Generator -prj \"").append(currentDirectory.getAbsolutePath()).append("\" -dest " + target + "/generated -force -suites ").append(suiteFiles), envArray, currentDirectory, logConsumer, logConsumer);
            ArrayList<String> files = AtsLauncher.listJavaClasses(generatedSourceDirPath.length() + 1, generatedSourceDir);
            Path classFolder = Paths.get(target, "classes").toAbsolutePath();
            Path classFolderAssets = classFolder.resolve("assets");
            classFolderAssets.toFile().mkdirs();
            AtsLauncher.copyFolder(Paths.get("src", "assets"), classFolderAssets);
            AtsLauncher.printLog("Compile classes to folder -> " + classFolder.toString());
            Files.write(generatedPath.resolve("JavaClasses.list"), String.join((CharSequence)"\n", files).getBytes(), StandardOpenOption.CREATE);
            AtsLauncher.execute(new StringBuilder(javaBuild).append("c\"").append(" -cp ").append(atsHomePath).append("/libs/* -d \"").append(classFolder.toString()).append("\" @JavaClasses.list"), envArray, generatedPath.toAbsolutePath().toFile(), logConsumer, logConsumer);
            AtsLauncher.printLog("Launch suite(s) execution -> " + suiteFiles);
            AtsLauncher.execute(new StringBuilder(javaBuild).append("\"").append(" -Dats-report=").append(reportLevel).append(" -cp ").append(atsHomePath).append("/libs/*").append(File.pathSeparator).append(target).append("/classes").append(File.pathSeparator).append("libs/* org.testng.TestNG").append(" -d ").append(atsOutput).append(" ").append(target).append("/suites.xml"), envArray, currentDirectory, logConsumer, new TestNGLogConsumer());
            AtsLauncher.copyFolder(Paths.get(atsOutput, new String[0]), Paths.get("test-output", new String[0]), p -> !p.getFileName().toString().endsWith(".atsv") && !p.getFileName().toString().endsWith(".jpeg"));
        }
    }

    private static Map<String, String[]> getServerToolsVersion(String server, String path) {
        HashMap<String, String[]> versions = new HashMap<String, String[]>();
        try {
            String inputLine;
            URL url = new URL(server + path);
            URLConnection yc = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                String[] lineData = inputLine.split(",");
                versions.put(lineData[0], lineData);
            }
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return versions;
    }

    private static void checkAtsToolsVersions(String server, boolean localServer, String ... path) {
        AtsLauncher.printLog("Using ATS tools server -> " + server);
        Map<String, String[]> versions = AtsLauncher.getServerToolsVersion(server, String.join((CharSequence)"/", path));
        if (versions.size() < 3 && localServer) {
            AtsLauncher.printLog("Unable to get all ATS tools on this server -> " + server);
            versions.putAll(AtsLauncher.getServerToolsVersion(atsToolsServerUrl, atsToolsServerUrlPath));
            if (versions.size() < 3) {
                AtsLauncher.printLog("Some ATS tools are missing, try to find them on local system ...");
                return;
            }
        }
        for (AtsToolEnvironment t : atsToolsEnv) {
            String folderName;
            String[] toolData = versions.get(t.name);
            t.folderName = folderName = toolData[2];
            File toolFolder = atsToolsPath.resolve(folderName).toFile();
            if (toolFolder.exists()) {
                t.folder = toolFolder.getAbsolutePath();
                continue;
            }
            t.url = toolData[3];
        }
    }

    private static void installAtsTool(AtsToolEnvironment tool, List<String> envList) {
        if (tool.folderName == null) {
            File[] files = atsToolsPath.toFile().listFiles();
            Arrays.sort(files, Comparator.comparingLong(File::lastModified));
            for (File f : files) {
                if (!f.getName().startsWith(tool.name)) continue;
                tool.folderName = f.getName();
                tool.folder = f.getAbsolutePath();
                break;
            }
        } else {
            try {
                HttpURLConnection con;
                int fileLength;
                File tmpZipFile = Files.createTempDirectory("atsTool_", new FileAttribute[0]).resolve(tool.folderName + ".zip").toAbsolutePath().toFile();
                if (tmpZipFile.exists()) {
                    tmpZipFile.delete();
                }
                IntConsumer consume = (fileLength = (con = (HttpURLConnection)new URL(tool.url).openConnection()).getContentLength()) == -1 ? p -> System.out.println("Download [" + tool.name + "] -> " + p + " Mo") : p -> System.out.println("Download [" + tool.name + "] -> " + p + " %");
                ReadableConsumerByteChannel rcbc = new ReadableConsumerByteChannel(Channels.newChannel(con.getInputStream()), fileLength, consume);
                FileOutputStream fosx = new FileOutputStream(tmpZipFile);
                fosx.getChannel().transferFrom(rcbc, 0L, Long.MAX_VALUE);
                fosx.close();
                byte[] buffer = new byte[1024];
                ZipInputStream zis = new ZipInputStream(new FileInputStream(tmpZipFile));
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    File newFile = AtsLauncher.newFile(atsToolsPath.toFile(), zipEntry);
                    if (newFile != null && !newFile.exists()) {
                        if (zipEntry.isDirectory()) {
                            if (!newFile.isDirectory() && !newFile.mkdirs()) {
                                throw new IOException("Failed to create directory " + newFile);
                            }
                        } else {
                            int len;
                            File parent = newFile.getParentFile();
                            if (!parent.isDirectory() && !parent.mkdirs()) {
                                throw new IOException("Failed to create directory " + parent);
                            }
                            FileOutputStream fos = new FileOutputStream(newFile);
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                            fos.close();
                        }
                    }
                    zis.closeEntry();
                    zipEntry = zis.getNextEntry();
                }
                zis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tool.folder = atsToolsPath.resolve(tool.folderName).toFile().getAbsolutePath();
        }
        if (tool.folder == null) {
            throw new RuntimeException("ATS tool is not installed on this system -> " + tool.name);
        }
        envList.add(tool.envName + "=" + tool.folder);
        AtsLauncher.printLog("Set environment variable [" + tool.envName + "] -> " + tool.folder);
        if ("ats".equals(tool.name)) {
            atsHomePath = tool.folder;
        } else if ("jdk".equals(tool.name)) {
            jdkHomePath = tool.folder;
        }
    }

    private static void printLog(String data) {
        System.out.println("[ATS-LAUNCHER] " + data);
    }

    private static void execute(StringBuilder command, String[] envp, File currentDir, Consumer<String> outputConsumer, Consumer<String> errorConsumer) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(command.toString(), envp, currentDir);
        new StreamGobbler(p.getErrorStream(), errorConsumer).start();
        new StreamGobbler(p.getInputStream(), outputConsumer).start();
        p.waitFor();
    }

    private static void copyFolder(Path src, Path dest, Predicate<Path> p) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.filter(p).forEach(source -> AtsLauncher.copy(source, dest.resolve(src.relativize((Path)source))));
        }
    }

    private static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> AtsLauncher.copy(source, dest.resolve(src.relativize((Path)source))));
        }
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static ArrayList<String> listJavaClasses(int subLen, File directory) {
        ArrayList<String> list = new ArrayList<String>();
        File[] fList = directory.listFiles();
        if (fList == null) {
            throw new RuntimeException("Directory list files return null value ! (" + directory.getAbsolutePath() + ")");
        }
        for (File file : fList) {
            if (file.isFile()) {
                if (!file.getName().endsWith(".java")) continue;
                list.add(file.getAbsolutePath().substring(subLen).replaceAll("\\\\", "/"));
                continue;
            }
            if (!file.isDirectory()) continue;
            list.addAll(AtsLauncher.listJavaClasses(subLen, file));
        }
        return list;
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        if (destFile.getCanonicalPath().startsWith(destinationDir.getCanonicalPath() + File.separator)) {
            return destFile;
        }
        return null;
    }

    private static void deleteDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path directory, IOException ioException) throws IOException {
                    Files.delete(directory);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static class AtsToolEnvironment {
        public String name;
        public String envName;
        public String folder;
        public String folderName;
        public String url;

        public AtsToolEnvironment(String name) {
            this.name = name;
            this.envName = name.toUpperCase() + "_HOME";
        }
    }

    private static class FullLogConsumer
    implements Consumer<String> {
        private FullLogConsumer() {
        }

        @Override
        public void accept(String s) {
            System.out.println(s);
        }
    }

    private static class TestNGLogConsumer
    implements Consumer<String> {
        private TestNGLogConsumer() {
        }

        @Override
        public void accept(String s) {
            System.out.println(s.replace("[TestNG]", "").replace("[main] INFO org.testng.internal.Utils -", "[TestNG]").replace("Warning: [org.testng.ITest]", "[TestNG] Warning :").replace("[main] INFO org.testng.TestClass", "[TestNG]"));
        }
    }

    private static class ReadableConsumerByteChannel
    implements ReadableByteChannel {
        private final ReadableByteChannel rbc;
        private final IntConsumer onRead;
        private final int totalBytes;
        private int totalByteRead;
        private int currentPercent = 0;

        public ReadableConsumerByteChannel(ReadableByteChannel rbc, int totalBytes, IntConsumer onBytesRead) {
            this.rbc = rbc;
            this.totalBytes = totalBytes;
            this.onRead = onBytesRead;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int nRead = this.rbc.read(dst);
            this.notifyBytesRead(nRead);
            return nRead;
        }

        protected void notifyBytesRead(int nRead) {
            if (nRead <= 0) {
                return;
            }
            this.totalByteRead += nRead;
            if (this.totalBytes != -1) {
                int percent = (int)((float)this.totalByteRead / (float)this.totalBytes * 100.0f);
                if (percent % 5 == 0 && this.currentPercent != percent) {
                    this.currentPercent = percent;
                    this.onRead.accept(this.currentPercent);
                }
            } else if (this.totalByteRead % 10000 == 0) {
                this.onRead.accept(this.totalByteRead / 10000);
            }
        }

        @Override
        public boolean isOpen() {
            return this.rbc.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.rbc.close();
        }
    }

    private static class StreamGobbler
    extends Thread {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

