/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.crypto.Passwords;
import com.ats.element.SearchedElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ExecutionListener;
import com.ats.executor.ScriptStatus;
import com.ats.executor.StopExecutionThread;
import com.ats.executor.TestListener;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.ChannelManager;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.objects.mouse.MouseKey;
import com.ats.generator.objects.mouse.MouseScroll;
import com.ats.generator.objects.mouse.MouseSwipe;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.ConditionalValue;
import com.ats.generator.variables.RandomStringValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.NumericTransformer;
import com.ats.generator.variables.transform.RegexpTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.generator.variables.transform.Transformer;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.VisualRecorder;
import com.ats.recorder.VisualRecorderNull;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionComment;
import com.ats.script.actions.ActionExecute;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.logger.levels.AtsFailError;
import com.ats.tools.report.SuitesReportItem;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.TestRunner;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Listeners;

@Listeners(value={ExecutionListener.class, TestListener.class})
public class ActionTestScript
extends Script {
    public static final String MAIN_TEST_FUNCTION = "testMain";
    public static final String TEST_STOPPABLE = "com.ats.test.stoppable";
    public static final String SUITE_PARAMETERS = "parameters.txt";
    protected ActionTestScript topScript;
    private String[] returnValues;
    private Project projectData;
    private ScriptStatus status = new ScriptStatus();
    public static final String JAVA_VAR_FUNCTION_NAME = "var";
    public static final String JAVA_GLOBAL_VAR_FUNCTION_NAME = "gvar";
    public static final String JAVA_VALUE_FUNCTION_NAME = "clv";
    public static final String JAVA_PARAM_FUNCTION_NAME = "prm";
    public static final String JAVA_RETURNS_FUNCTION_NAME = "rtn";
    public static final String JAVA_RNDSTRING_FUNCTION_NAME = "rds";
    public static final String JAVA_ENV_FUNCTION_NAME = "env";
    public static final String JAVA_SYSTEM_FUNCTION_NAME = "sys";
    public static final String JAVA_PROPERTY_FUNCTION_NAME = "prp";
    public static final String JAVA_UUID_FUNCTION_NAME = "uid";
    public static final String JAVA_TODAY_FUNCTION_NAME = "td";
    public static final String JAVA_NOW_FUNCTION_NAME = "nw";
    public static final String JAVA_ITERATION_FUNCTION_NAME = "itr";
    public static final String JAVA_ELEMENT_FUNCTION_NAME = "el";
    public static final String JAVA_REGEX_FUNCTION_NAME = "rx";
    public static final String JAVA_DATE_FUNCTION_NAME = "dt";
    public static final String JAVA_TIME_FUNCTION_NAME = "tm";
    public static final String JAVA_NUMERIC_FUNCTION_NAME = "nm";
    public static final String JAVA_POS_FUNCTION_NAME = "ps";
    public static final String JAVA_MOUSE_FUNCTION_NAME = "ms";
    public static final String JAVA_EMBEDED_FUNCTION_NAME = "emb";
    public static final String JAVA_GAV_FUNCTION_NAME = "gav";
    public static final String JAVA_CONDITION_FUNCTION = "condition";
    private ConditionalValue condition;
    public static final String JAVA_EXECUTE_FUNCTION_NAME = "exec";
    private boolean dragWithDesktop = false;
    private IVisualRecorder recorder = new VisualRecorderNull();

    protected ScriptHeader getHeader() {
        return new ScriptHeader();
    }

    public ActionTestScript() {
        super(null);
        this.init(new Passwords(this.getAssetsFile("")));
    }

    public ActionTestScript(File assetsFolder) {
        super(null);
        this.init(new Passwords(assetsFolder.toPath()));
    }

    public ActionTestScript(ExecutionLogger logger) {
        super(logger);
        this.init(null);
    }

    public ActionTestScript(ActionTestScript topScript) {
        this.setTopScript(topScript);
    }

    public void setTopScript(ActionTestScript topScript, String scriptName) {
        this.setTopScript(topScript);
        this.setTestName(scriptName);
        topScript.addToScriptCallTree(this, scriptName);
    }

    public void setTopScript(ActionTestScript topScript) {
        this.init(topScript, topScript.getChannelManager(), topScript.getPasswords());
    }

    private void init(Passwords passwords) {
        this.init(this, new ChannelManager(this), passwords);
    }

    private void init(ActionTestScript topScript, ChannelManager channelManager, Passwords passwords) {
        this.topScript = topScript;
        this.channelManager = channelManager;
        this.passwords = passwords;
        Logger.getLogger("org.openqa.selenium").setLevel(Level.OFF);
        Logger.getLogger(Actions.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);
    }

    public String[] getReturnValues() {
        return this.returnValues;
    }

    public Passwords getPasswords() {
        return this.passwords;
    }

    public void updateTestName(String name) {
        this.setTestName(name);
    }

    public void scriptFail(String message) {
        Assert.fail((String)message);
    }

    public void addErrorStack(String value) {
        this.status.addErrorStack(value);
    }

    public ScriptStatus getStatus() {
        return this.status;
    }

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext ctx) {
        SuitesReportItem currentSuite = new SuitesReportItem(this.gav(), (TestRunner)ctx);
        this.setLogger(new ExecutionLogger(System.out, currentSuite.logLevel));
        this.sendScriptInfo(currentSuite.getStartLog());
        ExecutionListener.startSuite(currentSuite);
    }

    @AfterSuite(alwaysRun=true)
    public void afterSuite(ITestContext ctx) {
        this.sendScriptInfo("Suite terminated -> " + ctx.getSuite().getName());
    }

    @BeforeClass(alwaysRun=true)
    public void beforeClass(ITestContext ctx) {
        TestRunner runner = (TestRunner)ctx;
        String suiteName = ctx.getSuite().getName();
        SuitesReportItem currentSuite = new SuitesReportItem((TestRunner)ctx);
        this.setLogger(new ExecutionLogger(System.out, currentSuite.logLevel));
        this.setTestName(((Object)((Object)this)).getClass().getName());
        this.scriptCallTree = new ArrayList<ActionTestScript>(Arrays.asList(this));
        this.status = new ScriptStatus(this.getTestName(), suiteName);
        if ("true".equalsIgnoreCase(runner.getTest().getParameter("check.mode"))) {
            throw new SkipException("check mode : " + this.getTestName());
        }
        Map params = runner.getTest().getAllParameters();
        this.setTestExecutionVariables(params);
        int visualQuality = Utils.string2Int(this.getEnvironmentValue("visual.report", "0"));
        boolean xml = this.getEnvironmentValue("xml.report", "").equalsIgnoreCase("true");
        String atsReport = System.getProperty("ats-report");
        if (atsReport != null && !atsReport.equals("0")) {
            if (visualQuality == 0) {
                visualQuality = 3;
            }
            xml = true;
        }
        if (visualQuality > 0 || xml) {
            ScriptHeader header = this.getHeader();
            header.setName(this.getTestName());
            File output = new File(runner.getOutputDirectory());
            if (!output.exists()) {
                output.mkdirs();
            }
            this.setRecorder(new VisualRecorder(this, output, header, xml, visualQuality, this.logger));
        }
        JsonObject logs = new JsonObject();
        logs.addProperty("suite", suiteName);
        logs.addProperty("xmlReport", Boolean.valueOf(xml));
        logs.addProperty("visualQuality", (Number)visualQuality);
        Properties parametersProperties = new Properties();
        JsonArray parametersArray = new JsonArray();
        for (Map.Entry param : params.entrySet()) {
            String k = (String)param.getKey();
            String v = this.getEnvironmentValue(k, (String)param.getValue());
            parametersProperties.put(k, v);
            JsonObject elem = new JsonObject();
            elem.addProperty(k, v);
            parametersArray.add((JsonElement)elem);
        }
        logs.add("parameters", (JsonElement)parametersArray);
        try {
            parametersProperties.store(new FileOutputStream(Paths.get(runner.getOutputDirectory(), SUITE_PARAMETERS).toFile()), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sendScriptInfo("Starting script (" + this.getTestName() + ") -> " + logs.toString());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ActionTestScript.this.tearDown();
            }
        });
        if ("true".equals(System.getProperty(TEST_STOPPABLE))) {
            this.sendScriptInfo("This script can be stopped if 'q' is sent to 'System.in' stream");
            new StopExecutionThread(this, System.in).start();
        }
    }

    @AfterClass(alwaysRun=true)
    public void afterClass(ITestContext ctx) {
        TestRunner runner = (TestRunner)ctx;
        this.status.endLogs(this, runner);
    }

    @AfterTest(alwaysRun=true)
    public void testFinished(ITestContext ctx) {
    }

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        this.sendScriptFail(this.status.getCallscriptStack());
        this.stopRecorder();
        this.tearDown();
    }

    public Channel getCurrentChannel() {
        return this.getChannelManager().getCurrentChannel();
    }

    public Channel getChannel(String name) {
        return this.getChannelManager().getChannel(name);
    }

    public ActionTestScript getTopScript() {
        return this.topScript;
    }

    public void initCalledScript(ActionTestScript atsCaller, String testName, int line, ParameterList parameters, List<Variable> variables, int iteration, int iterationMax, String scriptName, String type, String filePath) {
        this.iteration = iteration;
        this.csvAbsoluteFilePath = filePath;
        this.setTestName(((Object)((Object)this)).getClass().getName());
        JsonObject log = atsCaller.getConditionLogs();
        log.addProperty("called", scriptName);
        log.addProperty("iteration", iteration + 1 + "/" + iterationMax);
        log.addProperty("type", type);
        if (filePath != null) {
            log.addProperty("url", filePath);
        }
        if (parameters != null) {
            this.setParameterList(parameters);
            if (parameters.getList().size() > 0) {
                JsonArray parametersArray = new JsonArray();
                for (Parameter p : parameters.getList()) {
                    JsonObject jso = new JsonObject();
                    jso.addProperty(p.getName(), p.getCalculated());
                    parametersArray.add((JsonElement)jso);
                }
                log.add("parameters", (JsonElement)parametersArray);
            }
        }
        if (variables != null) {
            this.setVariables(variables);
        }
        this.setTestExecutionVariables(this.topScript.getTestExecutionVariables());
        this.topScript.sendScriptInfo(ActionCallscript.getScriptLog(testName, line, log));
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public void setProjectData(Project value) {
        this.projectData = value;
        this.projectData.synchronize();
        this.passwords = new Passwords(this.projectData.getAssetsFolderPath().toFile());
    }

    public void tearDown() {
        this.sendInfoLog("Drivers", "closing ...");
        this.getChannelManager().tearDown();
    }

    public Variable var(String name, CalculatedValue value) {
        return this.createVariable(name, value, null);
    }

    public Variable var(String name) {
        return this.createVariable(name, new CalculatedValue(""), null);
    }

    public Variable var(String name, Transformer transformer) {
        return this.createVariable(name, new CalculatedValue(""), transformer);
    }

    public Variable var(String name, CalculatedValue value, Transformer transformer) {
        return this.createVariable(name, value, transformer);
    }

    public String gvar(String varPath) {
        return this.topScript.getGlobalVariableValue(varPath);
    }

    public CalculatedValue clv(Object ... data) {
        return new CalculatedValue(this, data);
    }

    public String prm(String name) {
        return this.getParameterValue(name);
    }

    public String prm(String name, String defaultValue) {
        return this.getParameterValue(name, defaultValue);
    }

    public String prm(int index) {
        return this.getParameterValue(index);
    }

    public String prm(int index, String defaultValue) {
        return this.getParameterValue(index, defaultValue);
    }

    public CalculatedValue[] prm(CalculatedValue ... values) {
        return values;
    }

    public void rtn(CalculatedValue ... values) {
        int i = 0;
        this.returnValues = new String[values.length];
        for (CalculatedValue calc : values) {
            this.returnValues[i] = calc.getCalculated();
            ++i;
        }
        this.updateVariables();
    }

    public void rtn(String ... values) {
        int i = 0;
        this.returnValues = new String[values.length];
        String[] stringArray = values;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String value;
            this.returnValues[i] = value = stringArray[j];
            ++i;
        }
        this.updateVariables();
    }

    private void updateVariables() {
        List<Variable> variables = this.getVariables();
        int index = 0;
        for (String value : this.returnValues) {
            if (variables.size() < index + 1) break;
            variables.get(index).setData(value);
            ++index;
        }
    }

    public void returnValues(String ... values) {
        this.returnValues = values;
        this.updateVariables();
    }

    public void returnValues(Object ... values) {
        this.returnValues = (String[])Arrays.stream(values).map(Object::toString).toArray(String[]::new);
        this.updateVariables();
    }

    public String rds(int len) {
        return new RandomStringValue(len, null).exec();
    }

    public String rds(int len, String type) {
        return new RandomStringValue(len, type).exec();
    }

    public String env(String name) {
        return this.getEnvironmentValue(name, "");
    }

    public String env(String name, String defaultValue) {
        return this.getEnvironmentValue(name, defaultValue);
    }

    public String sys(String name) {
        return this.getSystemValue(name);
    }

    public CalculatedProperty prp(String type, String name, CalculatedValue value) {
        return new CalculatedProperty(type, name, value);
    }

    public String uid() {
        return this.getUuidValue();
    }

    public String td() {
        return this.getTodayValue();
    }

    public String nw() {
        return this.getNowValue();
    }

    public int itr() {
        return this.getIteration();
    }

    public SearchedElement el(SearchedElement parent, int index, String tagName, CalculatedProperty ... properties) {
        return new SearchedElement(parent, index, tagName, properties);
    }

    public SearchedElement el(int index, String tagName, CalculatedProperty ... properties) {
        return new SearchedElement(null, index, tagName, properties);
    }

    public RegexpTransformer rx(String patt, int group) {
        return new RegexpTransformer(patt, group);
    }

    public DateTransformer dt(String ... data) {
        return new DateTransformer(data);
    }

    public TimeTransformer tm(String ... data) {
        return new TimeTransformer(data);
    }

    public NumericTransformer nm(int dp, boolean comma) {
        return new NumericTransformer(dp, comma);
    }

    public MouseDirectionData ps(Cartesian cart, CalculatedValue value) {
        return new MouseDirectionData(cart, value);
    }

    public Mouse ms(String type) {
        return new Mouse(type);
    }

    public Mouse ms(String type, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new Mouse(type, hpos, vpos);
    }

    public MouseKey ms(String type, Keys key, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseKey(type, key, hpos, vpos);
    }

    public MouseKey ms(String type, Keys key) {
        return new MouseKey(type, key);
    }

    public MouseScroll ms(int scroll, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseScroll(scroll, hpos, vpos);
    }

    public MouseScroll ms(int scroll) {
        return new MouseScroll(scroll);
    }

    public MouseSwipe ms(MouseDirectionData hdir, MouseDirectionData vdir, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseSwipe(hdir, vdir, hpos, vpos);
    }

    public MouseSwipe ms(MouseDirectionData hdir, MouseDirectionData vdir) {
        return new MouseSwipe(hdir, vdir);
    }

    public String emb(String relativePath) {
        return this.getAssetsUrl(relativePath);
    }

    public String gav() {
        return "";
    }

    public boolean condition(String type, int line, Variable variable, CalculatedValue calculatedValue) {
        this.condition = new ConditionalValue(type, variable, calculatedValue);
        if (this.condition.isExec()) {
            return true;
        }
        this.getTopScript().sendScriptInfo(ActionCallscript.getScriptLog(this.getTestName(), line, this.condition.getLog()));
        this.condition = null;
        return false;
    }

    public JsonObject getConditionLogs() {
        JsonObject result = new JsonObject();
        if (this.condition != null) {
            result = this.condition.getLog(result);
            this.condition = null;
        }
        return result;
    }

    public void exec(int line, Action action) {
        try {
            action.execute(this, this.getTestName(), line);
        }
        catch (UnreachableBrowserException e) {
            action.failed(-17, "Browser driver not reachable, maybe channel have been closed !");
        }
        this.getTopScript().actionFinished(this.getTestName(), line, action);
    }

    public void exec(int line, ActionComment action) {
        if (action.execute(this, this.getTestName(), line)) {
            this.getTopScript().actionFinished(this.getTestName(), line, action);
        }
    }

    public void exec(int line, ActionCallscript action) {
        action.execute(this, this.getTestName(), line);
        this.getTopScript().actionFinished(this.getTestName(), line, action);
    }

    public void exec(int line, ActionExecute action) {
        try {
            action.execute(this, this.getTestName(), line);
        }
        catch (UnreachableBrowserException e) {
            action.failed(-17, "Browser driver not reachable, maybe channel have been closed !");
        }
        this.getTopScript().actionFinished(this.getTestName(), line, action, action.getStopPolicy());
    }

    private void failedAt(String actionClass, String script, int line, String app, int errorCode, String errorMessage) {
        this.status.failedAt(actionClass, script, line, app, errorCode, errorMessage);
        this.sendErrorLog(this.status.getErrorScript(), this.status.getErrorInfo());
    }

    public void actionFinished(String testName, int line, Action action) {
        this.actionFinished(testName, line, action, 0);
    }

    public void actionFinished(String testName, int line, Action action, int stopPolicy) {
        this.status.addAction(action instanceof ActionCallscript);
        ActionStatus actionStatus = action.getStatus();
        if (actionStatus.isPassed()) {
            this.sendActionLog(action, testName, line);
        } else if (stopPolicy == 0) {
            if (this.actionFinishedFail(actionStatus, action, line, testName)) {
                throw new AtsFailError(this.status.getErrorScript(), this.status.getErrorInfo());
            }
        } else {
            this.sendActionLog(action, testName, line);
            if (stopPolicy == 2) {
                this.actionFinishedFail(actionStatus, action, line, testName);
            }
        }
    }

    private boolean actionFinishedFail(ActionStatus actionStatus, Action action, int line, String testName) {
        if (this.status.isSuiteExecution()) {
            String app = actionStatus.getChannelApplication();
            String errorMessage = actionStatus.getFailMessage();
            this.getTopScript().failedAt(action.getClass().getSimpleName(), testName, line, app, actionStatus.getCode(), errorMessage);
            this.getRecorder().updateSummaryFail(testName, line, app, errorMessage);
            return true;
        }
        return false;
    }

    public void la(String message) {
        Assert.fail((String)message);
    }

    public void startDrag() {
        this.topScript.dragWithDesktop = this.getCurrentChannel().isDesktop();
    }

    public boolean isDesktopDragDrop() {
        return this.topScript.dragWithDesktop;
    }

    public void endDrag() {
        this.topScript.dragWithDesktop = false;
    }

    public IVisualRecorder getRecorder() {
        return this.topScript.recorder;
    }

    public void setRecorder(IVisualRecorder value) {
        if (value instanceof VisualRecorderNull && this.recorder instanceof VisualRecorder || value instanceof VisualRecorder && this.recorder instanceof VisualRecorderNull) {
            this.topScript.recorder.terminate();
            this.topScript.recorder = value;
        }
    }

    public void startRecorder(ScriptHeader info, int quality, boolean xml) {
        this.topScript.setRecorder(new VisualRecorder(this.topScript, info, this.projectData, xml, quality));
    }

    public void stopRecorder() {
        this.topScript.setRecorder(new VisualRecorderNull());
    }
}

