/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.channels;

import com.ats.driver.AtsManager;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.ScriptStatus;
import com.ats.executor.TestBound;
import com.ats.executor.channels.SystemValues;
import com.ats.executor.drivers.DriverManager;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.SapDriverEngine;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.generator.ATS;
import com.ats.generator.objects.BoundData;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.ReportSummary;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionApi;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionExecute;
import com.ats.script.actions.neoload.ActionNeoload;
import com.ats.script.actions.neoload.ActionNeoloadStop;
import com.ats.script.actions.performance.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.logger.levels.AtsFailError;
import com.ats.tools.performance.proxy.AtsNoProxy;
import com.ats.tools.performance.proxy.AtsProxy;
import com.ats.tools.performance.proxy.IAtsProxy;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebElement;

public class Channel {
    public static final String HTML = "html";
    public static final String DESKTOP = "desktop";
    public static final String DESKTOP_EXPLORER = "explorer";
    public static final String MOBILE = "mobile";
    public static final String API = "api";
    public static final String SAP = "sap";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String BASIC_AUTHENTICATION = "Basic";
    private IDriverEngine engine;
    private ActionChannelStart actionStart;
    private boolean current = false;
    private ActionTestScript mainScript;
    private final int scrollUnit = AtsManager.getScrollUnit();
    private TestBound dimension = AtsManager.getInstance().getApplicationBound();
    private TestBound subDimension = new TestBound();
    private String driverVersion = "";
    protected SystemValues systemValues = new SystemValues();
    private byte[] icon;
    private String screenServer;
    private ArrayList<String> operations = new ArrayList();
    private int winHandle = -1;
    private long processId = 0L;
    private String neoloadDesignApi;
    private String type = "html";
    private ArrayList<String> systemProperties = new ArrayList();
    private ArrayList<String> systemButtons = new ArrayList();
    private ActionNeoloadStop stopNeoloadRecord = null;
    private IAtsProxy atsProxy = new AtsNoProxy();

    public void addSystemProperties(Iterator<JsonNode> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.systemProperties.add(iterator.next().asText());
            }
        }
    }

    public void addSystemButtons(Iterator<JsonNode> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.systemButtons.add(iterator.next().asText());
            }
        }
    }

    public Channel() {
    }

    public Channel(ActionStatus status, ActionTestScript script, DriverManager driverManager, ActionChannelStart action) {
        DesktopDriver desktopDriver = new DesktopDriver(status, driverManager);
        if (status.isPassed()) {
            status.setChannel(this);
            this.systemValues.setOsName(desktopDriver.getOsName());
            this.systemValues.setApplicationName(action.getApplication().getCalculated());
            this.systemValues.setCountry(desktopDriver.getCountryCode());
            this.systemValues.setMachineName(desktopDriver.getMachineName());
            this.systemValues.setOsVersion(desktopDriver.getOsVersion());
            this.systemValues.setOsBuild(desktopDriver.getOsBuildVersion());
            this.mainScript = script;
            this.current = true;
            this.actionStart = action;
            this.engine = driverManager.getDriverEngine(this, status, desktopDriver);
            if (status.isPassed()) {
                this.systemValues.setApplicationPath(this.engine.getApplicationPath());
                this.refreshLocation();
                this.engine.started(status);
            }
        } else {
            throw new AtsFailError(status.getErrorType(), status.getMessage());
        }
        status.endDuration();
    }

    public void waitBeforeMouseMoveToElement(WebDriverEngine webDriverEngine) {
        AtsManager.getInstance().getWaitGuiReady().waitBeforeMouseMoveToElement(this, webDriverEngine);
    }

    public void waitBeforeSwitchWindow(WebDriverEngine webDriverEngine) {
        AtsManager.getInstance().getWaitGuiReady().waitBeforeSwitchWindow(this, webDriverEngine);
    }

    public void waitBeforeSearchElement(WebDriverEngine webDriverEngine) {
        AtsManager.getInstance().getWaitGuiReady().waitBeforeSearchElement(this, webDriverEngine);
    }

    public void waitBeforeEnterText(WebDriverEngine webDriverEngine) {
        AtsManager.getInstance().getWaitGuiReady().waitBeforeEnterText(this, webDriverEngine);
    }

    public void waitBeforeGotoUrl(WebDriverEngine webDriverEngine) {
        AtsManager.getInstance().getWaitGuiReady().waitBeforeGotoUrl(this, webDriverEngine);
    }

    public Class<ActionTestScript> loadTestScriptClass(String name) {
        return AtsManager.getInstance().loadTestScriptClass(name);
    }

    public ActionTestScript getTestScript() {
        return this.mainScript;
    }

    public String getTopScriptPackage() {
        String topScriptName = this.mainScript.getTopScript().getTestName();
        int lastDot = topScriptName.lastIndexOf(".");
        if (lastDot > 0) {
            return topScriptName.substring(0, lastDot);
        }
        return topScriptName;
    }

    public ActionStatus newActionStatus() {
        return new ActionStatus(this, "", 0);
    }

    public ActionStatus newActionStatus(String testName, int testLine) {
        return new ActionStatus(this, testName, testLine);
    }

    public DesktopDriver getDesktopDriver() {
        return this.engine.getDesktopDriver();
    }

    public void cleanHandle() {
        this.winHandle = -1;
        this.setWindowToFront();
    }

    public void setWinHandle(int hdl) {
        this.winHandle = hdl;
    }

    public void updateWinHandle(DesktopDriver drv, int index) {
        this.winHandle = this.getHandle(drv, index);
        this.getDesktopDriver().updateWindowHandle(this);
    }

    public int getHandle(DesktopDriver drv) {
        if (this.winHandle < 0) {
            this.winHandle = this.getHandle(drv, 0);
        }
        return this.winHandle;
    }

    public int getHandle() {
        return this.winHandle;
    }

    public int getHandle(DesktopDriver drv, int index) {
        List<DesktopWindow> processWindows = drv.getWindowsByPid(this.getProcessId());
        if (processWindows != null && processWindows.size() > index) {
            return processWindows.get(index).getHandle();
        }
        return -1;
    }

    public void refreshLocation() {
        this.engine.updateDimensions();
    }

    public void setDimensions(TestBound dim1, TestBound dim2) {
        this.setDimension(dim1);
        this.setSubDimension(dim2);
    }

    public double getOffsetY() {
        return this.dimension.getHeight() - this.subDimension.getHeight();
    }

    public void refreshMapElementLocation() {
        this.refreshLocation();
        this.engine.refreshElementMapLocation();
    }

    public void defineRoot(String id) {
        this.getDesktopDriver().defineRoot(this.dimension, id);
    }

    public void toFront() {
        this.getDesktopDriver().setChannelToFront(this.getHandle(this.getDesktopDriver()), this.processId);
    }

    public void setWindowToFront() {
        this.engine.setWindowToFront();
    }

    public String rootKeys(ActionStatus status, CalculatedValue text) {
        String t = text.getCalculated();
        this.getDesktopDriver().rootKeys(this.getHandle(this.getDesktopDriver()), t);
        this.actionTerminated(status);
        return t;
    }

    public String getSource() {
        return this.engine.getSource();
    }

    public void checkStatus(ActionExecute actionExecute, String testName, int testLine) {
    }

    public byte[] getScreenShot(TestBound dim) {
        dim.setX(dim.getX() + this.dimension.getX());
        dim.setY(dim.getY() + this.dimension.getY());
        return this.getScreenShotEngine(dim);
    }

    public byte[] getScreenShot() {
        return this.getScreenShotEngine(this.dimension);
    }

    private byte[] getScreenShotEngine(TestBound dim) {
        this.mainScript.sleep(50);
        return this.engine.getScreenshot(dim.getX(), dim.getY(), dim.getWidth(), dim.getHeight());
    }

    public String getAuthenticationValue() {
        return this.actionStart.getAuthenticationValue();
    }

    public ArrayList<CalculatedValue> getArguments() {
        return this.actionStart.getArguments();
    }

    public boolean isUseCookie() {
        return this.actionStart.isUseCookie();
    }

    public void setNeoloadDesignApi(String value) {
        this.neoloadDesignApi = value;
    }

    public void setApplicationData(String type, String os) {
        this.setType(type);
        this.icon = ResourceContent.getAtsByteLogo();
        this.driverVersion = ATS.VERSION;
        this.dimension = new TestBound(0.0, 0.0, 1.0, 1.0);
        this.systemValues.setOsName(os);
    }

    public void setApplicationData(String type, String os, String serviceType, ArrayList<String> op) {
        this.setType(type);
        this.systemValues.setOsName(os);
        this.systemValues.setApplicationName(serviceType);
        this.operations = op;
    }

    public void setApplicationData(String type, String os, String serviceType) {
        this.setType(type);
        this.systemValues.setOsName(os);
        this.systemValues.setApplicationName(serviceType);
    }

    public void setApplicationData(String type, String os, String version, String dv, long pid, byte[] ic, String screen) {
        this.setType(type);
        this.driverVersion = dv;
        this.processId = pid;
        this.icon = ic;
        this.screenServer = screen;
        this.systemValues.setOsName(os);
        this.systemValues.setApplicationVersion(version);
    }

    public void setApplicationData(String type, String os, int handle) {
        this.setType(type);
        this.driverVersion = "";
        this.winHandle = handle;
        this.systemValues.setOsName(os);
    }

    public void setApplicationData(String type, String os, String version, String dVersion, long pid) {
        this.setApplicationData(type, os, version, dVersion, pid, new byte[0], "");
    }

    public void setApplicationData(String type, String os, String name, String version, String dVersion, long pid, int handle, byte[] icon) {
        this.setApplicationData(type, os, version, dVersion, pid, icon, "");
        this.systemValues.setApplicationName(name);
        this.winHandle = handle;
    }

    public void setApplicationData(String type, String os, String name, String version, String dVersion, long pid) {
        this.setApplicationData(type, os, version, dVersion, pid, new byte[0], "");
        this.systemValues.setApplicationName(name);
    }

    public void setApplicationData(String type, String os, String version, String dVersion, long pid, long handle) {
        this.setApplicationData(type, os, version, dVersion, pid, new byte[0], "");
        this.winHandle = (int)handle;
    }

    public String getSystemValue(String name) {
        if (name != null) {
            return this.systemValues.get(name);
        }
        return "";
    }

    public void switchToFrame(String id) {
        this.engine.switchToFrameId(id);
    }

    public void clearData() {
        this.icon = null;
        this.operations.clear();
    }

    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        return this.engine.getElementFromPoint(syscomp, x, y);
    }

    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        return this.engine.getElementFromRect(syscomp, x, y, w, h);
    }

    public void loadParents(FoundElement hoverElement) {
        if (hoverElement != null) {
            this.engine.loadParents(hoverElement);
        }
    }

    public CalculatedProperty[] getCssAttributes(FoundElement element) {
        return this.engine.getCssAttributes(element);
    }

    public CalculatedProperty[] getAttributes(FoundElement element) {
        return this.engine.getAttributes(element, false);
    }

    public List<String[]> findSelectOptions(TestElement element) {
        return this.engine.loadSelectOptions(element);
    }

    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        return this.engine.getAttribute(status, element, attributeName, maxTry + AtsManager.getInstance().getMaxTryProperty());
    }

    public void setSysProperty(String attributeName, String attributeValue) {
        this.engine.setSysProperty(attributeName, attributeValue);
    }

    public String getOs() {
        return this.systemValues.getOsName();
    }

    public String getApplication() {
        return this.systemValues.getApplicationName();
    }

    public String getApplicationVersion() {
        return this.systemValues.getApplicationVersion();
    }

    public boolean attachToExistingProcess() {
        if (this.actionStart != null) {
            return this.actionStart.isAttach();
        }
        return false;
    }

    public boolean isSameName(String value) {
        return this.actionStart.getName().equalsIgnoreCase(value);
    }

    public boolean isDesktop() {
        return this.engine instanceof DesktopDriverEngine || this.engine instanceof SapDriverEngine;
    }

    public void sendLog(int code, String message, Object value) {
        this.mainScript.sendLog(code, message, value);
    }

    public void sendWarningLog(String message, String value) {
        this.mainScript.sendWarningLog(message, value);
    }

    public boolean isBasicAuthentication() {
        return BASIC_AUTHENTICATION.equals(this.getAuthentication()) && !this.getAuthenticationValue().isEmpty();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ArrayList<String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(ArrayList<String> props) {
        this.systemProperties = props;
    }

    public ArrayList<String> getSystemButtons() {
        return this.systemButtons;
    }

    public void setSystemButtons(ArrayList<String> buttons) {
        this.systemButtons = buttons;
    }

    public ArrayList<String> getOperations() {
        return this.operations;
    }

    public void setOperations(ArrayList<String> operations) {
        this.operations = operations;
    }

    public SystemValues getSystemValues() {
        return this.systemValues;
    }

    public void setSystemValues(SystemValues value) {
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String url) {
    }

    public String getName() {
        return this.actionStart.getName();
    }

    public void setName(String name) {
    }

    public String getAuthentication() {
        if (this.actionStart.getAuthentication() != null && this.actionStart.getAuthenticationValue() != null && this.actionStart.getAuthentication().length() > 0 && this.actionStart.getAuthenticationValue().length() > 0) {
            return this.actionStart.getAuthentication();
        }
        return "";
    }

    public void setAuthentication(String value) {
    }

    public int getPerformance() {
        return this.actionStart.getPerformance();
    }

    public void setPerformance(int value) {
        this.actionStart.setPerformance(value);
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean value) {
        this.current = value;
        if (value) {
            this.setWindowToFront();
        }
    }

    public byte[] getIcon() {
        return this.icon;
    }

    public void setIcon(byte[] value) {
        this.icon = value;
    }

    public String getScreenServer() {
        return this.screenServer;
    }

    public void setScreenServer(String value) {
        this.screenServer = value;
    }

    public TestBound getDimension() {
        return this.dimension;
    }

    public void setFullScreenSize(long w, long h) {
        this.dimension = new TestBound(0.0, 0.0, Double.valueOf(w), Double.valueOf(h));
    }

    public void setDimension(TestBound dimension) {
        this.dimension = dimension;
    }

    public String getBoundDimension() {
        return this.dimension.getX().intValue() + "," + this.dimension.getY().intValue() + "," + this.dimension.getWidth().intValue() + "," + this.dimension.getHeight().intValue();
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long value) {
    }

    public TestBound getSubDimension() {
        return this.subDimension;
    }

    public void setSubDimension(TestBound dimension) {
        this.subDimension = dimension;
    }

    public void close() {
        this.close(this.newActionStatus(), false);
    }

    public void close(ActionStatus status, boolean keepRunning) {
        if (this.stopNeoloadRecord != null) {
            this.neoloadAction(this.stopNeoloadRecord, "", 0);
        }
        this.closeAtsProxy();
        this.engine.close(keepRunning);
        this.mainScript.getChannelManager().channelClosed(status, this);
    }

    public void progressiveWait(int value) {
        this.sleep(200 + value * 50);
    }

    public void sleep(int ms) {
        this.mainScript.sleep(ms);
    }

    public void actionTerminated(ActionStatus status) {
        this.engine.waitAfterAction(status);
    }

    public WebElement getRootElement() {
        return this.engine.getRootElement(this);
    }

    public void switchWindow(ActionStatus status, int index, int tries, int delay) {
        if (delay > 0 && delay < 100) {
            this.sleep(delay * 1000);
        }
        this.engine.switchWindow(status, index, tries);
        if (status.isPassed()) {
            this.engine.updateDimensions();
            this.updateWinHandle(this.getDesktopDriver(), index);
        }
    }

    public String setWindowBound(BoundData x, BoundData y, BoundData w, BoundData h) {
        String bounds = this.engine.setWindowBound(x, y, w, h);
        this.engine.updateDimensions();
        return bounds;
    }

    public void closeWindow(ActionStatus status) {
        this.engine.closeWindow(status);
    }

    public void windowState(ActionStatus status, String state) {
        this.engine.windowState(status, this, state);
    }

    public Object executeScript(ActionStatus status, String script, Object ... params) {
        return this.engine.executeScript(status, script, params);
    }

    public DialogBox switchToAlert() {
        return this.engine.switchToAlert();
    }

    public void switchToDefaultContent() {
        this.engine.switchToDefaultContent();
    }

    public void navigate(ActionStatus status, String url) {
        this.engine.goToUrl(status, url);
    }

    public void api(ActionStatus status, ActionApi api) {
        this.engine.api(status, api);
    }

    public IDriverEngine getDesktopDriverEngine() {
        return this.getDesktopDriver().getEngine();
    }

    public IDriverEngine getDriverEngine() {
        return this.engine;
    }

    public void scroll(int delta) {
        this.engine.scroll(delta * this.scrollUnit);
    }

    public void scroll(FoundElement foundElement, int delta) {
        this.engine.scroll(foundElement, delta * this.scrollUnit);
    }

    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement) {
        this.engine.mouseMoveToElement(foundElement);
        this.actionTerminated(status);
    }

    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position) {
        this.engine.mouseMoveToElement(status, foundElement, position, false, 0, 0);
        this.actionTerminated(status);
    }

    public void buttonClick(ActionStatus status, String buttonType) {
        this.engine.buttonClick(status, buttonType);
    }

    public void neoloadAction(ActionNeoload action, String testName, int testLine) {
        action.setStatus(this.newActionStatus(testName, testLine));
        if (this.getPerformance() == 2) {
            if (this.neoloadDesignApi != null) {
                action.executeRequest(this, this.neoloadDesignApi);
            } else {
                action.getStatus().setPassed(false);
                action.getStatus().setMessage("Neoload design API is not defined in .atsProperties !");
            }
        } else {
            action.getStatus().setPassed(true);
        }
    }

    public void setStopNeoloadRecord(ActionNeoloadStop value) {
        this.stopNeoloadRecord = value;
    }

    public Proxy startAtsProxy(AtsManager ats) {
        this.atsProxy = new AtsProxy(this.getName(), this.getApplication(), ats.getBlackListServers(), ats.getTrafficIdle(), ats.getOctoperf());
        return this.atsProxy.startProxy();
    }

    public void startHarServer(ActionStatus status, List<String> whiteList, int trafficIddle, int latency, long sendBandWidth, long receiveBandWidth) {
        this.atsProxy.startRecord(status, whiteList, trafficIddle, latency, sendBandWidth, receiveBandWidth);
    }

    public void pauseHarRecord() {
        this.atsProxy.pauseRecord();
    }

    public void resumeHarRecord() {
        this.atsProxy.resumeRecord();
    }

    public void startHarAction(Action action, String testLine) {
        this.atsProxy.startAction(action, testLine);
    }

    public void endHarAction() {
        this.atsProxy.endAction();
    }

    public void sendToOctoperfServer(ActionOctoperfVirtualUser action) {
        this.atsProxy.sendToOctoperfServer(this, action);
    }

    public void closeAtsProxy() {
        if (this.atsProxy != null) {
            this.atsProxy.terminate(this.getName());
        }
        this.atsProxy = null;
    }

    public DesktopResponse startVisualRecord(ScriptHeader header, int quality, long started) {
        return this.getDesktopDriver().startVisualRecord(this, header, quality, started);
    }

    public void stopVisualRecord(ScriptStatus status, ReportSummary summary) {
        this.getDesktopDriver().saveSummary(status, summary);
        this.getDesktopDriver().stopVisualRecord();
    }

    public void saveVisualReportFile(Path path, String fileName, ExecutionLogger logger) {
        this.getDesktopDriver().saveVisualReportFile(path.resolve(fileName), logger);
    }

    public void createVisualAction(boolean stop, String actionName, int scriptLine, String scriptName, long timeline, boolean sync) {
        this.engine.createVisualAction(this, stop, actionName, scriptLine, scriptName, timeline, sync);
    }

    public void updateVisualAction(boolean isRef) {
        this.engine.updateScreenshot(this.dimension, isRef);
    }

    public void updateVisualAction(String value) {
        this.getDesktopDriver().updateVisualValue(value);
    }

    public void updateVisualAction(String value, String data) {
        this.getDesktopDriver().updateVisualData(value, data);
    }

    public void updateVisualAction(String type, MouseDirectionData hdir, MouseDirectionData vdir) {
        this.getDesktopDriver().updateVisualPosition(type, hdir, vdir);
    }

    public void updateVisualAction(TestElement element) {
        this.getDesktopDriver().updateVisualElement(element);
    }

    public void updateVisualAction(int error, long duration) {
        this.getDesktopDriver().updateVisualStatus(error, duration);
    }

    public void updateVisualAction(int error, long duration, String value) {
        this.getDesktopDriver().updateVisualStatus(error, duration);
        this.getDesktopDriver().updateVisualValue(value);
    }

    public void updateVisualAction(int error, long duration, String value, String data) {
        this.getDesktopDriver().updateVisualStatus(error, duration);
        this.getDesktopDriver().updateVisualData(value, data);
    }

    public void createVisualAction(IVisualRecorder recorder, Action action, String testName, int line) {
        recorder.createVisualAction(action, testName, line);
    }
}

