/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.driver.ApplicationProperties;
import com.ats.element.AtsBaseElement;
import com.ats.element.AtsSapElement;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.RemoteRootElement;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.DriverProcess;
import com.ats.executor.drivers.desktop.DesktopDriver;
import com.ats.executor.drivers.engines.DesktopDriverEngine;
import com.ats.executor.drivers.engines.DriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.generator.ATS;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionApi;
import com.ats.tools.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.gson.JsonSyntaxException;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class SapDriverEngine
extends DriverEngine
implements IDriverEngine {
    private static final Pattern SAP_URL_PATTERN = Pattern.compile("(.*):(.*)@(.*)", 2);
    private static final String SESSION = "session";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String ELEMENTS = "elements";
    private static final String ELEMENT = "element";
    private static final String PRESS = "press";
    private static final String TEXT = "text";
    private static final String TREE = "tree";
    private static final String OPTIONS = "options";
    private static final String SELECT = "select";
    private static final String PARENTS = "parents";
    private static final String WINDOW = "window";
    private static final String SWITCH = "switch";
    private static final String CLOSE = "close";
    private String sapUser;
    private String sapPassword;
    private String sapClient = "001";
    private String applicationName;
    private OkHttpClient httpClient;
    private String userAgent;
    private String sapDriverUrl;
    protected DriverProcess driverProcess;
    private String sessionId;
    private List<FoundElement> elementMapLocation;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private RemoteRootElement root = new RemoteRootElement();

    /*
     * Enabled aggressive block sorting
     */
    public SapDriverEngine(Channel channel, ActionStatus status, String application, DriverProcess driverProcess, DesktopDriver desktopDriver, ApplicationProperties props) {
        super(channel, desktopDriver, props, 0, 0);
        this.driverProcess = driverProcess;
        this.sapDriverUrl = driverProcess.getDriverServerUrl().toString() + "/";
        if (channel.isBasicAuthentication()) {
            String authenticationDecoded = new String(Base64.getDecoder().decode(channel.getAuthenticationValue()), StandardCharsets.UTF_8);
            String[] authenticationData = authenticationDecoded.split(":");
            if (authenticationData.length <= 1) {
                status.setError(-19, "no user and password defined");
                return;
            }
            this.sapUser = authenticationData[0];
            CalculatedValue passValue = new CalculatedValue((Script)channel.getTestScript(), authenticationData[1]);
            passValue.uncrypt(channel.getTestScript());
            this.sapPassword = passValue.getCalculated();
            String[] appUrl = application.split(":");
            if (appUrl.length > 1) {
                application = appUrl[0];
                this.sapClient = appUrl[1];
            } else {
                appUrl = application.split("/");
                if (appUrl.length <= 1) {
                    status.setError(-19, "missing client ID");
                    return;
                }
                application = appUrl[0];
                this.sapClient = appUrl[1];
            }
        } else {
            Matcher mv = SAP_URL_PATTERN.matcher(application);
            if (mv.find()) {
                this.sapUser = mv.group(1);
                this.checkPassword(new CalculatedValue((Script)channel.getTestScript(), mv.group(2)), 0);
                application = mv.group(3);
            } else {
                channel.getArguments().forEach(c -> this.checkArgs((CalculatedValue)c));
            }
        }
        this.applicationPath = this.applicationName = application;
        this.httpClient = new OkHttpClient.Builder().cache(null).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(40L, TimeUnit.SECONDS).build();
        this.userAgent = "AtsSapDriver/" + ATS.VERSION + "," + System.getProperty("user.name") + ",";
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"connection", (Object)this.applicationName, (Object)"user", (Object)this.sapUser, (Object)"password", (Object)this.sapPassword, (Object)"client", (Object)this.sapClient), SESSION, START);
        if (response == null) {
            status.setError(-19, "unable to connect to sap driver");
            return;
        }
        JsonNode error = response.findValue("error");
        if (error != null) {
            status.setError(-19, error.findValue("Message").asText());
            return;
        }
        JsonNode window = response.findValue(WINDOW);
        if (window != null) {
            this.sessionId = response.findValue("SessionId").asText();
            desktopDriver.setEngine(new DesktopDriverEngine(channel));
            channel.setApplicationData("sap", desktopDriver.getOsName() + " (" + desktopDriver.getOsVersion() + ")", "SAP Gui", "", desktopDriver.getDriverVersion(), window.get("ProcessId").asInt(0), window.get("Handle").asInt(0), new byte[0]);
            channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
        }
    }

    private void checkArgs(CalculatedValue cv) {
        String v = cv.getCalculated();
        if (v.startsWith("user=")) {
            this.sapUser = v.substring(5);
        } else if (v.startsWith("pass=")) {
            this.checkPassword(cv, 5);
        } else if (v.startsWith("password=")) {
            this.checkPassword(cv, 9);
        } else if (v.startsWith("client=")) {
            this.sapClient = v.substring(7);
        }
    }

    private void checkPassword(CalculatedValue cv, int start) {
        cv.setCalculated(cv.getCalculated().substring(start));
        cv.uncrypt(this.channel.getTestScript());
        this.sapPassword = cv.getCalculated();
    }

    public JsonNode executeRequest(ImmutableMap<String, Object> map, String ... reqUrl) {
        String url = this.sapDriverUrl + Stream.of(reqUrl).map(Object::toString).collect(Collectors.joining("/"));
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        Request request = requestBuilder.addHeader("User-Agent", this.userAgent).addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF8").post(RequestBody.create(null, (String)this.jsonMapper.valueToTree(map).toString())).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            String responseData = CharStreams.toString((Readable)new InputStreamReader(response.body().byteStream(), Charsets.UTF_8));
            response.close();
            return this.jsonMapper.readTree(responseData);
        }
        catch (JsonSyntaxException | IOException e) {
            return null;
        }
    }

    private void loadElementsByTag(String parentId, String tagName, List<AtsSapElement> list) {
        JsonNode elements;
        JsonNode response;
        HashMap<String, String> m = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)"tag", (Object)tagName));
        if (parentId != null) {
            m.put("parent", parentId);
        }
        if ((response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.copyOf(m), ELEMENTS)) != null && (elements = response.findValue(ELEMENTS)) != null) {
            for (JsonNode element : elements) {
                list.add(new AtsSapElement(this.jsonMapper, element));
            }
        }
    }

    @Override
    public WebElement getRootElement(Channel cnl) {
        return this.root;
    }

    @Override
    public void close(boolean keepRunning) {
        this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId), SESSION, STOP);
    }

    @Override
    public void switchWindow(ActionStatus status, int index, int tries) {
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)"index", (Object)index), WINDOW, SWITCH);
        if (response != null) {
            JsonNode window = response.findValue(WINDOW);
            if (window != null) {
                this.channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
            } else {
                JsonNode error = response.findValue("error");
                if (error != null) {
                    status.setError(-14, error.get("Message").asText(""));
                }
            }
        }
    }

    @Override
    public void closeWindow(ActionStatus status) {
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId), WINDOW, CLOSE);
        if (response != null) {
            JsonNode window = response.findValue(WINDOW);
            if (window != null) {
                this.channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
            } else {
                JsonNode error = response.findValue("error");
                if (error != null) {
                    status.setError(-14, error.get("Message").asText(""));
                }
            }
        }
    }

    @Override
    public Object executeScript(ActionStatus status, String script, Object ... params) {
        return null;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, TestElement element) {
        return null;
    }

    @Override
    public Object executeJavaScript(ActionStatus status, String script, boolean returnValue) {
        return null;
    }

    @Override
    public void goToUrl(ActionStatus status, String url) {
    }

    @Override
    public List<FoundElement> findElements(boolean sysComp, TestElement testObject, String tagName, String[] attributes, String[] attributesValues, Predicate<AtsBaseElement> searchPredicate, WebElement startElement) {
        ArrayList<AtsSapElement> list = new ArrayList<AtsSapElement>();
        TestElement parent = testObject.getParent();
        String parentId = null;
        if (parent != null) {
            parentId = parent.getWebElementId();
        }
        this.loadElementsByTag(parentId, tagName, list);
        return list.parallelStream().filter(searchPredicate).map(FoundElement::new).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Rectangle getBoundRect(TestElement testElement) {
        return null;
    }

    @Override
    public void waitAfterAction(ActionStatus status) {
    }

    @Override
    public void updateDimensions() {
        JsonNode window;
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId), WINDOW);
        if (response != null && !(window = response.findValue(WINDOW)).isNull()) {
            this.channel.getDimension().update(window.get("ScreenX").asDouble(0.0), window.get("ScreenY").asDouble(0.0), window.get("Width").asDouble(0.0), window.get("Height").asDouble(0.0));
        }
    }

    @Override
    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        Optional<FoundElement> fe;
        double xPos = x;
        double yPos = y;
        if (this.elementMapLocation != null && this.elementMapLocation.size() > 0 && (fe = this.elementMapLocation.stream().filter(e -> e.isActive() && e.getRectangle().contains(xPos, yPos)).findFirst()).isPresent()) {
            return fe.get();
        }
        return null;
    }

    @Override
    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        return null;
    }

    @Override
    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        CalculatedProperty[] properties;
        for (CalculatedProperty prop : properties = this.getAttributes(element, true)) {
            if (!prop.getName().equals(attributeName)) continue;
            return prop.getValue().getCalculated();
        }
        return null;
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        JsonNode jsonElement;
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)"id", (Object)element.getId()), ELEMENT);
        if (response != null && (jsonElement = response.findValue(ELEMENT)) != null) {
            AtsSapElement elem = new AtsSapElement(this.jsonMapper, jsonElement);
            return elem.getAttributes();
        }
        return null;
    }

    @Override
    public void setSysProperty(String propertyName, String propertyValue) {
    }

    @Override
    public List<String[]> loadSelectOptions(TestElement element) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)"id", (Object)element.getWebElementId()), ELEMENT, OPTIONS);
        if (response != null) {
            JsonNode jsonOptions = response.findValue(OPTIONS);
            jsonOptions.fields().forEachRemaining(f -> result.add(new String[]{(String)f.getKey(), ((JsonNode)f.getValue()).asText()}));
        }
        return result;
    }

    @Override
    public List<FoundElement> findSelectOptions(TestBound dimension, TestElement element) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectOptionsItem(ActionStatus status, TestElement testElement, CalculatedProperty selectProperty) {
        JsonNode jsonError;
        String searchedValue = selectProperty.getValue().getCalculated();
        List<String[]> items = this.loadSelectOptions(testElement);
        String key = null;
        if ("index".equals(selectProperty.getName())) {
            int index = Utils.string2Int(searchedValue);
            if (items.size() <= index) {
                status.setError(-3, "index not found, max length options : " + items.size());
                return;
            }
            key = items.get(index)[0];
        } else {
            Optional<String[]> foundOption = null;
            int idx = 1;
            if ("value".equals(selectProperty.getName())) {
                idx = 0;
            }
            int dataIndex = idx;
            foundOption = selectProperty.isRegexp() ? items.stream().filter(e -> e[dataIndex].matches(searchedValue)).findFirst() : items.stream().filter(e -> e[dataIndex].equals(searchedValue)).findFirst();
            if (!foundOption.isPresent()) {
                status.setError(-3, "option not found : " + searchedValue);
                return;
            }
            key = foundOption.get()[0];
        }
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)"id", (Object)testElement.getWebElementId(), (Object)"key", (Object)key), ELEMENT, SELECT);
        if (response != null && (jsonError = response.findValue("error")) != null) {
            status.setError(jsonError.get("Code").asInt(0), jsonError.get("Message").asText(""));
        }
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)"id", (Object)hoverElement.getId()), ELEMENT, PARENTS);
        if (response != null) {
            double channelX = this.channel.getDimension().getX();
            double channelY = this.channel.getDimension().getY();
            JsonNode jsonParent = response.findValue("parent");
            hoverElement.setParent(new FoundElement(channelX, channelY, jsonParent, jsonParent.get("Parent")));
        }
    }

    @Override
    public void scroll(int delta) {
    }

    @Override
    public void scroll(FoundElement element) {
    }

    @Override
    public void scroll(FoundElement element, int delta) {
    }

    @Override
    public void sendTextData(ActionStatus status, TestElement element, ArrayList<SendKeyData> textActionList, int waitChar) {
        for (SendKeyData kd : textActionList) {
            this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)ELEMENT, (Object)element.getWebElementId(), (Object)TEXT, (Object)kd.getSequenceMobile()), TEXT);
        }
    }

    @Override
    public void clearText(ActionStatus status, TestElement testElement, MouseDirection md) {
    }

    @Override
    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
    }

    @Override
    public void mouseMoveToElement(FoundElement foundElement) {
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        JsonNode jsonError;
        JsonNode response = this.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId, (Object)"id", (Object)element.getId()), ELEMENT, PRESS);
        if (response != null && (jsonError = response.findValue("error")) != null) {
            status.setError(jsonError.get("Code").asInt(0), jsonError.get("Message").asText(""));
        }
    }

    @Override
    public void doubleClick() {
    }

    @Override
    public void rightClick() {
    }

    @Override
    public void middleClick(ActionStatus status, MouseDirection position, TestElement element) {
    }

    @Override
    public void buttonClick(ActionStatus status, String id) {
    }

    @Override
    public void tap(int count, FoundElement element) {
    }

    @Override
    public void press(int duration, ArrayList<String> paths, FoundElement element) {
    }

    @Override
    public void drag(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
    }

    @Override
    public void drop(MouseDirection md, boolean desktopDragDrop) {
    }

    @Override
    public void keyDown(Keys key) {
    }

    @Override
    public void keyUp(Keys key) {
    }

    @Override
    public void moveByOffset(int hDirection, int vDirection) {
    }

    @Override
    public DialogBox switchToAlert() {
        return null;
    }

    @Override
    public boolean switchToDefaultContent() {
        return false;
    }

    @Override
    public void setWindowToFront() {
        this.channel.toFront();
    }

    @Override
    public void switchToFrameId(String id) {
    }

    @Override
    public void refreshElementMapLocation() {
        new Thread(new LoadMapElement(this.channel, this.sessionId, this)).start();
    }

    public void setElementMapLocation(ArrayList<FoundElement> value) {
        this.elementMapLocation = value;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public void api(ActionStatus status, ActionApi api) {
    }

    @Override
    public void windowState(ActionStatus status, Channel channel, String state) {
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public int getNumWindows() {
        return 0;
    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    protected void setPosition(Point pt) {
    }

    @Override
    protected void setSize(Dimension dim) {
    }

    private static class LoadMapElement
    implements Runnable {
        final TestBound channelDimension;
        final String sessionId;
        final SapDriverEngine driver;

        public LoadMapElement(Channel channel, String sessionId, SapDriverEngine driver) {
            this.channelDimension = channel.getDimension();
            this.sessionId = sessionId;
            this.driver = driver;
        }

        @Override
        public void run() {
            JsonNode elements;
            JsonNode response = this.driver.executeRequest((ImmutableMap<String, Object>)ImmutableMap.of((Object)"sessionId", (Object)this.sessionId), SapDriverEngine.ELEMENTS, SapDriverEngine.TREE);
            if (response != null && (elements = response.findValue(SapDriverEngine.ELEMENTS)) != null) {
                Iterator childrenIterator = elements.elements();
                ArrayList<FoundElement> list = new ArrayList<FoundElement>();
                double channelX = this.channelDimension.getX();
                double channelY = this.channelDimension.getY();
                while (childrenIterator.hasNext()) {
                    list.add(new FoundElement(channelX, channelY, (JsonNode)childrenIterator.next()));
                }
                this.driver.setElementMapLocation(list);
            }
        }
    }
}

