/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.mobiles;

import com.ats.element.AtsMobileElement;
import com.ats.element.FoundElement;
import com.ats.element.MobileTestElement;
import com.ats.element.StructDebugDescription;
import com.ats.element.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.SendKeyData;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import com.ats.executor.drivers.engines.mobiles.RootElement;
import com.ats.generator.objects.MouseDirection;
import com.fasterxml.jackson.databind.JsonNode;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;

public class IosRootElement
extends RootElement {
    private final String regexSpaces = "^\\s+";
    private final String regexBraces = "[{},]+";
    private final double scale;

    public IosRootElement(MobileDriverEngine driver, double scale) {
        super(driver);
        this.scale = scale;
    }

    @Override
    public MobileTestElement getCurrentElement(FoundElement element, MouseDirection position) {
        Point point = this.calculateCoordinates(element, position);
        return new MobileTestElement(element.getId(), point.x, point.y);
    }

    @Override
    public void tap(ActionStatus status, FoundElement element, MouseDirection position) {
        Point point = this.calculateCoordinates(element, position);
        this.driver.executeRequest("element", "tap", "" + point.x, "" + point.y);
    }

    private Point calculateCoordinates(FoundElement element, MouseDirection position) {
        double offsetY;
        double offsetX;
        Rectangle rect = element.getRectangle();
        double originX = element.getX();
        double originY = element.getY();
        if (element.getTag().equals("@IMAGE")) {
            offsetX = this.driver.getOffsetX(rect, this.scale, position);
            offsetY = this.driver.getOffsetY(rect, this.scale, position);
            originX /= this.scale;
            originY /= this.scale;
        } else {
            offsetX = this.driver.getOffsetX(rect, position);
            offsetY = this.driver.getOffsetY(rect, position);
        }
        int x = (int)(originX + offsetX);
        int y = (int)(originY + offsetY);
        return new Point(x, y);
    }

    @Override
    public void tap(FoundElement element, int count) {
        if (element.getParent() != null) {
            this.driver.executeRequest("element", "tap", String.valueOf(count));
        }
    }

    @Override
    public void press(FoundElement element, ArrayList<String> paths, int duration) {
        this.driver.executeRequest("element", "press", String.valueOf(paths), String.valueOf(duration));
    }

    @Override
    public void swipe(MobileTestElement testElement, int hDirection, int vDirection) {
        this.driver.executeRequest("element", "swipe", "" + testElement.getOffsetX(), "" + testElement.getOffsetY(), "" + hDirection, "" + vDirection);
    }

    @Override
    public void textInput(TestElement element, ArrayList<SendKeyData> textActionList) {
        for (SendKeyData sequence : textActionList) {
            this.driver.executeRequest("element", "input", sequence.getSequenceMobile());
        }
    }

    @Override
    public void clearInput(TestElement element) {
        this.driver.executeRequest("element", "input", "&empty;");
    }

    @Override
    public Object scripting(String script, FoundElement element) {
        String coordinates = element.getX() + ";" + element.getY() + ";" + element.getWidth() + ";" + element.getHeight();
        return this.driver.executeRequest("element", element.getId(), "scripting", "0", "0", coordinates, script);
    }

    @Override
    public Object scripting(String script) {
        return this.scripting(script, this.getValue().getFoundElement());
    }

    @Override
    public void refresh(@Nonnull JsonNode node) {
        AtsMobileElement[] frontElements;
        String debugDescription = node.get("root").asText();
        String[] debugDescriptionArray = debugDescription.split("\n");
        double width = 0.0;
        double height = 0.0;
        ArrayList<StructDebugDescription> elementInfoArray = new ArrayList<StructDebugDescription>();
        for (String item : debugDescriptionArray) {
            int level = this.countSpaces(item);
            if (level < 4 || item.contains("Application, ")) continue;
            String trimmedLine = item.replaceAll("^\\s+", "");
            if (trimmedLine.startsWith("Window (Main)")) {
                String regexBracesAndSpaces = "[\\s{},]+";
                String[] arraySize = trimmedLine.split(regexBracesAndSpaces);
                width = Double.parseDouble(arraySize[5]);
                height = Double.parseDouble(arraySize[6]);
            }
            elementInfoArray.add(new StructDebugDescription(level / 2 - 1, trimmedLine));
        }
        AtsMobileElement rootElement = new AtsMobileElement(UUID.randomUUID().toString(), "root", width, height, 0.0, 0.0, false, new HashMap<String, String>());
        int currentElementIndex = 0;
        for (StructDebugDescription elementInfo : elementInfoArray) {
            String[] arraySize = elementInfo.getContent().split("[{},]+");
            String tag = arraySize[0].replaceAll("^\\s+", "");
            ArrayList<String> stringArray = new ArrayList<String>();
            for (String s : arraySize) {
                if (s.replaceAll("^\\s+", "").equals("")) continue;
                stringArray.add(s);
            }
            int firstSizeIndex = 2;
            if (elementInfo.getContent().contains("pid:")) {
                ++firstSizeIndex;
            }
            double currentX = Double.parseDouble((String)stringArray.get(firstSizeIndex));
            double currentY = Double.parseDouble((String)stringArray.get(firstSizeIndex + 1));
            double currentWidth = Double.parseDouble((String)stringArray.get(firstSizeIndex + 2));
            double currentHeight = Double.parseDouble((String)stringArray.get(firstSizeIndex + 3));
            AtsMobileElement element = new AtsMobileElement(elementInfo.getUuid().toString(), tag, currentWidth, currentHeight, currentX, currentY, true, this.getAttributes(elementInfo.getContent()));
            if (elementInfo.getLevel() == 1) {
                rootElement.addChildren(element);
            } else {
                int i = currentElementIndex;
                UUID uuidParent = null;
                while (i - 1 > -1) {
                    if (((StructDebugDescription)elementInfoArray.get(i - 1)).getLevel() + 1 == elementInfo.getLevel()) {
                        uuidParent = ((StructDebugDescription)elementInfoArray.get(i - 1)).getUuid();
                        break;
                    }
                    --i;
                }
                if (uuidParent != null) {
                    this.searchAndAdd(uuidParent.toString(), rootElement, element);
                }
            }
            ++currentElementIndex;
        }
        AtsMobileElement[] rootElementChildren = rootElement.getChildren();
        if (rootElementChildren != null && rootElementChildren.length > 0 && (frontElements = rootElementChildren[0].getChildren()) != null && frontElements.length > 1) {
            AtsMobileElement lastElement = frontElements[frontElements.length - 1];
            boolean containsElements = this.checkConsistency(lastElement.getChildren(), false);
            if (containsElements) {
                rootElement.getChildren()[0].setChildren(lastElement.getChildren());
            } else {
                rootElement.getChildren()[0].setChildren(frontElements[0].getChildren());
            }
        }
        this.value = rootElement;
    }

    public boolean checkConsistency(AtsMobileElement[] child, boolean val) {
        for (AtsMobileElement atsMobileElement : child) {
            if (atsMobileElement != null && atsMobileElement.getChildren().length > 0) {
                val = this.checkConsistency(atsMobileElement.getChildren(), val);
                continue;
            }
            if (atsMobileElement == null || atsMobileElement.getTag().equalsIgnoreCase("other")) continue;
            val = true;
        }
        return val;
    }

    private Map<String, String> getAttributes(String str) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String[] arraySize = str.split("[{},]+");
        if (arraySize[0].contains("checkbox")) {
            result.put("checkable", "true");
        } else {
            result.put("checkable", "false");
        }
        for (String s : arraySize) {
            String cleanString = this.cleanAttribute(s);
            if (s.contains("label")) {
                result.put("text", cleanString);
            }
            if (s.contains("placeholderValue")) {
                result.put("description", cleanString);
            }
            if (s.contains("identifier")) {
                result.put("identifier", cleanString);
            }
            if (s.contains("value")) {
                result.put("value", cleanString);
            }
            if (s.contains("Disabled")) {
                result.put("enabled", "false");
                result.put("editable", "false");
            }
            if (!s.contains("Selected")) continue;
            result.put("selected", "true");
        }
        if (!result.containsKey("text")) {
            result.put("text", "");
        }
        if (!result.containsKey("description")) {
            result.put("description", "");
        }
        if (!result.containsKey("identifier")) {
            result.put("identifier", "");
        }
        if (!result.containsKey("value")) {
            result.put("value", "");
        }
        if (!result.containsKey("enabled")) {
            result.put("enabled", "true");
            result.put("editable", "true");
        }
        if (!result.containsKey("selected")) {
            result.put("selected", "false");
        }
        if (!result.containsKey("numeric")) {
            result.put("numeric", "false");
        }
        return result;
    }

    private String cleanAttribute(String str) {
        return str.split(":")[str.split(":").length - 1].replace("'", "").replaceAll("^\\s+", "");
    }

    private int countSpaces(String str) {
        int count = 0;
        for (int i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
            ++count;
        }
        return count;
    }

    private void searchAndAdd(String uuid, AtsMobileElement node, AtsMobileElement elementToAdd) {
        if (node.getId().equals(uuid)) {
            node.addChildren(elementToAdd);
        } else {
            AtsMobileElement[] children = node.getChildren();
            if (children != null) {
                for (int i = 0; i < node.getChildren().length; ++i) {
                    this.searchAndAdd(uuid, node.getChildren()[i], elementToAdd);
                }
            }
        }
    }
}

