/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.webservices;

import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.element.TestElement;
import com.ats.element.api.AtsApiElement;
import com.ats.element.api.AtsJsonElement;
import com.ats.element.api.AtsXmlElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.webservices.AtsCookieJar;
import com.ats.executor.drivers.engines.webservices.IApiDriverExecutor;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.actions.ActionApi;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ApiExecutor
implements IApiDriverExecutor {
    private static final String TRUNCATED_DATA = "TRUNCATED_DATA";
    private static final Pattern xmlPropertyPattern = Pattern.compile(".*:");
    private static final short TEXT_TYPE = 0;
    private static final short JSON_TYPE = 1;
    private static final short XML_TYPE = 2;
    private static final String ELEMENT = "ELEMENT";
    private static final String NODE = "NODE";
    private static final String OBJECT = "OBJECT";
    private static final String ARRAY = "ARRAY";
    public static final String RESPONSE = "RESPONSE";
    public static final String DATA = "DATA";
    public static final String ROOT = "root";
    public static final String HEADERS = "headers";
    private URI uri;
    private String source;
    private short type;
    private ActionApi lastAction;
    private ArrayList<AtsApiElement> atsElements;
    protected Map<String, String> headerProperties;
    protected String authentication;
    protected String authenticationValue;
    protected int timeout;
    protected int maxTry;
    protected Channel channel;
    protected OkHttpClient client;
    private Response response;
    private PrintStream logStream;
    private ArrayList<AtsApiElement> atsElementsCache;

    public ApiExecutor(PrintStream logStream, AtsCookieJar cookieJar, OkHttpClient client, int timeout, int maxTry, Channel channel) {
        this.logStream = logStream;
        this.client = client;
        this.timeout = timeout;
        this.maxTry = maxTry;
        this.channel = channel;
        this.authentication = channel.getAuthentication();
        this.authenticationValue = channel.getAuthenticationValue();
    }

    protected void setUri(String value) {
        if (value != null) {
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    protected URI getUri() {
        if (this.lastAction.getPort() > -1) {
            try {
                URL originalURL = this.uri.toURL();
                return new URL(originalURL.getProtocol(), originalURL.getHost(), this.lastAction.getPort(), originalURL.getFile()).toURI();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return this.uri;
    }

    protected URI getMethodUri() {
        return this.getUri().resolve(this.lastAction.getMethod().getCalculated());
    }

    public String getCurrentUrl() {
        return this.getMethodUri().toString();
    }

    @Override
    public void execute(ActionStatus status, ActionApi action) {
        this.source = "";
        this.type = 0;
        this.lastAction = action;
        status.setMessage("authentication");
        this.headerProperties = new HashMap<String, String>();
        if (this.authentication != null && this.authenticationValue != null && this.authentication.length() > 0 && this.authenticationValue.length() > 0) {
            this.headerProperties.put("Authorization", this.authentication + " " + this.authenticationValue);
            status.setData(this.authentication);
        } else {
            status.setData("");
        }
        for (CalculatedProperty property : action.getHeader()) {
            this.headerProperties.put(property.getName(), property.getValue().getCalculated());
        }
    }

    protected void addHeader(String key, String value) {
        if (!this.headerProperties.containsKey(key)) {
            this.headerProperties.put(key, value);
        }
    }

    private void refresh(Channel channel) {
        if (this.lastAction != null && !this.lastAction.isUseCache()) {
            this.execute(channel.newActionStatus(), this.lastAction);
        } else {
            this.atsElements = new ArrayList<AtsApiElement>(this.atsElementsCache);
        }
    }

    protected void executeRequest(ActionStatus status, Request request) {
        int max;
        this.logStream.println("call request -> " + request.url().toString());
        for (max = this.maxTry; !this.clientCall(status, request) && max > 0; --max) {
            this.channel.sendLog(52, "Call webservice failed", max);
            this.channel.sleep(500);
        }
        if (max == 0) {
            this.logStream.println("call request failed -> " + status.getFailMessage());
        }
    }

    private boolean clientCall(ActionStatus status, Request request) {
        String type = "";
        try {
            this.response = this.client.newCall(request).execute();
            List contentTypes = this.response.headers("Content-Type");
            JsonArray headers = new JsonArray();
            for (String key : this.response.headers().names()) {
                for (String value : this.response.headers(key)) {
                    JsonObject headerObject = new JsonObject();
                    headerObject.addProperty("name", key);
                    headerObject.addProperty("value", value);
                    headers.add((JsonElement)headerObject);
                }
            }
            if (contentTypes != null && contentTypes.size() > 0) {
                type = (String)contentTypes.get(0);
            }
            File tempFile = Files.createTempFile("ats-", ".tmp", new FileAttribute[0]).toFile();
            try (FileOutputStream output = new FileOutputStream(tempFile);){
                this.response.body().byteStream().transferTo(output);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = this.parseResponse(type, tempFile, headers);
            tempFile.delete();
            this.atsElementsCache = new ArrayList<AtsApiElement>(this.atsElements);
            this.response.close();
            return true;
        }
        catch (IOException e) {
            status.setError(-16, "call Webservice error -> " + e.getMessage());
            return false;
        }
    }

    private String parseResponse(String type, File bodyFile, JsonArray headers) throws FileNotFoundException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(bodyFile), StandardCharsets.UTF_8);
        this.initAtsElements();
        if (type.contains("/xml")) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(isr));
                this.type = (short)2;
                NodeList streams = doc.getElementsByTagName("Stream");
                if (streams != null && streams.getLength() > 0) {
                    for (int i = 0; i < streams.getLength(); ++i) {
                        Element stream = (Element)streams.item(i);
                        int len = stream.getTextContent().length();
                        if (len <= 100000) continue;
                        Node streamParent = stream.getParentNode();
                        streamParent.removeChild(stream);
                        Element newStream = doc.createElement("Stream");
                        newStream.setTextContent("[TRUNCATED_DATA, size:" + len + "]");
                        streamParent.appendChild(newStream);
                    }
                    doc.normalize();
                }
                this.loadElementsList(doc.getElementsByTagName("*"));
                Transformer transform = TransformerFactory.newInstance().newTransformer();
                transform.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transform.transform(new DOMSource(doc), new StreamResult(writer));
                return "<root><RESPONSE code=\"" + this.response.code() + "\"><data>" + writer.getBuffer().toString() + "</data></RESPONSE></root>";
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException doc) {}
        } else {
            try {
                this.loadElementsList((JsonElement)headers, HEADERS);
                JsonElement root = JsonParser.parseReader((Reader)isr);
                this.loadElementsList(root, ROOT);
                if (!root.isJsonPrimitive()) {
                    this.type = 1;
                    return "{\"response\":{\"name\":\"response\",\"code\":" + this.response.code() + ",\"root\":" + root + ",\"headers\":" + headers + "}}";
                }
            }
            catch (JsonIOException | JsonSyntaxException root) {
                // empty catch block
            }
        }
        this.type = 0;
        isr = new InputStreamReader((InputStream)new FileInputStream(bodyFile), StandardCharsets.UTF_8);
        String content = new BufferedReader(isr).lines().collect(Collectors.joining("\n"));
        this.atsElements.add(new AtsApiElement(DATA, (Map<String, String>)ImmutableMap.of((Object)"value", (Object)content)));
        return "<ats_response><code>" + this.response.code() + "</code><data><![CDATA[" + content + "]]></data></ats_response>";
    }

    private void initAtsElements() {
        this.atsElements = new ArrayList();
        this.atsElements.add(new AtsApiElement(RESPONSE, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"response", (Object)"code", (Object)("" + this.response.code()))));
    }

    public String getSource() {
        return this.source;
    }

    public ArrayList<FoundElement> findElements(Channel channel, TestElement testObject, String tagName, Predicate<AtsBaseElement> predicate) {
        String searchedTag = tagName.toUpperCase();
        ArrayList<FoundElement> result = new ArrayList<FoundElement>();
        if (testObject.getParent() == null) {
            this.refresh(channel);
        } else {
            Optional<AtsApiElement> parentElement = this.atsElements.stream().filter(e -> e.getId().equals(testObject.getParent().getFoundElement().getId())).findFirst();
            if (parentElement.isPresent() && !parentElement.get().isResponse()) {
                if (this.type == 2) {
                    Element elem = ((AtsXmlElement)parentElement.get()).getElement();
                    if (elem != null) {
                        this.initAtsElements();
                        this.loadElementsList(elem.getElementsByTagName("*"));
                    }
                } else if (this.type == 1) {
                    AtsJsonElement elem = (AtsJsonElement)parentElement.get();
                    this.initAtsElements();
                    this.loadElementsList(elem.getElement(), elem.getAttribute("name"));
                }
            }
        }
        if ("*".equals(tagName)) {
            this.atsElements.stream().filter(predicate).forEach(e -> result.add(new FoundElement((AtsApiElement)e)));
        } else {
            this.atsElements.stream().filter(e -> e.getTag().equals(searchedTag)).filter(predicate).forEach(e -> result.add(new FoundElement((AtsApiElement)e)));
        }
        return result;
    }

    private void loadElementsList(JsonElement json, String name) {
        HashMap<String, String> attributes = new HashMap<String, String>(Map.of("name", name));
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            attributes.put("size", "" + array.size());
            this.atsElements.add(new AtsJsonElement(json, ARRAY, attributes));
            int index = 0;
            for (JsonElement el : array) {
                if (el.isJsonPrimitive()) {
                    this.loadArrayList(el, "index" + index, el.getAsString());
                } else {
                    this.loadElementsList(el, "index" + index);
                }
                ++index;
            }
        } else if (json.isJsonObject()) {
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                String attributeName = (String)entry.getKey();
                JsonElement attributeValue = (JsonElement)entry.getValue();
                if (attributeValue.isJsonPrimitive()) {
                    if (attributes.containsKey(attributeName)) {
                        attributes.replace(attributeName, attributeValue.getAsJsonPrimitive().getAsString());
                        continue;
                    }
                    attributes.put(attributeName, attributeValue.getAsJsonPrimitive().getAsString());
                    continue;
                }
                this.loadElementsList(attributeValue, attributeName);
            }
            this.atsElements.add(new AtsJsonElement(json, OBJECT, attributes));
        }
    }

    private void loadArrayList(JsonElement el, String item, String value) {
        this.atsElements.add(new AtsJsonElement(el, ELEMENT, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)item, (Object)"value", (Object)value)));
    }

    private void loadElementsList(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            HashMap<String, String> foundAttributes = new HashMap<String, String>();
            NamedNodeMap nodeAttributes = node.getAttributes();
            foundAttributes.put("name", xmlPropertyPattern.matcher(nodeName).replaceFirst(""));
            for (int j = 0; j < nodeAttributes.getLength(); ++j) {
                Node attribute = nodeAttributes.item(j);
                this.addAttribute(foundAttributes, xmlPropertyPattern.matcher(attribute.getNodeName()).replaceFirst(""), attribute.getNodeValue());
            }
            boolean hasChild = false;
            NodeList nodeChild = node.getChildNodes();
            for (int j = 0; j < nodeChild.getLength(); ++j) {
                Node nodeChildElement = nodeChild.item(j);
                if (nodeChildElement.getNodeType() == 1) {
                    hasChild = true;
                    continue;
                }
                String nodeChildValue = nodeChildElement.getNodeValue();
                if (nodeChildValue == null || (nodeChildValue = nodeChildValue.trim()).length() <= 0) continue;
                if (nodeChildElement.getNodeType() == 3) {
                    foundAttributes.put("text", nodeChildValue);
                    continue;
                }
                if (nodeChildElement.getNodeType() != 8) continue;
                foundAttributes.put("comment", nodeChildValue);
            }
            if (hasChild) {
                this.atsElements.add(new AtsXmlElement(node, NODE, foundAttributes));
                continue;
            }
            NodeList properties = node.getChildNodes();
            for (int j = 0; j < properties.getLength(); ++j) {
                Node property = properties.item(j);
                String propertyValue = property.getNodeValue();
                if (propertyValue == null || (propertyValue = propertyValue.trim()).length() <= 0) continue;
                String propertyName = property.getNodeName();
                if ("#text".equals(propertyName)) {
                    propertyName = "value";
                } else {
                    xmlPropertyPattern.matcher(propertyName).replaceFirst("");
                }
                this.addAttribute(foundAttributes, propertyName, propertyValue);
            }
            this.atsElements.add(new AtsXmlElement(node, ELEMENT, foundAttributes));
        }
    }

    private void addAttribute(Map<String, String> map, String propertyName, String propertyValue) {
        if (!"xsd".equals(propertyName) && !"xsi".equals(propertyName)) {
            map.put(propertyName, propertyValue);
        }
    }

    public String getElementAttribute(String id, String attributeName) {
        Optional<AtsApiElement> elem = this.atsElements.stream().filter(e -> e.getId().equals(id)).findFirst();
        if (elem.isPresent()) {
            return elem.get().getAttribute(attributeName);
        }
        return null;
    }

    public CalculatedProperty[] getElementAttributes(String id) {
        Optional<AtsApiElement> elem = this.atsElements.stream().filter(e -> e.getId().equals(id)).findFirst();
        if (elem.isPresent()) {
            return (CalculatedProperty[])((Stream)elem.get().getAttributesMap().entrySet().stream().parallel()).map(e -> new CalculatedProperty((String)e.getKey(), (String)e.getValue())).toArray(CalculatedProperty[]::new);
        }
        return null;
    }
}

