/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator;

import com.ats.generator.ATS;
import com.ats.generator.AntCompiler;
import com.ats.generator.GeneratorReport;
import com.ats.generator.events.ScriptProcessedEvent;
import com.ats.generator.events.ScriptProcessedNotifier;
import com.ats.generator.parsers.Lexer;
import com.ats.script.Project;
import com.ats.script.ScriptLoader;
import com.ats.tools.Utils;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class Generator
implements ScriptProcessedEvent {
    private GeneratorReport genReport;
    private Lexer lexer;
    private ArrayList<File> filesList;
    private Project project;
    private int remainingScripts = 0;

    public static void main(String[] args) throws IOException {
        ATS.logInfo("Java version : " + System.getProperty("java.version"));
        ATS.logInfo(StringUtils.repeat((String)"-", (int)72));
        ATS arguments = new ATS(args);
        arguments.parse();
        Project projectData = Project.getProjectData(arguments.getProjectFolder(), arguments.getDestinationFolder(), arguments.getReportFolder());
        if (projectData.isValidated()) {
            String[] suites;
            Generator generator = new Generator(projectData);
            GeneratorReport report = generator.launch();
            ATS.logInfo(StringUtils.repeat((String)"-", (int)72));
            ATS.logInfo("ATS Generator finished :");
            ATS.logInfo("- Java files generated -> " + report.getGeneratedScriptsCount());
            ATS.logInfo("- Ellapsed time -> " + report.getGenerationEllapsedTime() + " ms");
            ATS.logInfo(StringUtils.repeat((String)"-", (int)72));
            if (arguments.isCompile()) {
                String targetFolderPath = projectData.getTargetFolderPath().toString();
                ATS.logInfo("Compile generated java files into folder -> " + targetFolderPath + "/classes");
                StringBuilder xmlBuilder = new StringBuilder();
                xmlBuilder.append("<project basedir=\"");
                xmlBuilder.append(targetFolderPath);
                xmlBuilder.append("\" default=\"compile\">");
                xmlBuilder.append("<copy todir=\"");
                xmlBuilder.append("classes");
                xmlBuilder.append("\"><fileset dir=\"../");
                xmlBuilder.append("src");
                xmlBuilder.append("\" includes=\"");
                xmlBuilder.append("assets");
                xmlBuilder.append("/**\"/></copy>");
                xmlBuilder.append("<property name=\"lib.dir\" value=\"lib\"/>");
                xmlBuilder.append("<target name=\"compile\"><mkdir dir=\"");
                xmlBuilder.append("classes");
                xmlBuilder.append("\"/><javac includeantruntime=\"true\" srcdir=\"");
                xmlBuilder.append("generated");
                xmlBuilder.append("\" destdir=\"");
                xmlBuilder.append("classes");
                xmlBuilder.append("\"/></target></project>");
                try {
                    File tempXml = File.createTempFile("ant_", ".xml");
                    tempXml.deleteOnExit();
                    Files.write(tempXml.toPath(), xmlBuilder.toString().getBytes(), new OpenOption[0]);
                    new AntCompiler(tempXml);
                }
                catch (IOException tempXml) {
                    // empty catch block
                }
            }
            if (arguments.getSuites() != null && (suites = arguments.getSuites()).length > 0) {
                Path projectFolderPath = projectData.getTargetFolderPath();
                FileWriter fw = new FileWriter(projectFolderPath.resolve("suites.xml").toFile());
                fw.write("<!DOCTYPE suite SYSTEM \"https://testng.org/testng-1.0.dtd\">");
                fw.write("<suite name=\"allSuites\">");
                fw.write("<suite-files>");
                for (int i = 0; i < suites.length; ++i) {
                    String suitePath = Generator.findSuiteFile(suites[i]);
                    if (suitePath == null) continue;
                    fw.write("<suite-file path=\"" + suitePath + "\"/>");
                }
                fw.write("</suite-files>");
                fw.write("</suite>");
                fw.close();
            }
        } else {
            ATS.logInfo("No valid Ats project found at -> " + arguments.getProjectFolder());
        }
    }

    public static String findSuiteFile(String s) {
        if (Paths.get((String)s, new String[0]).toFile().exists()) {
            return s;
        }
        if (Paths.get((String)s + ".xml", new String[0]).toFile().exists()) {
            return (String)s + ".xml";
        }
        if (Paths.get((String)(s = "src/exec/" + (String)s), new String[0]).toFile().exists()) {
            return s;
        }
        if (Paths.get((String)s + ".xml", new String[0]).toFile().exists()) {
            return (String)s + ".xml";
        }
        return null;
    }

    public Generator(String projectPath) {
        this(new File(projectPath));
    }

    public Generator(File atsFile) {
        this(Project.getProjectData(atsFile, null, null));
    }

    public Generator(Project project) {
        if (this.init(project) && this.remainingScripts > 0) {
            project.initFolders();
            this.genReport.startGenerator(this.remainingScripts);
            this.lexer = new Lexer(project, this.genReport, StandardCharsets.UTF_8);
        } else {
            ATS.logInfo("Nothing to be done (no ATS files found !)");
        }
    }

    private boolean init(Project p) {
        if (p.isValidated()) {
            this.genReport = new GeneratorReport();
            this.project = p;
            this.filesList = this.project.getAtsScripts();
            this.remainingScripts = this.filesList.size();
            return true;
        }
        return false;
    }

    private void addDataFile(ArrayList<File> list, File f) {
        if (f.getName().toLowerCase().endsWith(".csv") || f.getName().toLowerCase().endsWith(".json")) {
            list.add(f);
        }
    }

    public GeneratorReport launch() {
        if (this.project.getJavaSourceFolder().toFile().exists()) {
            Utils.copyDir(this.project.getJavaSourceFolder().toString(), this.project.getJavaDestinationFolder().toString(), true);
        }
        Stream stream = this.filesList.parallelStream();
        stream.forEach(f -> this.generateJava((File)f));
        stream.close();
        this.genReport.endGenerator();
        this.filesList.clear();
        this.lexer = null;
        return this.genReport;
    }

    private void generateJava(File f) {
        ScriptLoader sc = this.lexer.loadScript(f, new ScriptProcessedNotifier(this));
        sc.generateJavaFile(this.project);
    }

    public ArrayList<String> findSubscriptRef(String calledScript) {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : this.filesList) {
            ScriptLoader sc = this.lexer.loadScript(file, new ScriptProcessedNotifier(this));
            if (!sc.isSubscriptCalled(calledScript)) continue;
            result.add(sc.getHeader().getQualifiedName());
        }
        ArrayList dataFiles = new ArrayList();
        try {
            Files.find(this.project.getAssetsFolderPath(), 99999, (p, bfa) -> bfa.isRegularFile(), new FileVisitOption[0]).forEach(p -> this.addDataFile(dataFiles, p.toFile()));
            block8: for (File f : dataFiles) {
                String[] stringArray = f.getName().split("\\.");
                String fileExtension = stringArray[stringArray.length - 1];
                if (fileExtension.equalsIgnoreCase("csv")) {
                    CSVReader csvReader = new CSVReader((Reader)new FileReader(f.getAbsolutePath()));
                    try {
                        String[] values;
                        while ((values = csvReader.readNext()) != null) {
                            List<String> list = Arrays.asList(values);
                            if (!list.contains(calledScript)) continue;
                            result.add(f.getCanonicalPath());
                            continue block8;
                        }
                        continue;
                    }
                    finally {
                        csvReader.close();
                        continue;
                    }
                }
                Scanner scanner = new Scanner(f);
                while (scanner.hasNext()) {
                    String line = scanner.next();
                    if (!line.equals(calledScript) && !line.contains("\"" + calledScript + "\"")) continue;
                    result.add(f.getCanonicalPath());
                    break;
                }
                scanner.close();
            }
        }
        catch (CsvValidationException | IOException throwable) {
            throwable.printStackTrace();
        }
        return result;
    }

    @Override
    public void scriptProcessed() {
        --this.remainingScripts;
    }
}

