/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.objects;

import com.ats.generator.objects.Cartesian;
import com.ats.generator.variables.CalculatedValue;
import com.ats.tools.Utils;

public class MouseDirectionData {
    private Cartesian type;
    private CalculatedValue value = new CalculatedValue("0");

    public MouseDirectionData() {
    }

    public MouseDirectionData(String name, CalculatedValue value) {
        this.setName(name);
        this.setValue(value);
    }

    public MouseDirectionData(Cartesian type, CalculatedValue value) {
        this.type = type;
        this.setValue(value);
    }

    public int getHorizontalDirection() {
        if (Cartesian.RIGHT.equals((Object)this.type)) {
            return this.getIntValue();
        }
        if (Cartesian.LEFT.equals((Object)this.type)) {
            return -this.getIntValue();
        }
        return 0;
    }

    public int getVerticalDirection() {
        if (Cartesian.BOTTOM.equals((Object)this.type)) {
            return this.getIntValue();
        }
        if (Cartesian.TOP.equals((Object)this.type)) {
            return -this.getIntValue();
        }
        return 0;
    }

    public int getIntValue() {
        return this.value.getCalculated() != "" ? Utils.string2Int(this.value.getCalculated()) : Utils.string2Int(this.value.getData());
    }

    public String getJavaCode() {
        if (("0".equals(this.value.getCalculated()) || "".equals(this.value.getCalculated())) && (Cartesian.MIDDLE.equals((Object)this.type) || Cartesian.CENTER.equals((Object)this.type))) {
            return "";
        }
        return this.type.getJavacode() + ", " + this.value.getJavaCode();
    }

    public String getName() {
        return this.type.toString();
    }

    public void setName(String value) {
        this.type = Cartesian.valueOf(value.toUpperCase());
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }
}

