/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.objects;

import com.ats.tools.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class TryAndDelay {
    private static final String TRY_LABEL = "try";
    private static final String[] LABEL_REPLACE = new String[]{"try", "=", " ", "(", ")"};
    private static final String[] LABEL_REPLACEMENT = new String[]{"", "", "", "", ""};
    private static final String DELAY_LABEL = "delay";
    private static final String[] DELAY_REPLACE = new String[]{"delay", "=", " "};
    private static final String[] DELAY_REPLACEMENT = new String[]{"", "", ""};
    private int maxTry = 0;
    private int delay = 0;

    public TryAndDelay() {
    }

    public TryAndDelay(int maxTry, int delay) {
        this.setMaxTry(maxTry);
        this.setDelay(delay);
    }

    public TryAndDelay(ArrayList<String> options) {
        int[] data = TryAndDelay.getTryAndDelay(options);
        this.setMaxTry(data[0]);
        this.setDelay(data[1]);
    }

    public StringBuilder getJavaCode() {
        return new StringBuilder(Integer.toString(this.maxTry)).append(", ").append(this.delay).append(", ");
    }

    public static int[] getTryAndDelay(ArrayList<String> options) {
        int[] result = new int[]{0, 0};
        Iterator<String> itr = options.iterator();
        while (itr.hasNext()) {
            String opt = itr.next().toLowerCase();
            if (opt.contains(TRY_LABEL)) {
                result[0] = Utils.string2Int(StringUtils.replaceEach((String)opt, (String[])LABEL_REPLACE, (String[])LABEL_REPLACEMENT));
                itr.remove();
                continue;
            }
            if (!opt.contains(DELAY_LABEL)) continue;
            result[1] = Utils.string2Int(StringUtils.replaceEach((String)opt, (String[])DELAY_REPLACE, (String[])DELAY_REPLACEMENT));
            itr.remove();
        }
        return result;
    }

    public int getMaxTry() {
        return this.maxTry;
    }

    public void setMaxTry(int maxTry) {
        this.maxTry = Math.max(maxTry, -10);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = Math.max(delay, 0);
    }
}

