/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.parsers;

import com.ats.generator.GeneratorReport;
import com.ats.generator.events.ScriptProcessedNotifier;
import com.ats.generator.variables.BaseValue;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.EnvironmentValue;
import com.ats.generator.variables.ParameterValue;
import com.ats.generator.variables.Variable;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionApi;
import com.ats.script.actions.ActionAssertCount;
import com.ats.script.actions.ActionAssertProperty;
import com.ats.script.actions.ActionAssertValue;
import com.ats.script.actions.ActionButton;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionChannelClose;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionChannelSwitch;
import com.ats.script.actions.ActionComment;
import com.ats.script.actions.ActionGesturePress;
import com.ats.script.actions.ActionGestureTap;
import com.ats.script.actions.ActionGotoUrl;
import com.ats.script.actions.ActionMouse;
import com.ats.script.actions.ActionMouseDragDrop;
import com.ats.script.actions.ActionMouseKey;
import com.ats.script.actions.ActionMouseScroll;
import com.ats.script.actions.ActionMouseSwipe;
import com.ats.script.actions.ActionProperty;
import com.ats.script.actions.ActionPropertySet;
import com.ats.script.actions.ActionScripting;
import com.ats.script.actions.ActionSelect;
import com.ats.script.actions.ActionText;
import com.ats.script.actions.ActionWindowResize;
import com.ats.script.actions.ActionWindowState;
import com.ats.script.actions.ActionWindowSwitch;
import com.ats.script.actions.neoload.ActionNeoloadContainer;
import com.ats.script.actions.neoload.ActionNeoloadRecord;
import com.ats.script.actions.neoload.ActionNeoloadStart;
import com.ats.script.actions.neoload.ActionNeoloadStop;
import com.ats.script.actions.performance.ActionPerformanceRecord;
import com.ats.script.actions.performance.ActionPerformanceStart;
import com.ats.script.actions.performance.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.Utils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lexer {
    private final Pattern ACTION_PATTERN = Pattern.compile("(.*)\\[(.*?)\\]", 2);
    private GeneratorReport report;
    private Project projectData;
    private Charset charset = StandardCharsets.UTF_8;
    public int countScript = 0;
    private boolean isGenerator = true;

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public Lexer(GeneratorReport report) {
        this.isGenerator = false;
        this.report = report;
    }

    public Lexer(Project projectData, GeneratorReport report, String charset) {
        this.projectData = projectData;
        this.report = report;
        try {
            this.charset = Charset.forName(charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Lexer(Project projectData, GeneratorReport report, Charset charset) {
        this.projectData = projectData;
        this.report = report;
        this.charset = charset;
    }

    public void addScript() {
        ++this.countScript;
    }

    public ScriptLoader loadScript(File f, ScriptProcessedNotifier notifier) {
        ScriptLoader script = this.getScript(f);
        notifier.scriptProcessed();
        return script;
    }

    public ScriptLoader loadScript(File f) {
        return this.getScript(f);
    }

    private ScriptLoader getScript(File f) {
        if (f.exists() && f.isFile()) {
            return new ScriptLoader("ats", this, f, this.projectData, this.charset);
        }
        return null;
    }

    public void createAction(ScriptLoader script, String data, boolean disabled) {
        ArrayList<String> dataArray = new ArrayList<String>(Arrays.asList(data.split("->")));
        if (dataArray.size() > 0) {
            String actionType = dataArray.remove(0).trim();
            String optionsFlat = "";
            ArrayList<String> options = new ArrayList<String>();
            int stopPolicy = 0;
            Matcher matcher = this.ACTION_PATTERN.matcher(actionType);
            if (matcher.find()) {
                actionType = matcher.group(1).trim().toLowerCase();
                optionsFlat = matcher.group(2).trim();
                Collections.addAll(options, optionsFlat.split(","));
                if (options.removeIf(s -> s.equalsIgnoreCase("nofail"))) {
                    stopPolicy = 1;
                }
                if (options.removeIf(s -> s.equalsIgnoreCase("testfail"))) {
                    stopPolicy = 2;
                }
            }
            if ("press".equals(actionType)) {
                String elementInfo = dataArray.remove(dataArray.size() - 1).trim();
                ArrayList<String> elements = new ArrayList<String>(Arrays.asList(elementInfo));
                script.addAction(new ActionGesturePress((Script)script, stopPolicy, options, dataArray, elements), disabled);
            } else if ("over".equals(actionType)) {
                script.addAction(new ActionMouse(script, "over", stopPolicy, options, dataArray), disabled);
            } else if ("drag".equals(actionType) || "drop".equals(actionType)) {
                script.addAction(new ActionMouseDragDrop(script, actionType, stopPolicy, options, dataArray), disabled);
            } else if (actionType.startsWith("click")) {
                script.addAction(new ActionMouseKey(script, actionType, stopPolicy, options, dataArray), disabled);
            } else if ("channel-close".equals(actionType)) {
                String cname = "";
                if (dataArray.size() > 0) {
                    cname = dataArray.remove(0).trim();
                }
                script.addAction(new ActionChannelClose(script, cname, options.contains("nostop")), disabled);
            } else if ("perf-record".equals(actionType)) {
                if (dataArray.size() > 0) {
                    script.addAction(new ActionPerformanceRecord(script, dataArray.remove(0).trim()), disabled);
                }
            } else if ("perf-start".equals(actionType)) {
                script.addAction(new ActionPerformanceStart(script, options, dataArray), disabled);
            } else if ("octoperf-vu".equals(actionType)) {
                if (dataArray.size() > 0) {
                    script.addAction(new ActionOctoperfVirtualUser(script, options, dataArray), disabled);
                }
            } else if ("neoload-start".equals(actionType) || "neoload-stop".equals(actionType)) {
                String userData = null;
                if (dataArray.size() > 0) {
                    userData = dataArray.remove(0).trim();
                }
                optionsFlat = optionsFlat.toLowerCase();
                if ("neoload-start".equals(actionType)) {
                    script.addAction(new ActionNeoloadStart(script, optionsFlat, userData), disabled);
                } else {
                    String userOptions = "";
                    if (userData != null && (matcher = this.ACTION_PATTERN.matcher(userData)).find()) {
                        userData = matcher.group(1).trim();
                        userOptions = matcher.group(2).trim().toLowerCase();
                    }
                    script.addAction(new ActionNeoloadStop(script, optionsFlat, userData, userOptions), disabled);
                }
            } else if (actionType.startsWith("comment")) {
                script.addAction(new ActionComment(script, actionType, dataArray), disabled);
            } else if ("keyboard".equals(actionType)) {
                String dataText = "";
                if (dataArray.size() > 0) {
                    dataText = dataArray.remove(0).trim();
                }
                script.addAction(new ActionText(script, stopPolicy, options, dataText, dataArray), disabled);
            } else if (dataArray.size() > 0) {
                String dataOne = dataArray.remove(0).trim();
                if ("property-set".equals(actionType)) {
                    String propertyValue = "";
                    if (dataArray.size() > 0) {
                        propertyValue = dataArray.remove(0).trim();
                    }
                    script.addAction(new ActionPropertySet((Script)script, dataOne, propertyValue), disabled);
                } else if ("button".equals(actionType)) {
                    script.addAction(new ActionButton((Script)script, dataOne), disabled);
                } else if ("tap".equals(actionType)) {
                    script.addAction(new ActionGestureTap((Script)script, dataOne, stopPolicy, options, dataArray), disabled);
                } else if ("channel-switch".equals(actionType)) {
                    script.addAction(new ActionChannelSwitch(script, dataOne), disabled);
                } else if ("channel-start".equals(actionType)) {
                    if (dataArray.size() > 0) {
                        script.addAction(new ActionChannelStart(script, dataOne, options, new CalculatedValue(script, dataArray.remove(0).trim()), dataArray), disabled);
                    }
                } else if (actionType.startsWith("api-")) {
                    String headerData = "";
                    matcher = this.ACTION_PATTERN.matcher(dataOne);
                    if (matcher.find()) {
                        dataOne = matcher.group(1).trim();
                        headerData = matcher.group(2).trim();
                    }
                    script.addAction(new ActionApi(script, actionType, optionsFlat.toLowerCase(), dataOne, headerData, dataArray), disabled);
                } else if ("window-resize".equals(actionType)) {
                    script.addAction(new ActionWindowResize(script, dataOne), disabled);
                } else if ("window-state".equals(actionType)) {
                    script.addAction(new ActionWindowState(script, dataOne), disabled);
                } else if (actionType.startsWith("window-")) {
                    script.addAction(new ActionWindowSwitch(script, Utils.string2Int(dataOne), options), disabled);
                    if ("window-close".equals(actionType)) {
                        script.addAction(new ActionWindowState(script, "close"), disabled);
                    }
                } else if (actionType.equals("scripting") || actionType.equals("javascript")) {
                    String[] jsDataArray = dataOne.split("=>");
                    if (jsDataArray.length > 0) {
                        Variable variable = null;
                        String jsCode = jsDataArray[0].trim();
                        if (jsDataArray.length > 1) {
                            variable = script.getVariable(jsDataArray[1].trim(), true);
                        }
                        script.addAction(new ActionScripting(script, stopPolicy, options, jsCode, variable, dataArray), disabled);
                    }
                } else if (actionType.startsWith("property")) {
                    String[] propertyArray = dataOne.split("=>");
                    if (propertyArray.length > 1) {
                        String propertyName = propertyArray[0].trim();
                        Variable variable = script.getVariable(propertyArray[1].trim(), true);
                        script.addAction(new ActionProperty((Script)script, stopPolicy, options, propertyName, variable, dataArray), disabled);
                    }
                } else if (actionType.contains("select")) {
                    script.addAction(new ActionSelect(script, dataOne, stopPolicy, options, dataArray), disabled);
                } else if ("subscript".equals(actionType)) {
                    String[] parameters = new String[]{};
                    String[] returnValues = new String[]{};
                    String csvFilePath = null;
                    if (dataOne.contains("=>")) {
                        String[] callscriptData = dataOne.split("=>");
                        dataOne = callscriptData[0].trim();
                        returnValues = callscriptData[1].split(",");
                    }
                    if (dataArray.size() > 0) {
                        String firstValue = dataArray.get(0).trim();
                        if (firstValue.startsWith("assets:///") || firstValue.startsWith("file:///") || firstValue.startsWith("http://") || firstValue.startsWith("https://")) {
                            csvFilePath = dataArray.remove(0).trim();
                        }
                    } else {
                        matcher = this.ACTION_PATTERN.matcher(dataOne);
                        if (matcher.find()) {
                            BaseValue sp;
                            dataOne = matcher.group(1).trim();
                            String parametersData = matcher.group(2);
                            Matcher mv = CalculatedValue.PARAMETER_PATTERN.matcher(parametersData);
                            while (mv.find()) {
                                sp = new ParameterValue(mv);
                                parametersData = parametersData.replace(sp.getReplace(), sp.getNoComma());
                            }
                            mv = CalculatedValue.ENV_PATTERN.matcher(parametersData);
                            while (mv.find()) {
                                sp = new EnvironmentValue(mv);
                                parametersData = parametersData.replace(sp.getReplace(), sp.getNoComma());
                            }
                            parameters = parametersData.split(",");
                        }
                    }
                    script.addAction(new ActionCallscript(script, options, dataOne, parameters, returnValues, csvFilePath, dataArray), disabled);
                } else if ("goto-url".equals(actionType) || "open-url".equals(actionType) || "goto".equals(actionType)) {
                    script.addAction(new ActionGotoUrl(script, stopPolicy, new CalculatedValue(script, dataOne)), disabled);
                } else if ("scroll".equals(actionType)) {
                    script.addAction(new ActionMouseScroll(script, dataOne, stopPolicy, options, dataArray), disabled);
                } else if ("swipe".equals(actionType)) {
                    script.addAction(new ActionMouseSwipe(script, actionType, dataOne, stopPolicy, options, dataArray), disabled);
                } else if ("check-count".equals(actionType)) {
                    script.addAction(new ActionAssertCount(script, stopPolicy, options, dataOne, dataArray), disabled);
                } else if ("check-property".equals(actionType)) {
                    script.addAction(new ActionAssertProperty(script, stopPolicy, options, dataOne, dataArray), disabled);
                } else if ("check-value".equals(actionType)) {
                    script.addAction(new ActionAssertValue(script, stopPolicy, dataOne), disabled);
                } else if ("neoload-container".equals(actionType)) {
                    if (dataOne.length() > 0) {
                        script.addAction(new ActionNeoloadContainer(script, dataOne), disabled);
                    }
                } else if ("neoload-record".equals(actionType)) {
                    script.addAction(new ActionNeoloadRecord(script, dataOne), disabled);
                }
            } else if (!(data.startsWith("<<<<<<<") || data.startsWith("=======") || data.startsWith(">>>>>>>"))) {
                script.addAction(new ActionComment(script, data), disabled);
            }
        }
    }
}

