/*
 * Decompiled with CFR 0.152.
 */
package com.ats.graphic;

import com.ats.driver.AtsManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;

public class ImageTemplateMatchingSimple {
    private static final double[] GRAYSCALE = new double[]{0.2126, 0.7152, 0.0722};
    private static final double PERCENT_DEFAULT = 0.3;
    private static final int MAX_PIXELS_DIFF = 10;
    private int targetWidth = 100;
    private int targetHeight = 100;
    private int[][] target;
    private int maxPixelsError = 0;

    public ImageTemplateMatchingSimple(int[][] image) {
        this.target = image;
        if (image != null) {
            this.targetWidth = image.length;
            this.targetHeight = image[0].length;
            this.setPercentError(0.3);
        }
    }

    public ImageTemplateMatchingSimple(BufferedImage image) {
        this(ImageTemplateMatchingSimple.getVector(image));
    }

    public ImageTemplateMatchingSimple(byte[] image) {
        this(ImageTemplateMatchingSimple.getVector(ImageTemplateMatchingSimple.getBufferedImage(image)));
    }

    public void setError(int value) {
        this.maxPixelsError = value;
    }

    public void setPercentError(double value) {
        this.maxPixelsError = ImageTemplateMatchingSimple.getMaxError(this.targetWidth, this.targetWidth, value);
    }

    public ArrayList<Rectangle> findOccurrences(byte[] imageData) {
        BufferedImage image = ImageTemplateMatchingSimple.getBufferedImage(imageData);
        if (image != null) {
            return this.findOccurrences(image);
        }
        return new ArrayList<Rectangle>();
    }

    public ArrayList<Rectangle> findOccurrences(BufferedImage mainImage) {
        return ImageTemplateMatchingSimple.getLocations(mainImage, this.target, this.targetWidth, this.targetHeight, this.maxPixelsError, 10);
    }

    private static int getMaxError(int width, int height, double percent) {
        return (int)((double)(width * height) * percent / 100.0);
    }

    private static BufferedImage getBufferedImage(byte[] image) {
        BufferedImage result = null;
        ByteArrayInputStream in = new ByteArrayInputStream(image);
        try {
            result = ImageIO.read(in);
            ((InputStream)in).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static ArrayList<Rectangle> getLocations(byte[] mainImageInBytes, BufferedImage subImage, int maxError, int maxDiff) {
        ByteArrayInputStream in = new ByteArrayInputStream(mainImageInBytes);
        try {
            return ImageTemplateMatchingSimple.getLocations(ImageIO.read(in), ImageTemplateMatchingSimple.getVector(subImage), subImage.getWidth(), subImage.getHeight(), maxError, maxDiff);
        }
        catch (IOException e) {
            return new ArrayList<Rectangle>();
        }
    }

    public static ArrayList<Rectangle> getLocations(BufferedImage mainImage, BufferedImage subImage, int maxError, int maxDiff) {
        return ImageTemplateMatchingSimple.getLocations(mainImage, ImageTemplateMatchingSimple.getVector(subImage), subImage.getWidth(), subImage.getHeight(), maxError, maxDiff);
    }

    private static ArrayList<Rectangle> getLocations(BufferedImage mainImage, int[][] subVector, int subWidth, int subHeight, int maxError, int maxDiff) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        int[][] mainVector = ImageTemplateMatchingSimple.getVector(mainImage);
        int[][] burnedPixels = new int[mainImage.getWidth()][mainImage.getHeight()];
        int maxTryImageRecognition = AtsManager.getInstance().getMaxTryImageRecognition();
        if (mainVector != null && subVector != null) {
            int xOffsetMax = mainImage.getWidth() - subWidth;
            int yOffsetMax = mainImage.getHeight() - subHeight;
            Rectangle found = ImageTemplateMatchingSimple.findSubImage(mainVector, burnedPixels, xOffsetMax, yOffsetMax, subVector, subWidth, subHeight, maxError, maxDiff);
            while (found != null && result.size() < maxTryImageRecognition) {
                result.add(found);
                found = ImageTemplateMatchingSimple.findSubImage(mainVector, burnedPixels, xOffsetMax, yOffsetMax, subVector, subWidth, subHeight, maxError, maxDiff);
            }
        }
        return result;
    }

    private static int[][] getVector(BufferedImage img) {
        if (img != null) {
            int[][] data = new int[img.getWidth()][img.getHeight()];
            IntStream.range(0, data.length).parallel().forEach(x -> Arrays.parallelSetAll(data[x], y -> ImageTemplateMatchingSimple.pixelGrayed(img.getRGB(x, y))));
            return data;
        }
        return null;
    }

    private static Rectangle findSubImage(int[][] mainVector, int[][] burned, int xOffsetMax, int yOffsetMax, int[][] subImage, int subWidth, int subHeight, int maxError, int maxDiff) {
        for (int x = 0; x < xOffsetMax; ++x) {
            for (int y = 0; y < yOffsetMax; ++y) {
                if (burned[x][y] != 0 || !ImageTemplateMatchingSimple.subImageIsAtOffset(subImage, mainVector, x, y, subWidth, subHeight, maxError, maxDiff)) continue;
                int x0 = x;
                int y0 = y;
                int w0 = x0 + subWidth;
                int h0 = y0 + subHeight;
                IntStream.range(x0, w0).parallel().forEach(x1 -> IntStream.range(y0, h0).parallel().forEach(y1 -> {
                    burned[x1][y1] = 1;
                }));
                return new Rectangle(x, y, subWidth, subHeight);
            }
        }
        return null;
    }

    private static boolean subImageIsAtOffset(int[][] subImage, int[][] image, int xOffset, int yOffset, int width, int height, int maxError, int maxDiff) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (Math.abs(subImage[x][y] - image[xOffset + x][yOffset + y]) <= maxDiff) continue;
                if (maxError <= 0) {
                    return false;
                }
                --maxError;
            }
        }
        return true;
    }

    private static int pixelGrayed(int rgb) {
        return (int)(GRAYSCALE[0] * (double)(rgb >> 16 & 0xFF) + GRAYSCALE[1] * (double)(rgb >> 8 & 0xFF) + GRAYSCALE[2] * (double)(rgb & 0xFF));
    }
}

