/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.executor.ScriptStatus;
import com.ats.recorder.ReportSummaryError;
import java.util.ArrayList;

public class ReportSummary {
    public static final String EMPTY_VALUE = "[empty]";
    private int status = 1;
    private String data = "";
    private String suiteName = "";
    private String testName = "";
    private int actions = 0;
    private ReportSummaryError error;

    public void appendData(String value) {
        this.data = this.data + value + "<br>";
    }

    public void setFailData(String script, int line, String message) {
        this.status = 0;
        this.error = new ReportSummaryError(script, line, message);
    }

    public Object[] toData(ScriptStatus st) {
        if (this.data == null || this.data.isEmpty()) {
            this.data = EMPTY_VALUE;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(st.isPassed());
        result.add(st.getActions());
        result.add(st.getSuiteName());
        result.add(st.getTestName());
        result.add(this.data);
        if (this.status == 0 && this.error != null) {
            result.add(this.error.getScriptName());
            result.add(this.error.getLine());
            result.add(this.error.getMessage());
        }
        return result.toArray();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public int getActions() {
        return this.actions;
    }

    public void setActions(int actions) {
        this.actions = actions;
    }

    public ReportSummaryError getError() {
        return this.error;
    }

    public void setError(ReportSummaryError error) {
        this.error = error;
    }
}

