/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.recorder.VisualElement;
import com.ats.recorder.VisualImage;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionComment;
import java.beans.Transient;
import java.nio.file.Path;
import java.util.ArrayList;

public class VisualAction {
    private int index;
    private Long timeLine;
    private int error;
    private long duration;
    private ArrayList<byte[]> images;
    private int imageRef;
    private String imageType;
    private String channelName;
    private TestBound channelBound;
    private String type;
    private int line;
    private String script;
    private String value = "";
    private String data = "";
    private boolean stop = true;
    private VisualElement element;

    public VisualAction() {
    }

    public VisualAction(Channel channel, Action action) {
        if (!(action instanceof ActionComment)) {
            this.images = new ArrayList();
            this.images.add(channel.getScreenShot());
        }
        this.type = action.getClass().getSimpleName();
        this.line = action.getLine();
        this.timeLine = System.currentTimeMillis();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public TestBound getChannelBound() {
        return this.channelBound;
    }

    public void setChannelBound(TestBound channelBound) {
        this.channelBound = channelBound;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        if (value != null) {
            this.data = value;
        }
    }

    public VisualElement getElement() {
        return this.element;
    }

    public void setElement(VisualElement element) {
        this.element = element;
    }

    @Transient
    public ArrayList<byte[]> getImages() {
        return this.images;
    }

    public void setImages(ArrayList<byte[]> list) {
        this.images = list;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getTimeLine() {
        return this.timeLine;
    }

    public void setTimeLine(Long timeLine) {
        this.timeLine = timeLine;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value != null) {
            this.value = value;
        }
    }

    public int getImageRef() {
        return this.imageRef;
    }

    public void setImageRef(int imageRef) {
        this.imageRef = imageRef;
    }

    public void addImage(Path folder, ArrayList<VisualImage> imagesList) {
        if (this.images.size() > 0) {
            if (this.element != null && this.element.getBound() != null) {
                int imageRef = 0;
                if (this.images.size() > this.getImageRef()) {
                    imageRef = this.getImageRef();
                }
                imagesList.add(new VisualImage(folder, this.getImageFileName(), this.getImageType(), this.images.get(imageRef), this.element.getBound()));
            } else {
                imagesList.add(new VisualImage(folder, this.getImageFileName(), this.getImageType(), this.images.get(this.images.size() - 1)));
            }
        }
    }

    public String getImageFileName() {
        return this.index + "." + this.imageType;
    }
}

