/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.Action;
import com.ats.tools.Utils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class ActionApi
extends Action {
    public static final String SCRIPT_LABEL = "api-";
    private static final int SCRIPT_LABEL_LENGTH = "api-".length();
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    public static final String SOAP = "SOAP";
    public static final String REST = "REST";
    private static final String CACHE_LABEL = "cache";
    private CalculatedValue method;
    private CalculatedValue data;
    private boolean useCache = false;
    private List<CalculatedProperty> header;
    private String type = "GET";
    private int port = -1;

    public ActionApi() {
    }

    public ActionApi(Script script, String type, String options, String method, String headerData, ArrayList<String> data) {
        super(script);
        this.setType(type.substring(SCRIPT_LABEL_LENGTH));
        this.setMethod(new CalculatedValue(script, method));
        this.header = new ArrayList<CalculatedProperty>();
        if (headerData.length() > 0) {
            Arrays.stream(headerData.split(",")).forEach(s -> this.header.add(new CalculatedProperty(script, (String)s)));
        }
        if (data.size() > 0) {
            this.setData(new CalculatedValue(script, data.get(0).trim()));
        }
        if (options.contains(CACHE_LABEL)) {
            this.useCache = true;
            options.replace(CACHE_LABEL, "");
        }
        this.port = Utils.string2Int(options.replace(",", ""), -1);
    }

    public ActionApi(Script script, String type, CalculatedValue method, CalculatedValue data) {
        this(script, type, -1, false, method, data, new CalculatedProperty[0]);
    }

    public ActionApi(Script script, String type, int port, boolean cache, CalculatedValue method, CalculatedValue data, CalculatedProperty ... headerData) {
        super(script);
        this.setType(type);
        this.setPort(port);
        this.setUseCache(cache);
        this.setMethod(method);
        this.setData(data);
        this.setHeader(new ArrayList<CalculatedProperty>(Arrays.asList(headerData)));
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append("\"").append(this.type).append("\", ").append(this.port).append(", ").append(this.useCache).append(", ").append(this.method.getJavaCode()).append(", ");
        if (this.data != null) {
            codeBuilder.append(this.data.getJavaCode());
        } else {
            codeBuilder.append("null");
        }
        if (this.header != null && this.header.size() > 0) {
            codeBuilder.append(", ");
            StringJoiner joiner = new StringJoiner(", ");
            for (CalculatedProperty head : this.header) {
                joiner.add(head.getJavaCode());
            }
            codeBuilder.append(joiner.toString());
        }
        codeBuilder.append(")");
        return codeBuilder;
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        super.execute(ts, testName, testLine);
        this.getCurrentChannel().api(this.status, this);
        this.status.endDuration();
        return true;
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("type", this.type);
        data.addProperty("method", this.method.getCalculated());
        Object statusData = this.status.getData();
        if (statusData == null) {
            data.addProperty(this.status.getMessage(), "");
        } else {
            data.addProperty(this.status.getMessage(), statusData.toString());
        }
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<CalculatedProperty> getHeader() {
        return this.header;
    }

    public void setHeader(List<CalculatedProperty> data) {
        this.header = data;
    }

    public CalculatedValue getMethod() {
        return this.method;
    }

    public void setMethod(CalculatedValue endPoint) {
        this.method = endPoint;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = POST.equalsIgnoreCase(type) || PUT.equalsIgnoreCase(type) || DELETE.equalsIgnoreCase(type) || SOAP.equalsIgnoreCase(type) || PATCH.equalsIgnoreCase(type) ? type.toUpperCase() : GET;
    }

    public CalculatedValue getData() {
        return this.data;
    }

    public void setData(CalculatedValue value) {
        this.data = value;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean value) {
        this.useCache = value;
    }
}

