/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions.performance;

import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.script.Script;
import com.ats.script.actions.performance.ActionPerformance;
import com.ats.tools.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class ActionPerformanceStart
extends ActionPerformance {
    public static final String SCRIPT_LABEL = "perf-start";
    public static final String SEND_LABEL = "upload";
    public static final String RECEIVE_LABEL = "download";
    public static final String IDLE_LABEL = "idle";
    public static final String LATENCY_LABEL = "latency";
    private static final String[] LABEL_REPLACE = new String[]{"upload", "download", "idle", "latency", "=", " "};
    private static final String[] LABEL_REPLACEMENT = new String[]{"", "", "", "", "", ""};
    private long sendBandWidth = 0L;
    private long receiveBandWidth = 0L;
    private int latency = 0;
    private int trafficIdle = 0;
    private List<String> whiteList = null;
    private String filters = "";

    public ActionPerformanceStart() {
    }

    public ActionPerformanceStart(Script script, ArrayList<String> options, ArrayList<String> dataArray) {
        super(script);
        this.setWhiteList(dataArray.stream().map(String::trim).collect(Collectors.toList()));
        this.loadBandwidthValues(options);
    }

    public ActionPerformanceStart(Script script, int iddle, int ltcy, long sbw, long rbw, String[] whiteList) {
        super(script);
        this.setTrafficIdle(iddle);
        this.setSendBandWidth(sbw);
        this.setReceiveBandWidth(rbw);
        this.setWhiteList(Arrays.asList(whiteList));
    }

    private void loadBandwidthValues(ArrayList<String> options) {
        Iterator<String> itr = options.iterator();
        while (itr.hasNext()) {
            String opt = itr.next().toLowerCase();
            if (opt.contains(SEND_LABEL)) {
                this.sendBandWidth = Utils.string2Long(StringUtils.replaceEach((String)opt, (String[])LABEL_REPLACE, (String[])LABEL_REPLACEMENT));
                continue;
            }
            if (opt.contains(RECEIVE_LABEL)) {
                this.receiveBandWidth = Utils.string2Long(StringUtils.replaceEach((String)opt, (String[])LABEL_REPLACE, (String[])LABEL_REPLACEMENT));
                continue;
            }
            if (opt.contains(LATENCY_LABEL)) {
                this.latency = Utils.string2Int(StringUtils.replaceEach((String)opt, (String[])LABEL_REPLACE, (String[])LABEL_REPLACEMENT));
                continue;
            }
            if (!opt.contains(IDLE_LABEL)) continue;
            this.trafficIdle = Utils.string2Int(StringUtils.replaceEach((String)opt, (String[])LABEL_REPLACE, (String[])LABEL_REPLACEMENT));
        }
    }

    @Override
    public StringBuilder getJavaCode() {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (String s : this.whiteList) {
            list.add((CallSite)((Object)("\"" + StringEscapeUtils.escapeJava((String)s) + "\"")));
        }
        return super.getJavaCode().append(this.trafficIdle).append(", ").append(this.latency).append(", ").append(this.sendBandWidth).append("L, ").append(this.receiveBandWidth).append("L, new String[]{").append(String.join((CharSequence)", ", list)).append("})");
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        Channel channel = ts.getCurrentChannel();
        this.setStatus(channel.newActionStatus(testName, testLine));
        channel.startHarServer(this.status, this.whiteList, this.trafficIdle, this.latency, this.sendBandWidth, this.receiveBandWidth);
        this.status.endDuration();
        return true;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int latency) {
        this.latency = latency;
    }

    public int getTrafficIdle() {
        return this.trafficIdle;
    }

    public void setTrafficIdle(int value) {
        this.trafficIdle = value;
    }

    public long getSendBandWidth() {
        return this.sendBandWidth;
    }

    public void setSendBandWidth(long value) {
        this.sendBandWidth = value;
    }

    public long getReceiveBandWidth() {
        return this.receiveBandWidth;
    }

    public void setReceiveBandWidth(long value) {
        this.receiveBandWidth = value;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public void setWhiteList(List<String> data) {
        this.whiteList = data;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }
}

