/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.tools.ResourceContent;
import com.ats.tools.Utils;
import com.ats.tools.report.MinifyWriter;
import com.ats.tools.report.SuitesReport;
import com.ats.tools.report.SuitesReportItem;
import com.ats.tools.report.XmlReport;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CampaignReportGenerator {
    public static String ATS_JSON_SUITES = "ats-suites.json";
    public static final String ATS_REPORT = "ats-report";
    private static final String REPORT_FOLDER = "reports";
    private static final String TEMPLATE_FOLDER = "templates";
    private static final String IMAGE_FOLDER = "images";
    private static final String CUSTOM_TEMPLATES_FOLDER = "/reports/templates/";
    private static final String CUSTOM_IMAGES_FOLDER = "/reports/images/";
    private static final String XML_SOURCE_NAME = "ats-report.xml";
    private static final String XML_SOURCE_ROOT = "ats-report";

    public static void main(String[] args) {
        String output = null;
        String details = null;
        String jasper = null;
        block14: for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (!string.startsWith("--") || i + 1 >= args.length) continue;
            switch (string.substring(2)) {
                case "outputFolder": 
                case "output": 
                case "reportFolder": {
                    output = args[i + 1].replaceAll("\"", "");
                    continue block14;
                }
                case "jasper": {
                    jasper = args[i + 1].replaceAll("\"", "");
                    continue block14;
                }
                case "details": {
                    details = args[i + 1];
                }
            }
        }
        if (output == null) {
            System.out.println("Error, output folder not defined !");
            return;
        }
        Path outputFolderPath = Paths.get(output, new String[0]).toAbsolutePath();
        if (!outputFolderPath.toFile().exists()) {
            System.out.println("Error, output folder path not found : " + output);
            return;
        }
        File jsonSuiteFilesFile = outputFolderPath.resolve(ATS_JSON_SUITES).toFile();
        if (jsonSuiteFilesFile.exists()) {
            try {
                new CampaignReportGenerator(outputFolderPath, jsonSuiteFilesFile, details, jasper);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Suites file not found : " + ATS_JSON_SUITES);
        }
    }

    public static void initFolders(Path projectPath) {
        try {
            projectPath.resolve(REPORT_FOLDER).toFile().mkdirs();
            projectPath.resolve(REPORT_FOLDER).resolve(CUSTOM_TEMPLATES_FOLDER).toFile().mkdirs();
            projectPath.resolve(REPORT_FOLDER).resolve(CUSTOM_IMAGES_FOLDER).toFile().mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void copyReportsTemplate(Path path, Path toPath) {
        if (Files.exists(path, new LinkOption[0])) {
            for (File f : path.toFile().listFiles()) {
                if (!f.isFile()) continue;
                try {
                    Files.copy(f.toPath(), toPath.resolve(f.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public CampaignReportGenerator(Path outputFolderPath, File jsonSuiteFilesFile, String reportLevel, String jasper) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        int detailsValue = Utils.string2Int(reportLevel, 0);
        if (detailsValue > 0) {
            File jasperFolder;
            String[] defaultImages;
            Path reportPath = Paths.get("src", "assets", "resources", REPORT_FOLDER);
            if (Files.exists(reportPath, new LinkOption[0])) {
                this.copyReportsTemplate(reportPath.resolve(TEMPLATE_FOLDER), outputFolderPath);
                this.copyReportsTemplate(reportPath.resolve(IMAGE_FOLDER), outputFolderPath);
            }
            SuitesReport suiteReport = null;
            try {
                JsonReader reader = new JsonReader((Reader)new FileReader(jsonSuiteFilesFile));
                suiteReport = (SuitesReport)new Gson().fromJson(reader, SuitesReport.class);
                reader.close();
            }
            catch (IOException reader) {
                // empty catch block
            }
            if (suiteReport == null) {
                System.out.println("No suites found, nothing to do !");
                return;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document writeXmlDocument = builder.newDocument();
            Element report = writeXmlDocument.createElement("ats-report");
            report.setAttribute("details", String.valueOf(detailsValue));
            report.setAttribute("projectId", suiteReport.projectId);
            report.setAttribute("projectDescription", suiteReport.projectDescription);
            writeXmlDocument.appendChild(report);
            Element picsList = writeXmlDocument.createElement("pics");
            for (String img : defaultImages = new String[]{"logo.png", "true.png", "false.png", "warning.png", "noStop.png", "pdf.png"}) {
                Element pic = writeXmlDocument.createElement("pic");
                pic.setAttribute("name", img.replace(".png", ""));
                Object[] imgBytes = null;
                imgBytes = Files.exists(outputFolderPath.resolve(img), new LinkOption[0]) ? (Object[])Files.readAllBytes(outputFolderPath.resolve(img)) : (Object[])ResourceContent.class.getResourceAsStream(CUSTOM_IMAGES_FOLDER + img).readAllBytes();
                pic.setTextContent("data:image/png;base64," + CampaignReportGenerator.getBase64DefaultImages((byte[])imgBytes));
                picsList.appendChild(pic);
            }
            report.appendChild(picsList);
            report.setAttribute("suitesCount", String.valueOf(suiteReport.suites.length));
            int totalTests = 0;
            int totalTestsPassed = 0;
            int totalSuitesPassed = 0;
            int totalActions = 0;
            int totalDuration = 0;
            for (SuitesReportItem info : suiteReport.suites) {
                Path suitePath = outputFolderPath.resolve(info.name);
                boolean suitePassed = true;
                Element suite = writeXmlDocument.createElement("suite");
                suite.setAttribute("name", info.name);
                suite.setAttribute("description", info.description);
                Element parameters = writeXmlDocument.createElement("parameters");
                suite.appendChild(parameters);
                Properties properties = new Properties();
                Path suiteParamPath = suitePath.resolve("parameters.txt");
                if (Files.exists(suiteParamPath, new LinkOption[0])) {
                    properties.load(Files.newBufferedReader(suiteParamPath));
                }
                for (Map.Entry<String, String> entry : info.parameters.entrySet()) {
                    Element parameter = writeXmlDocument.createElement("parameter");
                    parameter.setAttribute("name", entry.getKey());
                    parameter.setAttribute("value", properties.getProperty(entry.getKey(), entry.getValue()));
                    parameter.setAttribute("defaultValue", entry.getValue());
                    parameters.appendChild(parameter);
                }
                File[] tests = writeXmlDocument.createElement("tests");
                suite.appendChild((Node)tests);
                int testsPassed = 0;
                int actionsExecuted = 0;
                int suiteDuration = 0;
                suite.setAttribute("testsCount", String.valueOf(info.tests.length));
                for (String className : info.tests) {
                    File xmlDataFile = suitePath.resolve(className + "_xml").resolve(XmlReport.REPORT_FILE).toFile();
                    if (!xmlDataFile.exists()) continue;
                    ++totalTests;
                    int testDuration = 0;
                    Element atsTest = builder.parse(xmlDataFile).getDocumentElement();
                    NodeList summary = atsTest.getElementsByTagName("summary");
                    if (summary.getLength() > 0) {
                        if ("1".equals(summary.item(0).getAttributes().getNamedItem("status").getNodeValue())) {
                            ++testsPassed;
                            ++totalTestsPassed;
                        } else {
                            suitePassed = false;
                        }
                    }
                    NodeList actionsList = atsTest.getElementsByTagName("action");
                    actionsExecuted += actionsList.getLength();
                    block10: for (int i = 0; i < actionsList.getLength(); ++i) {
                        Node action = actionsList.item(i);
                        for (int j = 0; j < action.getChildNodes().getLength(); ++j) {
                            Node actionNode = action.getChildNodes().item(j);
                            if (!"duration".equals(actionNode.getNodeName())) continue;
                            testDuration += Utils.string2Int(actionNode.getTextContent());
                            continue block10;
                        }
                    }
                    atsTest.setAttribute("duration", String.valueOf(testDuration));
                    suiteDuration += testDuration;
                    tests.appendChild(writeXmlDocument.importNode(atsTest, true));
                }
                totalActions += actionsExecuted;
                totalDuration += suiteDuration;
                if (suitePassed) {
                    ++totalSuitesPassed;
                }
                suite.setAttribute("passed", String.valueOf(suitePassed));
                suite.setAttribute("duration", String.valueOf(suiteDuration));
                suite.setAttribute("actions", String.valueOf(actionsExecuted));
                suite.setAttribute("testsPassed", String.valueOf(testsPassed));
                report.appendChild(suite);
            }
            report.setAttribute("duration", String.valueOf(totalDuration));
            report.setAttribute("tests", String.valueOf(totalTests));
            report.setAttribute("testsPassed", String.valueOf(totalTestsPassed));
            report.setAttribute("suitesPassed", String.valueOf(totalSuitesPassed));
            report.setAttribute("actions", String.valueOf(totalActions));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(writeXmlDocument), new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFolderPath.resolve(XML_SOURCE_NAME).toFile()), StandardCharsets.UTF_8)));
            File htmlTemplateFile = CampaignReportGenerator.copyResource("suites_html.xml", outputFolderPath);
            Path atsXmlDataPath = outputFolderPath.resolve(XML_SOURCE_NAME);
            MinifyWriter filteredWriter = new MinifyWriter(Files.newBufferedWriter(outputFolderPath.resolve("ats-report.html"), StandardCharsets.UTF_8, new OpenOption[0]));
            Transformer htmlTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(htmlTemplateFile));
            htmlTransformer.setOutputProperty("encoding", "UTF-8");
            htmlTransformer.transform(new DOMSource(builder.parse(new InputSource(new InputStreamReader(Files.newInputStream(atsXmlDataPath, new OpenOption[0]), StandardCharsets.UTF_8)))), new StreamResult(filteredWriter));
            filteredWriter.close();
            if (jasper != null && (jasperFolder = new File(jasper)).exists()) {
                String jasperFolderPath = jasperFolder.getAbsolutePath();
                System.out.println("[ATS-SCRIPT] Jasper folder -> " + jasperFolderPath);
                CampaignReportGenerator.copyResource("summary.jrxml", outputFolderPath);
                CampaignReportGenerator.copyResource("suite.jrxml", outputFolderPath);
                CampaignReportGenerator.copyResource("test.jrxml", outputFolderPath);
                String outputPath = outputFolderPath.toAbsolutePath().toString();
                String reportName = "summary";
                File[] filesToDelete = outputFolderPath.toFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jrprint") || name.endsWith(".jasper") || name.equals("summary.pdf");
                    }
                });
                System.out.println("Delete files.");
                for (File f : filesToDelete) {
                    try {
                        f.delete();
                        System.out.println("File : " + f.getAbsolutePath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                writeXmlDocument = builder.newDocument();
                Element project = writeXmlDocument.createElement("project");
                project.setAttribute("default", "run");
                project.setAttribute("basedir", outputPath);
                Element path = writeXmlDocument.createElement("path");
                path.setAttribute("id", "classpath");
                Element fileset = writeXmlDocument.createElement("fileset");
                fileset.setAttribute("dir", jasperFolderPath);
                Element include = writeXmlDocument.createElement("include");
                include.setAttribute("name", "**/*.jar");
                fileset.appendChild(include);
                path.appendChild(fileset);
                project.appendChild(path);
                Element taskdef = writeXmlDocument.createElement("taskdef");
                taskdef.setAttribute("name", "jrc");
                taskdef.setAttribute("classname", "net.sf.jasperreports.ant.JRAntCompileTask");
                Element classpath = writeXmlDocument.createElement("classpath");
                classpath.setAttribute("refid", "classpath");
                taskdef.appendChild(classpath);
                project.appendChild(taskdef);
                Element target = writeXmlDocument.createElement("target");
                target.setAttribute("name", "run");
                Element jrc = writeXmlDocument.createElement("jrc");
                jrc.setAttribute("destdir", outputPath);
                jrc.setAttribute("xmlvalidation", "false");
                Element src = writeXmlDocument.createElement("src");
                Element fileset7 = writeXmlDocument.createElement("fileset");
                fileset7.setAttribute("dir", outputPath);
                Element include2 = writeXmlDocument.createElement("include");
                include2.setAttribute("name", "**/*.jrxml");
                fileset7.appendChild(include2);
                src.appendChild(fileset7);
                jrc.appendChild(src);
                Element classpath2 = writeXmlDocument.createElement("classpath");
                classpath2.setAttribute("refid", "classpath");
                jrc.appendChild(classpath2);
                target.appendChild(jrc);
                project.appendChild(target);
                File buildFile = outputFolderPath.resolve("build-report.xml").toFile();
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(new DOMSource(project), new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(buildFile), StandardCharsets.UTF_8)));
                Project p = new Project();
                p.setUserProperty("ant.file", buildFile.getAbsolutePath());
                p.init();
                ProjectHelper helper = ProjectHelper.getProjectHelper();
                p.addReference("ant.projectHelper", (Object)helper);
                helper.parse(p, (Object)buildFile);
                DefaultLogger consoleLogger = new DefaultLogger();
                consoleLogger.setErrorPrintStream(System.err);
                consoleLogger.setOutputPrintStream(System.out);
                consoleLogger.setEmacsMode(false);
                consoleLogger.setMessageOutputLevel(2);
                p.addBuildListener((BuildListener)consoleLogger);
                p.executeTarget(p.getDefaultTarget());
                System.out.println("Generate reports.");
                try {
                    CampaignReportGenerator.generatePdf("summary", outputPath, jasperFolder);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void generatePdf(String reportName, String outputPath, File jasperFolder) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        outputPath = (String)outputPath + File.separator;
        String reportFullName = (String)outputPath + reportName + ".pdf";
        System.out.print("File : " + reportFullName + " ... ");
        int len = jasperFolder.listFiles().length;
        URL[] urls = new URL[len];
        for (int i = 0; i < len; ++i) {
            urls[i] = jasperFolder.listFiles()[i].toURI().toURL();
        }
        URLClassLoader loader = new URLClassLoader(urls);
        Class<?> clazz = loader.loadClass("net.sf.jasperreports.engine.JasperFillManager");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workingDir", outputPath);
        parameters.put("xmlSource", XML_SOURCE_NAME);
        parameters.put("xmlSourceRoot", "ats-report");
        Method method = clazz.getMethod("fillReportToFile", String.class, Map.class);
        Object fileName = method.invoke(null, (String)outputPath + reportName + ".jasper", parameters);
        clazz = loader.loadClass("net.sf.jasperreports.engine.JasperExportManager");
        method = clazz.getMethod("exportReportToPdfFile", String.class, String.class);
        method.invoke(null, fileName.toString(), reportFullName);
        System.out.println("OK");
        System.out.flush();
        loader.close();
    }

    private static File copyResource(String resName, Path dest) throws IOException {
        Path filePath = dest.resolve(resName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            InputStream is = ResourceContent.class.getResourceAsStream(CUSTOM_TEMPLATES_FOLDER + resName);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            File targetFile = dest.resolve(resName).toFile();
            FileOutputStream outStream = new FileOutputStream(targetFile);
            ((OutputStream)outStream).write(buffer);
            ((OutputStream)outStream).close();
        }
        return filePath.toFile();
    }

    private static String getBase64DefaultImages(byte[] b) throws IOException {
        return Base64.getEncoder().encodeToString(b);
    }
}

