/*
 * Decompiled with CFR 0.152.
 */
package com.ats.driver;

import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.script.actions.Action;
import com.ats.script.actions.performance.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.performance.proxy.IAtsProxy;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openqa.selenium.Proxy;

public class AtsSystemProxy
implements IAtsProxy {
    public static final String AUTO = "auto";
    public static final String SYSTEM = "system";
    public static final String DIRECT = "direct";
    public static final String MANUAL = "manual";
    public static final String PAC = "pac";
    private String type;
    private String host;
    private int port;
    private String pacUrl;

    public AtsSystemProxy() {
    }

    public AtsSystemProxy(String type) {
        this.type = type;
    }

    public AtsSystemProxy(String host, int port) {
        this(MANUAL, host, port);
    }

    public AtsSystemProxy(String type, String host, int port) {
        this.type = type;
        this.host = host;
        this.port = port;
    }

    public AtsSystemProxy(String type, String url) {
        this.type = type;
        this.pacUrl = url;
    }

    public String getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isEnabled() {
        return this.type != null;
    }

    @Override
    public boolean isAutoDetect() {
        return AUTO.equals(this.type);
    }

    @Override
    public Proxy getValue() {
        Proxy proxy = new Proxy();
        if (AUTO.equals(this.type)) {
            proxy.setProxyType(Proxy.ProxyType.AUTODETECT);
        } else if (PAC.equals(this.type)) {
            proxy.setProxyAutoconfigUrl(this.pacUrl);
        } else if (DIRECT.equals(this.type)) {
            proxy.setProxyType(Proxy.ProxyType.DIRECT);
        } else if (MANUAL.equals(this.type)) {
            String proxyAddress = this.host + ":" + this.port;
            proxy.setHttpProxy(proxyAddress).setSslProxy(proxyAddress);
        } else {
            proxy.setProxyType(Proxy.ProxyType.SYSTEM);
        }
        return proxy;
    }

    public java.net.Proxy getHttpProxy() {
        if (MANUAL.equals(this.type)) {
            return new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
        }
        return java.net.Proxy.NO_PROXY;
    }

    public URI getPacUri() {
        if (PAC.equals(this.type)) {
            try {
                return new URI(this.pacUrl);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void terminate(String channelName) {
    }

    @Override
    public void startAction(Action action, String testLine, String uid) {
    }

    @Override
    public void endAction() {
    }

    @Override
    public void startRecord(ActionStatus status, List<String> whiteList, int trafficIddle, int latency, long sendBandWidth, long receiveBandWidth) {
    }

    @Override
    public void resumeRecord() {
    }

    @Override
    public void pauseRecord() {
    }

    @Override
    public void sendToOctoperfServer(Channel channel, ActionOctoperfVirtualUser action) {
    }
}

