/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element.test;

import com.ats.AtsSingleton;
import com.ats.data.Rectangle;
import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.element.ParameterElement;
import com.ats.element.SearchedElement;
import com.ats.element.test.AtsProperty;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.recorder.IVisualRecorder;
import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class TestElement {
    public static final String CLIENT_WIDTH = "clientWidth";
    public static final String CLIENT_HEIGTH = "clientHeight";
    public static final AtsProperty ATS_OCCURRENCES = new AtsProperty("-ats-occurrences", "-ats-occurences");
    public static final AtsProperty ATS_OCCURRENCES_INDEX = new AtsProperty("-ats-occurrences-index", "-ats-occurences-index");
    public static final AtsProperty ATS_ID = new AtsProperty("-ats-id");
    public static final String ATS_TABLE_DATA = "-ats-table-data";
    public static final String ATS_MAX_TRY = "-ats-max-try";
    public static final String ATS_SEARCH_DURATION = "-ats-search-duration";
    public static final String ATS_SEARCH_TAG = "-ats-search-tag";
    public static final String ATS_SELECTED_TEXT = "-ats-selected-text";
    public static final String ATS_COL_NAME = "-ats-col-name";
    private static final String MAT_SELECT = "MAT-SELECT";
    private static final String PRE = "PRE";
    private static final String DATE = "date";
    private static final String DATE_TIME = "datetime-local";
    private static final String TIME = "time";
    private static final String MUI_INPUT = "MuiInputBase";
    public static final String SYSCOMP = "SYSCOMP";
    public static final String ELEMENT_NOT_FOUND = "ELEMENT_NOT_FOUND";
    private static final String NOT_AVAILABLE = "NOT_AVAILABLE";
    protected Channel channel;
    protected ActionTestScript script;
    protected IDriverEngine engine;
    private Predicate<Integer> occurrences;
    private int count = 0;
    private long searchDuration = 0L;
    private long totalSearchDuration = 0L;
    protected TestElement parent;
    private List<FoundElement> foundElements = new ArrayList<FoundElement>();
    private int maxTry = 20;
    private int maxTryInteractable = AtsSingleton.getInstance().getMaxTryInteractable();
    private int index = 0;
    private boolean shadowRoot = false;
    private int evalIndex = 0;
    private SearchedElement searchedElement;
    protected IVisualRecorder recorder;
    private boolean sysComp = false;

    public TestElement() {
    }

    public TestElement(ActionTestScript script, Channel channel) {
        this(script, channel, 1, 0);
        this.foundElements = new ArrayList<FoundElement>(Arrays.asList(new FoundElement(channel)));
    }

    public TestElement(ActionTestScript script, Channel channel, int count, int index) {
        this.channel = channel;
        this.script = script;
        this.count = count;
        this.index = index;
        this.occurrences = p -> true;
        this.engine = channel.getDriverEngine();
    }

    public TestElement(ActionTestScript script, Channel channel, Predicate<Integer> predicate, int index) {
        this.channel = channel;
        this.script = script;
        this.count = 1;
        this.index = index;
        this.occurrences = predicate;
        this.engine = channel.getDriverEngine();
    }

    public TestElement(ActionTestScript script, Channel channel, int maxTry) {
        this.channel = channel;
        this.script = script;
        this.maxTry = maxTry;
    }

    public TestElement(ActionTestScript script, FoundElement element, Channel currentChannel) {
        this(script, currentChannel);
        this.foundElements.add(element);
        this.count = this.getElementsCount();
    }

    public TestElement(ActionTestScript script, Channel channel, int maxTry, Predicate<Integer> occurrences) {
        this(script, channel, maxTry);
        this.occurrences = occurrences;
    }

    public TestElement(ActionTestScript script, Channel channel, int maxTry, Predicate<Integer> predicate, int index, boolean shadowRoot) {
        this(script, channel, maxTry, predicate);
        this.setIndex(index);
        this.setShadowRoot(shadowRoot);
    }

    public TestElement(ActionTestScript script, Channel channel, int maxTry, Predicate<Integer> predicate, int index) {
        this(script, channel, maxTry, predicate);
        this.setIndex(index);
    }

    public TestElement(ActionTestScript script, Channel channel, SearchedElement searchedElement) {
        this(script, channel, 1, (Integer p) -> true, searchedElement);
    }

    public TestElement(ActionTestScript script, Channel channel, int maxTry, Predicate<Integer> predicate, SearchedElement searchedElement) {
        this(script, channel, maxTry, predicate, searchedElement.getIndex().getCalculatedInteger(), searchedElement.isShadowRoot());
        if (searchedElement.getParent() != null) {
            this.parent = new TestElement(script, channel, maxTry, predicate, searchedElement.getParent());
        }
        this.setEngine(channel.getDriverEngine());
        this.startSearch(searchedElement.isSysComp(), searchedElement);
    }

    public String getNotFoundDescription() {
        StringBuilder builder = new StringBuilder(ELEMENT_NOT_FOUND).append(" ");
        builder.append(this.searchedElement.getSelector());
        return builder.toString();
    }

    protected void setEngine(IDriverEngine engine) {
        this.engine = engine;
    }

    protected void reloadFoundElements() {
        this.foundElements = new ArrayList<FoundElement>(Arrays.asList(new FoundElement(this.channel)));
    }

    public void dispose() {
        this.channel = null;
        this.engine = null;
        this.recorder = null;
        this.occurrences = null;
        if (this.parent != null) {
            this.parent.dispose();
            this.parent = null;
        }
        this.foundElements.forEach(fe -> fe.dispose());
        this.foundElements = new ArrayList<FoundElement>();
    }

    public boolean isAngularSelect() {
        return MAT_SELECT.equalsIgnoreCase(this.getSearchedTag());
    }

    public boolean isPreElement() {
        return PRE.equalsIgnoreCase(this.getSearchedTag());
    }

    public boolean isInputDate() {
        String type = this.getWebElement().getDomAttribute("type");
        return this.isInput() && DATE.equalsIgnoreCase(type);
    }

    public boolean isInputDateTime() {
        String type = this.getWebElement().getDomAttribute("type");
        return this.isInput() && DATE_TIME.equalsIgnoreCase(type);
    }

    public boolean isInputTime() {
        String type = this.getWebElement().getDomAttribute("type");
        return this.isInput() && TIME.equalsIgnoreCase(type);
    }

    public boolean isMuiDateTimeInput() {
        String attr = this.getWebElement().getDomAttribute("class");
        if (attr != null && attr.startsWith(MUI_INPUT) && (attr = this.getWebElement().getDomProperty("placeholder")) != null) {
            if (attr.contains("/") && (attr.contains("DD") || attr.contains("MM") || attr.contains("YY"))) {
                return true;
            }
            if (attr.contains("hh:mm")) {
                return true;
            }
        }
        return false;
    }

    public boolean hasKeyPressEvent() {
        String attr = this.getWebElement().getDomAttribute("onkeypress");
        return attr != null && attr.length() > 0 && !attr.startsWith("jsNumericValidator");
    }

    public boolean isSysComp() {
        return this.sysComp;
    }

    protected int getMaxTry() {
        return this.maxTry;
    }

    protected Channel getChannel() {
        return this.channel;
    }

    public String getSearchedTag() {
        if (this.searchedElement != null) {
            return this.searchedElement.getTag();
        }
        return "";
    }

    protected void startSearch(boolean sys, SearchedElement elem) {
        this.sysComp = sys;
        if (this.channel != null) {
            this.searchedElement = elem;
            this.searchDuration = System.currentTimeMillis();
            if (this.parent == null || this.parent != null && this.parent.getCount() > 0) {
                this.foundElements = this.loadElements(this.searchedElement);
            }
            this.searchDuration = System.currentTimeMillis() - this.searchDuration;
            this.totalSearchDuration = this.getTotalDuration();
            this.count = this.getElementsCount();
        }
    }

    protected List<FoundElement> loadElements(SearchedElement searchedElement) {
        if (searchedElement.isParamElement()) {
            ParameterElement pe = null;
            pe = this.script.getParameterElement() != null ? this.script.getParameterElement() : searchedElement.getParameterElement();
            if (pe == null) {
                pe = new ParameterElement();
            }
            return Arrays.asList(this.engine.getParamElement(pe));
        }
        try {
            if (searchedElement.getXpath() != null) {
                try {
                    return this.engine.findElementByXpath(searchedElement.getXpath());
                }
                catch (NoSuchElementException e) {
                    return Collections.emptyList();
                }
            }
            Predicate<AtsBaseElement> predicate = searchedElement.getPredicate();
            List<FoundElement> elementsLst = this.engine.findElements(this.sysComp, this, this.getSearchedTag(), searchedElement.getAttributes(), searchedElement.getAttributesValues(), predicate, (WebElement)searchedElement.getStartElement(this.engine));
            if (elementsLst.size() == 1 && searchedElement.getAttributes().length == 0 && this.index > 0) {
                this.index = 0;
            }
            return elementsLst;
        }
        catch (StaleElementReferenceException e) {
            return Collections.emptyList();
        }
    }

    public int getElementsCount() {
        int size = this.foundElements.size();
        if (size > 0) {
            if (this.index >= 0) {
                int i = this.index;
                if (i > 0) {
                    --i;
                }
                if (size > i) {
                    return size;
                }
            } else {
                if (this.index < 0 && size == 1) {
                    return size;
                }
                if (size > -this.index - 1) {
                    return size;
                }
            }
        }
        return 0;
    }

    private long getTotalDuration() {
        if (this.parent != null) {
            return this.searchDuration + this.parent.getTotalDuration();
        }
        return this.searchDuration;
    }

    public FoundElement getFoundElement() {
        FoundElement result = null;
        int size = this.getElementsCount();
        if (size > 0) {
            int i = 0;
            if (this.index >= 0) {
                if (this.index > 0) {
                    i = this.index - 1;
                }
            } else {
                i = size - 1;
                if (this.index != -1 && (i += this.index + 1) < 0) {
                    i = 0;
                }
            }
            try {
                result = this.foundElements.get(i);
                this.evalIndex = i;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getEvalIndex() {
        return this.evalIndex;
    }

    public boolean isPassword() {
        return this.getFoundElement().isPassword();
    }

    public boolean isNumeric() {
        return this.getFoundElement().isNumeric();
    }

    public WebElement getWebElement() {
        return this.getFoundElement().getValue();
    }

    public boolean isBody() {
        return this.getFoundElement().isBody();
    }

    public boolean isInput() {
        return this.getFoundElement().isInput();
    }

    public String getWebElementId() {
        return this.getFoundElement().getId();
    }

    public Rectangle getWebElementRectangle() {
        return this.getFoundElement().getRectangle();
    }

    public boolean isValidated() {
        int count = this.getElementsCount();
        return this.occurrences.test(count);
    }

    public boolean isIframe() {
        if (this.getElementsCount() > 0) {
            return this.getFoundElement().isIframe();
        }
        return false;
    }

    public boolean isShadowRoot() {
        return this.shadowRoot;
    }

    public void setShadowRoot(boolean value) {
        this.shadowRoot = value;
    }

    public TestElement getParent() {
        return this.parent;
    }

    public void setParent(TestElement parent) {
        this.parent = parent;
    }

    public long getSearchDuration() {
        return this.searchDuration;
    }

    public void setSearchDuration(long searchDuration) {
        this.searchDuration = searchDuration;
    }

    public long getTotalSearchDuration() {
        return this.totalSearchDuration;
    }

    public void setTotalSearchDuration(long totalSearchDuration) {
        this.totalSearchDuration = totalSearchDuration;
    }

    public List<FoundElement> getFoundElements() {
        return this.foundElements;
    }

    public void setFoundElements(ArrayList<FoundElement> data) {
        this.foundElements = data;
    }

    public String getSelector() {
        if (this.searchedElement == null) {
            return "root[]";
        }
        return this.searchedElement.getSelector();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int value) {
        this.index = value;
    }

    public void checkOccurrences(ActionTestScript ts, ActionStatus status, String operator, int expected) {
        int error = 0;
        if (this.isValidated()) {
            status.setNoError();
        } else {
            error = -8;
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(expected).append("] expected occurrence(s) but [").append(this.count).append("] occurrence(s) found using selector : ").append(this.searchedElement.getSelector());
            status.setError(-8, sb.toString(), this.count);
        }
        status.endDuration();
        ts.getRecorder().updateScreen(status);
        this.terminateExecution(status, ts, error, status.getDuration(), String.valueOf(this.count), operator + " " + expected);
    }

    public void clearText(ActionStatus status, MouseDirection md) {
        this.engine.clearText(status, this, md);
    }

    public String enterText(ActionStatus status, CalculatedValue text, ActionTestScript script, int waitChar) {
        MouseDirection md = new MouseDirection();
        this.over(status, md, false, 0, 0);
        return this.finalizeEnterText(status, text, md, script, waitChar);
    }

    protected String finalizeEnterText(ActionStatus status, CalculatedValue text, MouseDirection md, ActionTestScript script, int waitChar) {
        if (status.isPassed()) {
            if (!text.getCalculated().startsWith("$key")) {
                this.clearText(status, md);
            }
            String enteredText = this.sendText(script, status, text, waitChar);
            if (this.isPassword() || text.isCrypted()) {
                return "########";
            }
            return enteredText;
        }
        return "";
    }

    public String sendText(ActionTestScript script, ActionStatus status, CalculatedValue text, int waitChar) {
        this.waitTextInteractable(this.maxTry, status, text.getCalculatedText(script, waitChar > 0), waitChar, script.getTopScript());
        this.channel.actionTerminated(status);
        return text.getCalculated();
    }

    private void waitAnimation(int loop) {
        Rectangle rect;
        if (loop > 0 && (rect = this.engine.getBoundRect(this)) != null) {
            this.channel.sleep(200);
            if (rect.equals(this.engine.getBoundRect(this))) {
                if (rect.getWidth() > 0.0 && rect.getHeight() > 0.0) {
                    this.getFoundElement().updateBounding(rect.getX(), rect.getY(), this.channel, rect.getWidth(), rect.getHeight());
                } else {
                    this.channel.sendWarningLog(50, "Element size is 0, wait before execute action", --loop);
                    this.waitAnimation(loop);
                }
            } else {
                this.channel.sendWarningLog(50, "Element is moving, wait before execute action", --loop);
                this.waitAnimation(loop);
            }
        }
    }

    private void waitTextInteractable(int loop, ActionStatus status, ArrayList<SendKeyData> text, int waitChar, ActionTestScript topScript) {
        long start = System.currentTimeMillis();
        String errorMessage = "";
        while (loop > 0) {
            try {
                this.engine.sendTextData(status, this, text, waitChar, topScript);
                return;
            }
            catch (ElementNotInteractableException e) {
                errorMessage = e.getMessage();
                this.channel.sendLog(50, "Element is not interactable, wait before try action again", --loop);
                this.channel.sleep(300);
            }
        }
        if (!Strings.isNullOrEmpty((String)errorMessage)) {
            errorMessage = errorMessage.split("\n")[0];
        }
        this.channel.sleep(200);
        status.setError(-3, errorMessage, start);
    }

    private void waitInteractable(int loop, ActionStatus status) {
        if (this.getFoundElement().getId() != null) {
            long start = System.currentTimeMillis();
            String errorMessage = "";
            while (loop > 0) {
                try {
                    this.engine.mouseMoveToElement(this.getFoundElement());
                    return;
                }
                catch (ElementNotInteractableException e) {
                    errorMessage = e.getMessage();
                    this.channel.sendLog(50, "Element is not interactable, wait before try action again", --loop);
                    this.channel.sleep(300);
                }
            }
            if (!Strings.isNullOrEmpty((String)errorMessage)) {
                errorMessage = errorMessage.split("\n")[0];
            }
            this.channel.sleep(200);
            status.setError(-3, errorMessage, start);
        }
    }

    private void waitSelectInteractable(int loop, ActionStatus status, CalculatedProperty selectProperty, boolean keepSelect) {
        long start = System.currentTimeMillis();
        String errorMessage = null;
        while (loop > 0) {
            try {
                this.engine.selectOptionsItem(status, this, selectProperty, keepSelect);
                return;
            }
            catch (ElementNotInteractableException e) {
                errorMessage = e.getMessage();
                this.channel.sendLog(50, "Element is not interactable, wait before try action again", --loop);
                this.channel.sleep(300);
            }
        }
        this.channel.sleep(200);
        status.setError(-3, errorMessage, start);
    }

    public void select(ActionStatus status, CalculatedProperty selectProperty, boolean keepSelect) {
        if (this.isValidated()) {
            this.waitSelectInteractable(this.maxTry, status, selectProperty, keepSelect);
        }
    }

    public void engineOver(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        this.engine.mouseMoveToElement(status, this.getFoundElement(), position, desktopDragDrop, offsetX, offsetY);
    }

    public void over(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        this.waitAnimation(this.maxTryInteractable);
        this.waitInteractable(this.maxTry, status);
        Rectangle rect = this.getFoundElement().getRectangle();
        this.channel.updateVisualAction(false);
        if (status.isPassed()) {
            this.engineOver(status, position, desktopDragDrop, offsetX, offsetY);
            Rectangle rect1 = this.engine.getBoundRect(this);
            if (rect1 != null && !rect1.equals(rect)) {
                this.getChannel().getSystemDriver().updateVisualElement(this);
            }
        } else {
            this.getChannel().getSystemDriver().updateVisualElement(this);
        }
    }

    public void click(ActionStatus status, MouseDirection position, Keys key) {
        this.engine.keyDown(key);
        this.click(status, position);
        this.engine.keyUp(key);
    }

    public void click(ActionStatus status, MouseDirection position) {
        this.mouseClick(status, position, 0, 0);
        for (int tryLoop = this.maxTry; tryLoop > 0 && !status.isPassed(); --tryLoop) {
            this.channel.progressiveWait(tryLoop);
            this.mouseClick(status, position, 0, 0);
        }
    }

    protected void mouseClick(ActionStatus status, MouseDirection position, int offsetX, int offsetY) {
        this.engine.mouseClick(status, this.getFoundElement(), position, offsetX, offsetY);
        this.channel.actionTerminated(status);
    }

    public void drag(ActionStatus status, MouseDirection md, int offsetX, int offsetY, boolean offset) {
        this.engine.drag(status, this.getFoundElement(), md, offsetX, offsetY, offset);
        this.channel.actionTerminated(status);
    }

    public void drop(ActionStatus status, MouseDirection md, boolean desktopDragDrop) {
        this.engine.drop(this.getFoundElement(), md, desktopDragDrop);
        status.setPassed(true);
    }

    public void swipe(ActionStatus status, MouseDirection position, MouseDirection direction) {
        this.engine.swipe(status, this.getFoundElement(), position, direction);
    }

    public void swipe(int direction) {
        this.drag(null, new MouseDirection(), 0, 0, false);
        this.engine.moveByOffset(0, direction);
    }

    public void mouseWheel(int delta) {
        this.engine.scroll(this.getFoundElement(), delta);
        this.channel.progressiveWait(1);
    }

    public void wheelClick(ActionStatus status, MouseDirection position) {
        this.engine.middleClick(status, position, this);
    }

    public void doubleClick() {
        this.engine.doubleClick();
    }

    public void rightClick() {
        this.engine.rightClick();
    }

    public void tap(int count) {
        this.engine.tap(count, this.getFoundElement());
    }

    public void press(int duration, ArrayList<String> paths) {
        this.engine.press(duration, paths, this.getFoundElement());
    }

    protected CalculatedProperty getAtsProperty(String name) {
        return new CalculatedProperty(name, new CalculatedValue(this.getAtsAttribute(name)));
    }

    protected String getAtsAttribute(String name) {
        if (ATS_OCCURRENCES.equals(name)) {
            return String.valueOf(this.count);
        }
        if (ATS_OCCURRENCES_INDEX.equals(name)) {
            return String.valueOf(this.index);
        }
        if (ATS_ID.equals(name)) {
            return NOT_AVAILABLE;
        }
        if (ATS_TABLE_DATA.equals(name)) {
            return this.getTableData();
        }
        if (ATS_SELECTED_TEXT.equals(name)) {
            return this.getSelectedText();
        }
        if (ATS_MAX_TRY.equals(name)) {
            return String.valueOf(this.maxTry);
        }
        if (ATS_SEARCH_DURATION.equals(name)) {
            return String.valueOf(this.totalSearchDuration);
        }
        if (ATS_SEARCH_TAG.equals(name)) {
            return this.getSearchedTag();
        }
        if (ATS_COL_NAME.equals(name)) {
            FoundElement fe = this.getFoundElement();
            if (fe != null && "TD".equalsIgnoreCase(fe.getTag())) {
                return this.engine.getColName(this.getFoundElement().getValue());
            }
            return NOT_AVAILABLE;
        }
        return null;
    }

    protected String getAtsAttributeNotFound(String name) {
        if (ATS_OCCURRENCES.equals(name)) {
            return "0";
        }
        if (ATS_OCCURRENCES_INDEX.equals(name)) {
            return "-1";
        }
        if (ATS_ID.equals(name)) {
            return NOT_AVAILABLE;
        }
        if (ATS_TABLE_DATA.equals(name)) {
            return "";
        }
        if (ATS_SELECTED_TEXT.equals(name)) {
            return "";
        }
        if (ATS_MAX_TRY.equals(name)) {
            return String.valueOf(this.maxTry);
        }
        if (ATS_SEARCH_DURATION.equals(name)) {
            return String.valueOf(this.totalSearchDuration);
        }
        if (ATS_SEARCH_TAG.equals(name)) {
            return this.getSearchedTag();
        }
        return "";
    }

    protected String getTableData() {
        JsonArray dataArray = new JsonArray();
        this.getTextData().parallelStream().forEach(l -> this.addJsonData(dataArray, l.getList()));
        return dataArray.toString();
    }

    protected String getSelectedText() {
        if ("SELECT".equalsIgnoreCase(this.getFoundElement().getTag())) {
            return this.engine.getSelectedText(this);
        }
        return "";
    }

    private void addJsonData(JsonArray array, List<Parameter> pl) {
        JsonObject jso = new JsonObject();
        pl.forEach(p -> jso.addProperty(p.getName(), p.getCalculated()));
        array.add((JsonElement)jso);
    }

    public String getAttribute(ActionStatus status, String name) {
        FoundElement element = this.getFoundElement();
        if (element == null) {
            return this.getAtsAttributeNotFound(name);
        }
        String attr = this.getAtsAttribute(name);
        if (attr != null) {
            return attr;
        }
        if (this.isValidated()) {
            return this.engine.getAttribute(status, element, name, this.maxTry);
        }
        return null;
    }

    private CalculatedProperty[] getAllProperties(CalculatedProperty[] props) {
        int count = 9;
        CalculatedProperty[] result = new CalculatedProperty[props.length + count];
        result[0] = this.getAtsProperty(ATS_OCCURRENCES.toString());
        result[1] = this.getAtsProperty(ATS_OCCURRENCES_INDEX.toString());
        result[2] = this.getAtsProperty(ATS_ID.toString());
        result[3] = this.getAtsProperty(ATS_TABLE_DATA);
        result[4] = this.getAtsProperty(ATS_MAX_TRY);
        result[5] = this.getAtsProperty(ATS_SEARCH_DURATION);
        result[6] = this.getAtsProperty(ATS_SEARCH_TAG);
        result[7] = this.getAtsProperty(ATS_SELECTED_TEXT);
        result[8] = this.getAtsProperty(ATS_COL_NAME);
        CalculatedProperty[] calculatedPropertyArray = props;
        int n = calculatedPropertyArray.length;
        for (int i = 0; i < n; ++i) {
            CalculatedProperty prop;
            result[count] = prop = calculatedPropertyArray[i];
            ++count;
        }
        return result;
    }

    public CalculatedProperty[] getCssAttributes() {
        return this.engine.getCssAttributes(this.getFoundElement());
    }

    public CalculatedProperty[] getHtmlAttributes() {
        return this.getAllProperties(this.engine.getHtmlAttributes(this.getFoundElement()));
    }

    public CalculatedProperty[] getAttributes(boolean reload) {
        return this.getAllProperties(this.engine.getAttributes(this.getFoundElement(), reload));
    }

    public CalculatedProperty[] getFunctions() {
        return this.engine.getFunctions(this.getFoundElement());
    }

    public List<ParameterList> getTextData(Boolean reload) {
        return this.getTextData();
    }

    public List<ParameterList> getTextData() {
        ArrayList<ParameterList> result = new ArrayList<ParameterList>();
        if (this.getFoundElements().size() > 1) {
            if (this.index == 0) {
                this.getFoundElements().forEach(e -> this.addTextParameters(result, (FoundElement)e, this.engine.getTextData((FoundElement)e)));
            } else if (this.index > 0 && this.getFoundElements().size() >= this.index) {
                FoundElement elem = this.getFoundElements().get(this.index - 1);
                this.addTextParameters(result, elem, this.engine.getTextData(elem));
            }
        } else if ("SELECT".equalsIgnoreCase(this.getFoundElement().getTag())) {
            List<String[]> options = this.engine.loadSelectOptions(this);
            if (options.size() > 0) {
                for (String[] option : options) {
                    if (option.length > 0) {
                        result.add(new ParameterList(this.getFoundElement(), option));
                        continue;
                    }
                    result.add(new ParameterList(this.getFoundElement(), TestElement.getParameterList(this.engine.getAttributes(this.getFoundElement(), true))));
                }
            } else {
                result.add(new ParameterList(this.getFoundElement(), TestElement.getParameterList(this.engine.getAttributes(this.getFoundElement(), true))));
            }
        } else {
            String data = this.getFoundElement().isSAP() ? this.engine.getTextData(this.getFoundElement()) : this.getFoundElement().getInnerText();
            if (data != null && data.length() > 0) {
                String[] lines = data.split("\n");
                if (lines.length > 0) {
                    for (String l : lines) {
                        String[] cols = l.split("\t");
                        if (cols.length > 0) {
                            result.add(new ParameterList(this.getFoundElement(), cols, TestElement.getParameterList(this.engine.getAttributes(this.getFoundElement(), true))));
                            continue;
                        }
                        result.add(new ParameterList(this.getFoundElement(), TestElement.getParameterList(this.engine.getAttributes(this.getFoundElement(), true))));
                    }
                } else {
                    result.add(new ParameterList(this.getFoundElement(), TestElement.getParameterList(this.engine.getAttributes(this.getFoundElement(), true))));
                }
            } else {
                result.add(new ParameterList(this.getFoundElement(), TestElement.getParameterList(this.engine.getAttributes(this.getFoundElement(), true))));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private static List<Parameter> getParameterList(CalculatedProperty[] properties) {
        if (properties.length > 0) {
            Parameter[] params = new Parameter[properties.length];
            int loop = 0;
            for (CalculatedProperty prop : properties) {
                params[loop] = new Parameter(loop, prop);
                ++loop;
            }
            return Arrays.asList(params);
        }
        return Arrays.asList(new Parameter(0, ""));
    }

    private void addTextParameters(ArrayList<ParameterList> result, FoundElement elem, String data) {
        String[] cols = data.split("\t");
        ParameterList paramList = cols.length > 0 ? new ParameterList(elem, cols, TestElement.getParameterList(this.engine.getAttributes(elem, true))) : new ParameterList(elem, TestElement.getParameterList(this.engine.getAttributes(elem, true)));
        result.add(paramList);
    }

    public Object executeScript(ActionStatus status, String script, boolean returnValue) {
        if (this.isValidated()) {
            return this.engine.executeJavaScript(status, script, this);
        }
        return null;
    }

    public void terminateExecution(ActionStatus status, ActionTestScript script, int error, long duration) {
        this.recorder = script.getRecorder();
        this.recorder.update(error, duration, this);
        this.channel.actionTerminated(status);
        if (this.count == 1 && this.searchedElement != null && this.engine.isAtsLearningEnabled()) {
            script.getTopScript().saveAtsLearning(this, this.engine, this.searchedElement);
        }
    }

    public void terminateExecution(ActionStatus status, ActionTestScript script, int error, long duration, String value, String data) {
        this.recorder = script.getRecorder();
        this.recorder.update(error, duration, value, data, this);
        this.channel.actionTerminated(status);
    }

    public void updateScreen() {
        this.recorder.updateScreen(this);
    }

    public void updateScreen(ActionStatus status, IVisualRecorder rec) {
        rec.updateScreen(status);
    }

    public Double[] getBound() {
        int numElements = this.getElementsCount();
        int i = this.getEvalIndex();
        Double[] elementBound = new Double[]{0.0, 0.0, 0.0, 0.0};
        if (numElements > i) {
            TestBound bound = this.getFoundElements().get(i).getTestBound();
            elementBound[0] = bound.getX();
            elementBound[1] = bound.getY();
            elementBound[2] = bound.getWidth();
            elementBound[3] = bound.getHeight();
            if (this.isSysComp()) {
                Double[] doubleArray = elementBound;
                Double.valueOf(doubleArray[0] + 8.0);
                doubleArray = elementBound;
                Double.valueOf(doubleArray[1] + 8.0);
            }
        }
        return elementBound;
    }
}

