/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers.capabilities;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.tools.performance.proxy.IAtsProxy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.MutableCapabilities;

public class ChromiumOptions
extends MutableCapabilities {
    protected static final String enableAutomationName = "enable-automation";
    private static final String enableLogging = "enable-logging";
    private static final String NO_SANDBOX = "--no-sandbox";
    private static final String DISABLE_GPU = "--disable-gpu";
    private static final String DISABLE_DEV_SHM_USAGE = "--disable-dev-shm-usage";
    private static final ImmutableList<String[]> standardOptions = ImmutableList.of((Object)new String[]{"test-type", "=webdriver"}, (Object)new String[]{"no-default-browser-check", ""}, (Object)new String[]{"no-first-run", ""}, (Object)new String[]{"disable-search-engine-choice-screen", ""}, (Object)new String[]{"no-service-autorun", ""}, (Object)new String[]{"disable-sync", ""}, (Object)new String[]{"allow-file-access-from-files", ""}, (Object)new String[]{"allow-running-insecure-content", ""}, (Object)new String[]{"allow-cross-origin-auth-prompt", ""}, (Object)new String[]{"allow-file-access", ""}, (Object)new String[]{"ignore-certificate-errors", ""});
    private String binary;
    private List<String> args = new ArrayList<String>();
    private Map<String, Object> experimentalOptions = new HashMap<String, Object>();
    private String capabilityName;

    public ChromiumOptions(BrowserArgumentsParser browserArgs, ApplicationProperties props, String capabilityName, String privateName, boolean enableAutomation, SystemDriver systemDriver, IAtsProxy proxy) {
        String X11_ENABLED;
        this.capabilityName = capabilityName;
        if (this.capabilityName.equals("operaOptions")) {
            this.experimentalOptions.put("w3c", true);
            this.capabilityName = "goog:chromeOptions";
            enableAutomation = false;
        }
        HashMap<String, Serializable> prefs = new HashMap<String, Serializable>();
        prefs.put("credentials_enable_service", Boolean.valueOf(false));
        HashMap<String, Boolean> profile = new HashMap<String, Boolean>();
        profile.put("password_manager_enabled", false);
        prefs.put("profile", profile);
        prefs.put("webSocketUrl", Boolean.valueOf(true));
        this.experimentalOptions.put("prefs", prefs);
        this.binary = browserArgs.getBinaryPath();
        HashMap<String, String> optionsData = new HashMap<String, String>();
        UnmodifiableIterator options = browserArgs.getMoreOptions();
        boolean logging = false;
        for (String s : options) {
            if (!enableLogging.equals(s)) continue;
            logging = true;
            break;
        }
        List<String> excludedOptions = null;
        excludedOptions = logging ? Arrays.asList(props.getExcludedOptions()) : Arrays.asList(props.getExcludedOptions(enableLogging));
        for (String s : options) {
            this.addOption(optionsData, s, excludedOptions);
            if (!enableAutomationName.equals(s)) continue;
            enableAutomation = true;
        }
        for (String[] s : standardOptions) {
            this.addOption(optionsData, s[0], s[1], excludedOptions);
        }
        optionsData.forEach((k, v) -> this.args.add("--" + k + v));
        String docker = System.getenv("DOCKER");
        if ("true".equalsIgnoreCase(docker)) {
            this.args.add(NO_SANDBOX);
            this.args.add(DISABLE_GPU);
            this.args.add(DISABLE_DEV_SHM_USAGE);
        }
        if ("true".equalsIgnoreCase(X11_ENABLED = System.getenv("X11_ENABLED"))) {
            this.args.add("--user-agent=Mozilla/5.0 (X11\\; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36");
        } else if (browserArgs.isHeadless() || !systemDriver.isInteractive()) {
            this.args.add("--headless");
            this.args.add(DISABLE_GPU);
        }
        if (browserArgs.isIncognito()) {
            this.args.add("--" + privateName);
        }
        if (props.getDebugPort() > 0) {
            this.args.add("--remote-debugging-port=" + props.getDebugPort());
        }
        if (browserArgs.getUserDataPath() != null) {
            this.args.add("--user-data-dir=" + browserArgs.getUserDataPath());
        }
        if (browserArgs.getLang() != null) {
            this.args.add("--lang=" + browserArgs.getLang());
        }
        if (enableAutomation) {
            this.args.add("--enable-automation");
        } else {
            excludedOptions = Arrays.asList((String[])ObjectArrays.concat((Object[])props.getExcludedOptions(enableLogging), (Object[])new String[]{enableAutomationName}, String.class));
        }
        this.experimentalOptions.put("excludeSwitches", excludedOptions);
        if (proxy.isEnabled()) {
            this.setCapability("proxy", proxy.getValue());
            if (proxy.isAutoDetect()) {
                this.args.add("--proxy-auto-detect");
            }
        }
    }

    protected void addExperimentalOption(String name, Object value) {
        this.experimentalOptions.put(name, value);
    }

    private void addOption(Map<String, String> optionsData, String optionName, List<String> excludedOptions) {
        this.addOption(optionsData, optionName, "", excludedOptions);
    }

    private void addOption(Map<String, String> optionsData, String optionName, String optionValue, List<String> excludedOptions) {
        if (!excludedOptions.contains(optionName) && !enableLogging.equals(optionName)) {
            optionsData.putIfAbsent(optionName, optionValue);
        }
    }

    public Map<String, Object> asMap() {
        TreeMap toReturn = new TreeMap(super.asMap());
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        this.experimentalOptions.forEach(options::put);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", ImmutableList.copyOf(this.args));
        options.put("extensions", Collections.EMPTY_LIST);
        toReturn.put(this.capabilityName, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

