/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.mobiles;

import com.ats.element.AtsMobileElement;
import com.ats.element.DialogBox;
import com.ats.executor.ActionStatus;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.NoAlertPresentException;

public class MobileAlert
extends DialogBox {
    private static final Map<String, String[]> buttonText = Map.of("accept", new String[]{"accept", "accepter", "ok", "oui", "yes", "true", "vrai", "si", "validar", "aceptar", "valider", "validate"}, "dismiss", new String[]{"dismiss", "cancel", "cancelar", "annuler", "non", "no", "false", "faux", "falso", "deny", "decline", "refuser"});
    private final AtsMobileElement dialog;
    private final MobileDriverEngine engine;

    public MobileAlert(MobileDriverEngine engine) {
        super(engine);
        List<AtsMobileElement> elements = engine.getDialogBox(true);
        if (elements.isEmpty()) {
            elements = engine.getDialogBox(false);
        }
        if (elements.isEmpty()) {
            throw new NoAlertPresentException();
        }
        this.engine = engine;
        this.dialog = elements.get(0);
    }

    @Override
    public void defaultButton(ActionStatus status) {
        this.clickButtonAtIndex(1, status);
    }

    @Override
    public void dismiss(ActionStatus status) {
        List<AtsMobileElement> buttons = this.loadButtons();
        for (AtsMobileElement button : buttons) {
            if (!Arrays.asList(buttonText.get("dismiss")).contains(button.getAttribute("text").toLowerCase())) continue;
            this.executeTapRequest(button);
            break;
        }
    }

    @Override
    public void accept(ActionStatus status) {
        List<AtsMobileElement> buttons = this.loadButtons();
        for (AtsMobileElement button : buttons) {
            if (!Arrays.asList(buttonText.get("accept")).contains(button.getAttribute("text").toLowerCase())) continue;
            this.executeTapRequest(button);
            break;
        }
    }

    private List<AtsMobileElement> loadButtons() {
        ArrayList<AtsMobileElement> list = new ArrayList<AtsMobileElement>();
        this.engine.loadElementsByTag(this.dialog, "Button", list);
        return list;
    }

    private List<AtsMobileElement> loadTextFields() {
        ArrayList<AtsMobileElement> list = new ArrayList<AtsMobileElement>();
        this.engine.loadElementsByTag(this.dialog, "TextField", list);
        return list;
    }

    @Override
    public String getText() {
        return this.dialog.getAttribute("label");
    }

    @Override
    public String getTitle() {
        return this.dialog.getAttribute("label");
    }

    @Override
    public void clickButtonText(String text, ActionStatus status) {
        List<AtsMobileElement> buttons = this.loadButtons();
        for (AtsMobileElement button : buttons) {
            if (!button.getAttribute("text").equalsIgnoreCase(text)) continue;
            this.executeTapRequest(button);
            break;
        }
    }

    @Override
    public void clickButtonId(String id, ActionStatus status) {
        List<AtsMobileElement> buttons = this.loadButtons();
        for (AtsMobileElement button : buttons) {
            if (!button.getAttribute("identifier").equalsIgnoreCase(id)) continue;
            this.executeTapRequest(button);
            break;
        }
    }

    @Override
    public void clickButtonAtIndex(int index, ActionStatus status) {
        List<AtsMobileElement> buttons = this.loadButtons();
        if (index >= 0 && index < buttons.size() + 1) {
            this.executeTapIndexRequest(index);
        } else {
            status.setError(0, "bad index");
        }
    }

    @Override
    public void sendKeys(String txt) {
        this.sendKeys(txt, 1);
    }

    @Override
    public void sendKeys(String txt, int index) {
        List<AtsMobileElement> textFields = this.loadTextFields();
        if (index > 0 && textFields.size() > index - 1) {
            AtsMobileElement element = textFields.get(index - 1);
            this.executeInputRequest(element, txt);
        }
    }

    @Override
    public void sendKeys(String txt, String identifier) {
        List<AtsMobileElement> textFields = this.loadTextFields();
        for (AtsMobileElement element : textFields) {
            if (!element.getAttribute("identifier").equalsIgnoreCase(identifier)) continue;
            this.executeInputRequest(element, txt);
            break;
        }
    }

    private void executeTapRequest(AtsMobileElement element) {
        String coordinates = element.getX() + ";" + element.getY() + ";" + element.getWidth() + ";" + element.getHeight();
        this.engine.executeRequest("alert", element.getId(), "tap", "0", "0", coordinates);
    }

    private void executeTapIndexRequest(int index) {
        this.engine.executeRequest("alert", "default", "tap", Integer.toString(index));
    }

    private void executeInputRequest(AtsMobileElement element, String text) {
        double x = element.getX() + element.getWidth() / 2.0;
        double y = element.getY() + element.getHeight() / 2.0;
        String coordinates = x + ";" + y;
        this.engine.executeRequest("alert", element.getId(), "input", coordinates, text);
    }
}

