/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.webservices;

import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.webservices.ApiExecutor;
import com.ats.executor.drivers.engines.webservices.AtsCookieJar;
import com.ats.executor.drivers.engines.webservices.SoapOperation;
import com.ats.script.actions.ActionApi;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SoapApiExecutor
extends ApiExecutor {
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private String namespace = "";
    private Map<String, SoapOperation> operations;

    public SoapApiExecutor(PrintStream logStream, AtsCookieJar cookieJar, OkHttpClient client, int timeout, int maxTry, Channel channel, String wsdlContent, String wsUrl) throws SAXException, IOException, ParserConfigurationException {
        super(logStream, cookieJar, client, timeout, maxTry, channel);
        File wsdlFile = File.createTempFile("atsWs_", ".txt");
        wsdlFile.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wsdlFile), StandardCharsets.UTF_8));
        writer.write(wsdlContent);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        this.setUri(wsUrl);
        this.operations = new HashMap<String, SoapOperation>();
        String[] wsdlData = SoapApiExecutor.parse(wsdlFile, this.operations);
        this.namespace = wsdlData[0];
        this.setUri(wsdlData[1]);
    }

    public ArrayList<String> getOperations() {
        return new ArrayList<String>(this.operations.keySet());
    }

    @Override
    public void execute(ActionStatus status, ActionApi api) {
        super.execute(status, api);
        if (api.getMethod().getCalculated().startsWith("file:///")) {
            this.loadLocalFile("/xml", api.getMethod().getCalculated());
            return;
        }
        String action = api.getMethod().getCalculated();
        SoapOperation soapAction = this.operations.get(action);
        if (soapAction != null && api.getData() != null && api.getData().size() > 0) {
            String xmlInput = soapAction.getEnvelope(this.namespace, api.getData().get(0).getValue().getCalculated());
            Request.Builder requestBuilder = new Request.Builder().post(RequestBody.Companion.create(xmlInput, null)).url(this.getUri().toString());
            requestBuilder.addHeader("Content-Type", "text/xml; charset=utf-8");
            requestBuilder.addHeader("SOAPAction", soapAction.getHeaderName());
            for (Map.Entry header : this.headerProperties.entrySet()) {
                requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
            }
            this.executeRequest(status, requestBuilder.build());
        } else {
            status.setError(-16, "SOAP operation does not exists ->  " + action);
        }
    }

    public static String[] parse(File wsdlFile, Map<String, SoapOperation> operations) throws SAXException, IOException, ParserConfigurationException {
        Node location;
        NodeList addresses;
        NodeList nodeListOfOperations;
        int nodeLength;
        NodeList nd;
        String namespace = "";
        HashMap<String, String> messages = new HashMap<String, String>();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(wsdlFile);
        if (document.getFirstChild().getNodeName().equalsIgnoreCase("#comment")) {
            document.removeChild(document.getFirstChild());
        }
        NodeList messageList = document.getFirstChild().getChildNodes();
        for (int index = 0; index < messageList.getLength(); ++index) {
            NamedNodeMap attributes;
            Node node = messageList.item(index);
            if (node.getNodeType() != 1 || !"wsdl:message".equals(node.getNodeName()) && !"message".equals(node.getNodeName()) || (attributes = node.getAttributes()).getLength() <= 0) continue;
            String messageName = attributes.item(0).getNodeValue();
            NodeList children = node.getChildNodes();
            for (int k = 0; k < children.getLength(); ++k) {
                String messageElement;
                if (children.item(k).getNodeType() != 1 || (messageElement = children.item(k).getAttributes().getNamedItem("element").getTextContent()) == null || messageElement.length() <= 0) continue;
                int doubleDot = messageElement.indexOf(":");
                if (doubleDot > -1) {
                    messageElement = messageElement.substring(doubleDot + 1);
                }
                messages.put(messageName, messageElement);
            }
        }
        String tagPrefix = "";
        int l = document.getFirstChild().getAttributes().getLength();
        for (int i = 0; i < l; ++i) {
            String cmpAttribute = document.getFirstChild().getAttributes().item(i).getNodeValue();
            if (!cmpAttribute.equals(XML_SCHEMA)) continue;
            tagPrefix = document.getFirstChild().getAttributes().item(i).getNodeName().replace("xmlns:", "");
        }
        Node ns = document.getFirstChild().getAttributes().getNamedItem("targetNamespace");
        if (ns != null) {
            namespace = ns.getNodeValue();
        }
        if ((nd = document.getElementsByTagName(tagPrefix + ":import")).getLength() == 0) {
            nd = document.getElementsByTagName("wsdl:import");
        }
        if (nd.getLength() > 0) {
            for (int k = 0; k < nd.item(0).getAttributes().getLength(); ++k) {
                String strAttributes = nd.item(0).getAttributes().item(k).getNodeName();
                if (namespace != null || !strAttributes.equalsIgnoreCase("namespace")) continue;
                namespace = nd.item(0).getAttributes().item(k).getNodeValue();
            }
        }
        if ((nodeLength = (nodeListOfOperations = document.getElementsByTagName("operation")).getLength()) == 0) {
            nodeListOfOperations = document.getElementsByTagName("wsdl:operation");
        }
        if ((nodeLength = nodeListOfOperations.getLength()) > 0) {
            block6: for (int i = 0; i < nodeLength; ++i) {
                Node operation = nodeListOfOperations.item(i);
                String operationName = operation.getAttributes().getNamedItem("name").getNodeValue();
                SoapOperation op = operations.get(operationName);
                if (op == null) {
                    op = new SoapOperation(operationName);
                    operations.put(operationName, op);
                }
                if (operation.getChildNodes() == null) continue;
                String parentName = operation.getParentNode().getNodeName();
                if (parentName.endsWith("portType")) {
                    NodeList children = operation.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node child = children.item(j);
                        if (child.getNodeType() != 1 || !child.getNodeName().endsWith("input")) continue;
                        String messageElement = child.getAttributes().getNamedItem("message").getNodeValue();
                        int doubleDot = messageElement.indexOf(":");
                        if (doubleDot > -1) {
                            messageElement = messageElement.substring(doubleDot + 1);
                        }
                        op.setMessageName((String)messages.get(messageElement));
                    }
                    continue;
                }
                if (!parentName.endsWith("binding")) continue;
                for (int j = 0; j < operation.getChildNodes().getLength(); ++j) {
                    Node action;
                    NamedNodeMap attributes = operation.getChildNodes().item(j).getAttributes();
                    if (attributes == null || (action = attributes.getNamedItem("soapAction")) == null) continue;
                    if (action.getNodeValue() == null || action.getNodeValue().length() <= 0) continue block6;
                    op.setHeaderName(action.getNodeValue());
                    continue block6;
                }
            }
        }
        String addressLocation = null;
        if (document.getElementsByTagName("soap:address").getLength() > 0 && (addresses = document.getElementsByTagName("soap:address")).getLength() > 0 && (location = addresses.item(0).getAttributes().getNamedItem("location")) != null) {
            try {
                addressLocation = location.getNodeValue();
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return new String[]{namespace, addressLocation};
    }
}

