/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.script.Script;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ConditionalValue {
    public static final String VALUE_EQUALS = "==";
    public static final String VALUE_NOT_EQUALS = "!=";
    private Variable variable;
    private String operator = "==";
    private CalculatedValue value;
    private boolean exec = false;

    public ConditionalValue() {
    }

    public ConditionalValue(Script script, String variableName, String value) {
        this.setVariable(script.getVariable(variableName, false));
        this.setValue(new CalculatedValue(script, value));
    }

    public ConditionalValue(Script script, String variableName, String value, String operator) {
        this(script, variableName, value);
        this.setOperator(operator);
    }

    public ConditionalValue(String op, Variable va, CalculatedValue cv) {
        this.setOperator(op);
        this.setVariable(va);
        this.setValue(cv);
    }

    public JsonObject getLog() {
        return this.getLog(new JsonObject());
    }

    public JsonObject getLog(JsonObject log) {
        JsonObject varData = new JsonObject();
        varData.addProperty(this.variable.getName(), this.variable.getCalculatedValue());
        JsonObject compareData = new JsonObject();
        compareData.addProperty("operator", this.operator);
        compareData.addProperty("value", this.value.getCalculated());
        JsonObject data = new JsonObject();
        data.add("variable", (JsonElement)varData);
        data.add("compare", (JsonElement)compareData);
        data.addProperty("continue", Boolean.valueOf(this.exec));
        log.add("condition", (JsonElement)data);
        return log;
    }

    public StringBuilder getJavaCode(StringBuilder builder, int codeLine) {
        StringBuilder codeBuilder = new StringBuilder("if(").append("opt").append("(").append(this.getClass().getSimpleName()).append(".");
        if (VALUE_NOT_EQUALS.equals(this.operator)) {
            codeBuilder.append("VALUE_NOT_EQUALS");
        } else {
            codeBuilder.append("VALUE_EQUALS");
        }
        codeBuilder.append(", ").append(codeLine).append(", ").append(this.variable.getName()).append(", ").append(this.value.getJavaCode()).append(")) ").append((CharSequence)builder);
        return codeBuilder;
    }

    public boolean isExec() {
        boolean isEquals = this.variable.getCalculatedValue().equals(this.value.getCalculated());
        this.exec = isEquals && VALUE_EQUALS.equals(this.operator) || !isEquals && VALUE_NOT_EQUALS.equals(this.operator);
        return this.exec;
    }

    public void setExec(boolean value) {
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }
}

