/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.executor.java.JavaCodeEval;
import com.ats.generator.variables.transform.Transformer;
import com.ats.generator.variables.transform.code.JavaScriptCodeEval;
import com.ats.generator.variables.transform.code.PythonCodeEval;

public class EvalTransformer
extends Transformer {
    public static final String CODE_ERROR = "#CodeEvalError#";
    private static final String JAVA = "java";
    public static final String JS = "js";
    public static final String PY = "py";
    private static final String JAVASCRIPT = "javascript";
    public static final String PYTHON = "python";
    private String language = "java";

    public EvalTransformer() {
    }

    public EvalTransformer(String language) {
        if (JAVA.equals(language) || JS.equals(language) || PY.equals(language)) {
            this.language = language;
        } else if (JAVASCRIPT.equals(language)) {
            this.language = JS;
        } else if (PYTHON.equals(language)) {
            this.language = PY;
        }
    }

    @Override
    public String getJavaCode() {
        StringBuilder sb = new StringBuilder(", ").append("sc").append("(\"").append(this.language).append("\")");
        return sb.toString();
    }

    @Override
    public String format(String data) {
        if (JAVA.equals(this.language)) {
            JavaCodeEval code = new JavaCodeEval(data);
            try {
                return code.eval();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e.getMessage());
            }
        }
        if (JAVASCRIPT.equals(this.language) || JS.equals(this.language)) {
            return new JavaScriptCodeEval(data).eval();
        }
        if (PYTHON.equals(this.language) || PY.equals(this.language)) {
            return new PythonCodeEval(data).eval();
        }
        return "";
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String value) {
        this.language = value;
    }
}

