/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.generator.variables.transform.Transformer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeTransformer
extends Transformer {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final Pattern PATTERN_HOUR_TRANSFORM = Pattern.compile("(-?\\d+)([hms])");
    private int hour = 0;
    private int minute = 0;
    private int second = 0;

    public TimeTransformer() {
    }

    public TimeTransformer(String ... data) {
        if (data.length > 0) {
            for (String item : data) {
                Matcher dataMatcher = PATTERN_HOUR_TRANSFORM.matcher(item);
                if (!dataMatcher.find()) continue;
                if ("h".equals(dataMatcher.group(2))) {
                    this.setHour(this.getInt(dataMatcher.group(1)));
                    continue;
                }
                if ("m".equals(dataMatcher.group(2))) {
                    this.setMinute(this.getInt(dataMatcher.group(1)));
                    continue;
                }
                if (!"s".equals(dataMatcher.group(2))) continue;
                this.setSecond(this.getInt(dataMatcher.group(1)));
            }
        }
    }

    public static String getNowValue() {
        LocalTime time = LocalTime.now();
        return time.format(TIME_FORMATTER);
    }

    @Override
    public String getJavaCode() {
        StringJoiner joiner = new StringJoiner(", ");
        if (this.hour != 0) {
            joiner.add("\"" + this.hour + "h\"");
        }
        if (this.minute != 0) {
            joiner.add("\"" + this.minute + "m\"");
        }
        if (this.second != 0) {
            joiner.add("\"" + this.second + "s\"");
        }
        StringBuilder sb = new StringBuilder(", ").append("tm");
        sb.append("(").append(joiner.toString()).append(")");
        return sb.toString();
    }

    @Override
    public String format(String data) {
        try {
            LocalTime time = LocalTime.parse(data, TIME_FORMATTER);
            time = time.plusHours(this.hour).plusMinutes(this.minute).plusSeconds(this.second);
            return time.toString();
        }
        catch (DateTimeParseException dateTimeParseException) {
            return "";
        }
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
    }
}

