/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.executor.TestBound;
import com.ats.generator.variables.CalculatedValue;
import com.ats.recorder.IVisualData;
import com.ats.recorder.VisualElement;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionAssertValue;
import com.ats.script.actions.ActionCallscript;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.utils.ReportImageFormat;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VisualAction
implements IVisualData {
    private static final Pattern pattern = Pattern.compile("[\\p{C}]");
    public static final String START_SCRIPT = "StartScriptAction";
    public static final String API_TYPE = "api";
    public static final String VIDEO_TYPE = "video";
    private TestBound channelBound;
    private String channelName;
    private String data = "";
    private int duration;
    private VisualElement element;
    private int error = 0;
    private ArrayList<byte[]> images;
    private String imageType;
    private int imageRef;
    private int index;
    private int line;
    private byte[] record;
    private String script;
    private boolean stop = true;
    private Long timeLine;
    private String uuid;
    private String type;
    private String value = "";

    public VisualAction() {
    }

    public VisualAction(ActionAssertValue action, long timeLine) {
        this.initData(action, timeLine);
        this.setError(0);
    }

    public VisualAction(ActionCallscript action, long timeLine, String calledScript, CalculatedValue param) {
        this.initData(action, timeLine);
        this.setValue(calledScript);
        this.setError(0);
        if (param != null) {
            JsonObject json = new JsonObject();
            json.addProperty("asset", param.getCalculated());
            this.setData(json.toString());
        }
    }

    public VisualAction(Action action, long timeLine) {
        this.initData(action, timeLine);
        this.setError(-23);
    }

    private void initData(Action action, long timeLine) {
        this.images = new ArrayList(Arrays.asList(new byte[][]{Base64.getDecoder().decode(new String("iVBORw0KGgoAAAANSUhEUgAAAJYAAABkCAYAAABkW8nwAAAAxnpUWHRSYXcgcHJvZmlsZSB0eXBlIGV4aWYAAHjabVBbDsMgDPvPKXYE8uCR49CVSbvBjr9A0qndZgnH4NaEwHg9H3CbIBSQXFvRUpJBVJS6iZYcfTEmWbygJTy8nkORMMiO2Cr7tsUPeJzjJ8BLN5VPQe0exnY1NC6g9hVEXnh2NPUeQRpBTG5gBHR/Vira6vkJ20hXNF8wSdA/k+rez77a9PZs9zDRYORkzCzeAM8lwN0EGiMLTZVM8+LMJTqxgfyb0wF4A/k4WSK+t3bkAAABhWlDQ1BJQ0MgcHJvZmlsZQAAeJx9kT1Iw1AUhU9TRdGqgx1EHCJUJ7tUEcdSxSJYKG2FVh1MXvoHTRqSFBdHwbXg4M9i1cHFWVcHV0EQ/AFxdnBSdJES70sKLWK88Hgf591zeO8+QGhUmGp2RQFVs4xUPCZmc6tizyt86McgxhGRmKkn0osZeNbXPXVT3YV5lnffnzWg5E0G+ETiKNMNi3iDeHbT0jnvEwdZSVKIz4mnDLog8SPXZZffOBcdFnhm0Mik5omDxGKxg+UOZiVDJZ4hDimqRvlC1mWF8xZntVJjrXvyFwby2kqa67TGEMcSEkhChIwayqjAQph2jRQTKTqPefhHHX+SXDK5ymDkWEAVKiTHD/4Hv2drFqYjblIgBnS/2PbHBNCzCzTrtv19bNvNE8D/DFxpbX+1Acx9kl5va6EjYGgbuLhua/IecLkDjDzpkiE5kp+WUCgA72f0TTlg+BboW3Pn1jrH6QOQoVkt3wAHh8BkkbLXPd7d2zm3f3ta8/sBzblyy7jWGv0AAA12aVRYdFhNTDpjb20uYWRvYmUueG1wAAAAAAA8P3hwYWNrZXQgYmVnaW49Iu+7vyIgaWQ9Ilc1TTBNcENlaGlIenJlU3pOVGN6a2M5ZCI/Pgo8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJYTVAgQ29yZSA0LjQuMC1FeGl2MiI+CiA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIKICAgIHhtbG5zOnN0RXZ0PSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VFdmVudCMiCiAgICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgICB4bWxuczpHSU1QPSJodHRwOi8vd3d3LmdpbXAub3JnL3htcC8iCiAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIKICAgIHhtbG5zOnhtcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyIKICAgeG1wTU06RG9jdW1lbnRJRD0iZ2ltcDpkb2NpZDpnaW1wOjJhMmU1YmQ4LTAxOWUtNDUzMC05NzU0LTUyNmNiNmQzOTdmNCIKICAgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpjOTkyY2NmNy0xYTk2LTRjZWEtOGJlMi00ZTc1NWI0NzhlNWYiCiAgIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDoyMDJlNzM4OC1lMGU2LTQ2MTMtYjI3NC1lMmY3MzcwNDAyZjQiCiAgIGRjOkZvcm1hdD0iaW1hZ2UvcG5nIgogICBHSU1QOkFQST0iMi4wIgogICBHSU1QOlBsYXRmb3JtPSJXaW5kb3dzIgogICBHSU1QOlRpbWVTdGFtcD0iMTcwNTIyNDY1Njg3MTA1NCIKICAgR0lNUDpWZXJzaW9uPSIyLjEwLjM0IgogICB0aWZmOk9yaWVudGF0aW9uPSIxIgogICB4bXA6Q3JlYXRvclRvb2w9IkdJTVAgMi4xMCIKICAgeG1wOk1ldGFkYXRhRGF0ZT0iMjAyNDowMToxNFQxMDozMDo1NiswMTowMCIKICAgeG1wOk1vZGlmeURhdGU9IjIwMjQ6MDE6MTRUMTA6MzA6NTYrMDE6MDAiPgogICA8eG1wTU06SGlzdG9yeT4KICAgIDxyZGY6U2VxPgogICAgIDxyZGY6bGkKICAgICAgc3RFdnQ6YWN0aW9uPSJzYXZlZCIKICAgICAgc3RFdnQ6Y2hhbmdlZD0iLyIKICAgICAgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDphODQ1OTVhOC00MDkyLTQwZjYtYmFlZC05YzUxYjEzZmE0YTciCiAgICAgIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkdpbXAgMi4xMCAoV2luZG93cykiCiAgICAgIHN0RXZ0OndoZW49IjIwMjQtMDEtMTRUMTA6MzA6NTYiLz4KICAgIDwvcmRmOlNlcT4KICAgPC94bXBNTTpIaXN0b3J5PgogIDwvcmRmOkRlc2NyaXB0aW9uPgogPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgIAo8P3hwYWNrZXQgZW5kPSJ3Ij8+i5F77gAAAAlwSFlzAAAAsgAAALIBa5Ro4AAAAAd0SU1FB+gBDgkeOBju0QIAAAHZSURBVHja7du/axNhHAfg79WrHRSxBVHp4GLrZDfBTXBV8D8QcXERRdBZR3FzD3RzcfPfcBIsOlZtMdb0R1JC0ktyr4MUSyA0PzqZ59nuuHe4D5/3vffgLgIAAAAAAAAAAAAAAAAAAAAAAAAAAPifZdN0s+/e770ad+xMlnUvL+b5+Emn9q2bZ19PS9b5lE2kl+MPTY0s4tz4w7N6RExNsWYs2igWioVigWKhWCgWKBaKhWKBYqFYKBaDpYhSCop14n7XOmvNZvlZEop1ojY3irlqtWhIYji5CI5X3++tFd20VBTlmaKbqqfz7JJUrFgTW19v17O/X9vmWz87XyWiWBMrivJXq1XeODzeb/ZWUkptySjWZKvVt+JLRMz+ez1MC7Va96NkFGtsZZkOdnY71/vPb293L0rH5v2otyOtVt8P5iPifv/5lNLy7k6nsjCfN0eYw61pCjoztwZ78uLHp4hYiYjIT2WNa8tzR//S+fDo4YV7UvIoHMnj5xu3D0s1wN1KZeuqpBRrtGCy9Oy4S3oz8VRSijXKI3ApIu4MsZN4sLq6e15iNu/DzbYUiyniTd+GvZNFmu2/9qAsrkTEntQAAAAAAAAAAAAAAAAAAAAAAAAAAIBp8ge5OnzzSBa+EwAAAABJRU5ErkJggg==").getBytes())}));
        this.type = action.getClass().getName();
        this.line = action.getLine();
        this.timeLine = timeLine;
        this.script = action.getScript().getTestName();
        this.channelBound = new TestBound(0.0, 0.0, 150.0, 100.0);
        this.channelName = "not_started_channel";
    }

    @Override
    public Element getAction(ExecutionLogger logger, String summary, Document document, Path xmlFolderPath, boolean analytics, ReportImageFormat imgFormat, boolean savePic) {
        Element action = document.createElement("action");
        action.setAttribute("type", this.getType());
        action.appendChild(document.createElement("id")).setTextContent(this.getUuid());
        action.appendChild(document.createElement("line")).setTextContent(String.valueOf(this.getLine()));
        action.appendChild(document.createElement("script")).setTextContent(this.getScript().replaceAll("\\-iter\\d*$", ""));
        action.appendChild(document.createElement("timeLine")).setTextContent(String.valueOf(this.getTimeLine()));
        action.appendChild(document.createElement("error")).setTextContent(String.valueOf(this.getError()));
        action.appendChild(document.createElement("stop")).setTextContent(String.valueOf(this.isStop()));
        action.appendChild(document.createElement("duration")).setTextContent(String.valueOf(this.getDuration()));
        action.appendChild(document.createElement("passed")).setTextContent(String.valueOf(this.getError() == 0));
        action.appendChild(document.createElement("value")).setTextContent(this.getValue());
        String data = this.getData();
        try {
            JsonElement jsonElement = JsonParser.parseString((String)data);
            if (jsonElement instanceof JsonNull) {
                action.appendChild(document.createElement("data")).setTextContent(data);
            } else {
                JsonObject jsonData = jsonElement.getAsJsonObject();
                action.appendChild(VisualAction.extractJsonData(document, jsonData));
            }
        }
        catch (Exception e) {
            action.appendChild(document.createElement("data")).setTextContent(data);
        }
        if (savePic) {
            Element img = document.createElement("img");
            img.setAttribute("type", this.getImageType());
            if (!API_TYPE.equals(this.getImageType()) && imgFormat != null) {
                img.setAttribute("width", String.valueOf(this.getChannelBound().getWidth().intValue()));
                img.setAttribute("height", String.valueOf(this.getChannelBound().getHeight().intValue()));
                img.setAttribute("id", "pic_" + String.valueOf(this.index) + "_" + System.currentTimeMillis());
                if (this.record != null && this.record.length > 1) {
                    img.setAttribute("type", VIDEO_TYPE);
                    img.setAttribute("src", Base64.getEncoder().encodeToString(this.record));
                } else {
                    imgFormat.format(img, this.getError() != 0, this.getImageType(), this.images, this.element, this.getImageRef());
                }
            }
            action.appendChild(img);
        }
        Element channel = document.createElement("channel");
        channel.setAttribute("name", this.getChannelName());
        Element channelBound = document.createElement("bound");
        Element channelX = document.createElement("x");
        channelX.setTextContent(String.valueOf(this.getChannelBound().getX().intValue()));
        channelBound.appendChild(channelX);
        Element channelY = document.createElement("y");
        channelY.setTextContent(String.valueOf(this.getChannelBound().getY().intValue()));
        channelBound.appendChild(channelY);
        Element channelWidth = document.createElement("width");
        channelWidth.setTextContent(String.valueOf(this.getChannelBound().getWidth().intValue()));
        channelBound.appendChild(channelWidth);
        Element channelHeight = document.createElement("height");
        channelHeight.setTextContent(String.valueOf(this.getChannelBound().getHeight().intValue()));
        channelBound.appendChild(channelHeight);
        channel.appendChild(channelBound);
        action.appendChild(channel);
        if (this.getElement() != null) {
            Element element = document.createElement("element");
            element.setAttribute("tag", this.getElement().getTag());
            Element criterias = document.createElement("criterias");
            criterias.setTextContent(this.getElement().getCriterias());
            element.appendChild(criterias);
            Element foundElements = document.createElement("foundElements");
            foundElements.setTextContent(String.valueOf(this.getElement().getFoundElements()));
            element.appendChild(foundElements);
            Element searchDuration = document.createElement("searchDuration");
            searchDuration.setTextContent(String.valueOf(this.getElement().getSearchDuration()));
            element.appendChild(searchDuration);
            Element elementBound = document.createElement("bound");
            Element elementX = document.createElement("x");
            elementX.setTextContent(String.valueOf(this.getElement().getRectangle().getX().intValue()));
            elementBound.appendChild(elementX);
            Element elementY = document.createElement("y");
            elementY.setTextContent(String.valueOf(this.getElement().getRectangle().getY().intValue()));
            elementBound.appendChild(elementY);
            Element elementWidth = document.createElement("width");
            elementWidth.setTextContent(String.valueOf(this.getElement().getRectangle().getWidth().intValue()));
            elementBound.appendChild(elementWidth);
            Element elementHeight = document.createElement("height");
            elementHeight.setTextContent(String.valueOf(this.getElement().getRectangle().getHeight().intValue()));
            elementBound.appendChild(elementHeight);
            Element elementHpos = document.createElement("hpos");
            elementHpos.setTextContent(this.getElement().getHpos());
            elementBound.appendChild(elementHpos);
            Element elementVpos = document.createElement("vpos");
            elementVpos.setTextContent(this.getElement().getVpos());
            elementBound.appendChild(elementVpos);
            element.appendChild(elementBound);
            action.appendChild(element);
        }
        return action;
    }

    public String getImageFileName() {
        return this.index + "." + this.imageType;
    }

    public boolean saveRecord(Path folder) {
        if (this.record != null && this.record.length > 1) {
            try {
                FileOutputStream fos = new FileOutputStream(folder.resolve(this.getImageFileName()).toFile());
                fos.write(this.record);
                fos.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private static Element extractJsonData(Document document, JsonObject jsonData) {
        Element data = document.createElement("dataJson");
        for (String key : jsonData.keySet()) {
            Element element;
            if (Utils.isNumeric(key)) {
                element = document.createElement("parameter");
                element.setAttribute("type", "num");
                element.setAttribute("name", key);
            } else {
                element = document.createElement("parameter");
                element.setAttribute("type", key);
            }
            element.setAttribute("value", jsonData.get(key).getAsString());
            data.appendChild(element);
        }
        return data;
    }

    public void setChannelBound(TestBound channelBound) {
        this.channelBound = channelBound;
    }

    public TestBound getChannelBound() {
        return this.channelBound;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setData(String value) {
        if (value != null) {
            this.data = value.replaceFirst("data::", "");
        }
    }

    public String getData() {
        Matcher matcher = pattern.matcher(this.data);
        return matcher.replaceAll("");
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setElement(VisualElement element) {
        this.element = element;
    }

    public VisualElement getElement() {
        return this.element;
    }

    public void setError(int error) {
        this.error = error;
    }

    public int getError() {
        return this.error;
    }

    public void setImages(ArrayList<byte[]> list) {
        this.images = list;
    }

    public ArrayList<byte[]> getImages() {
        return this.images;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageRef(int imageRef) {
        this.imageRef = imageRef;
    }

    public int getImageRef() {
        return this.imageRef;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setRecord(byte[] value) {
        this.record = value;
    }

    public byte[] getRecord() {
        return this.record;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setTimeLine(Long timeLine) {
        this.timeLine = timeLine;
    }

    @Override
    public Long getTimeLine() {
        return this.timeLine;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setUuid(String value) {
        this.uuid = value;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setValue(String value) {
        if (value != null) {
            this.value = value.replaceFirst("value::", "");
        }
    }

    public String getValue() {
        Matcher matcher = pattern.matcher(this.value);
        return matcher.replaceAll("");
    }
}

