/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.ApiData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionCondition;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;

public class ActionApi
extends ActionCondition {
    private static final String SCRIPT_LABEL = "api-";
    public static final Predicate<String> PREDICATE = g -> g.startsWith(SCRIPT_LABEL);
    private static final int SCRIPT_LABEL_LENGTH = "api-".length();
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    public static final String SOAP = "SOAP";
    public static final String REST = "REST";
    public static final String JSON_DATA = "JSON_DATA";
    public static final String XML_DATA = "XML_DATA";
    private CalculatedValue method;
    private boolean useCache = true;
    private List<ApiData> headers;
    private List<ApiData> data;
    private String type = "GET";
    private int port = -1;

    public ActionApi() {
    }

    public ActionApi(Script script, ExecuteOptions options, String type, String method, String headerData, ArrayList<String> data) {
        super(script, options);
        this.setType(type.substring(SCRIPT_LABEL_LENGTH));
        this.setMethod(new CalculatedValue(script, method));
        if (headerData.length() > 0) {
            this.headers = new ArrayList<ApiData>();
            Arrays.stream(headerData.split(",")).forEach(s -> this.addHeader((String)s));
        }
        if (data.size() > 0) {
            this.data = new ArrayList<ApiData>();
            for (int i = 0; i < data.size(); ++i) {
                String dataValue = data.get(i).trim();
                String key = null;
                if (Utils.isXmlLike(Utils.unescapeAts(dataValue))) {
                    key = XML_DATA;
                } else {
                    String jsonString = Utils.checkJsonData(Utils.unescapeAts(dataValue));
                    if (jsonString != null) {
                        key = JSON_DATA;
                        dataValue = jsonString;
                    }
                }
                if (!JSON_DATA.equals(key) && !XML_DATA.equals(key) && dataValue.contains("=")) {
                    String[] arr = dataValue.split("=");
                    key = arr[0].trim();
                    dataValue = Utils.unescapeAts(arr[1].trim());
                }
                this.data.add(new ApiData(key, new CalculatedValue(script, dataValue)));
            }
        }
        this.useCache = options.hasCache();
        this.port = options.getPort();
    }

    public ActionApi(Script script, ExecuteOptions options, String type, CalculatedValue method, List<ApiData> data) {
        this(script, options, type, -1, true, method, data, new ApiData[0]);
    }

    public ActionApi(Script script, ExecuteOptions options, String type, int port, boolean cache, CalculatedValue method, List<ApiData> data, ApiData ... headerData) {
        super(script, options);
        this.setType(type);
        this.setPort(port);
        this.setUseCache(cache);
        this.setMethod(method);
        this.setData(data);
        this.setHeaders(new ArrayList<ApiData>(Arrays.asList(headerData)));
    }

    private void addHeader(String s) {
        if (this.headers == null) {
            this.headers = new ArrayList<ApiData>();
        }
        ApiData prop = new ApiData(this.script, s);
        this.headers.add(prop);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append("\"").append(this.type).append("\", ").append(this.port).append(", ").append(this.useCache).append(", ").append(this.method.getJavaCode()).append(", ");
        if (this.data == null) {
            codeBuilder.append("null");
        } else {
            StringJoiner sj = new StringJoiner(", ");
            codeBuilder.append(List.class.getCanonicalName()).append(".of(");
            for (ApiData apiData : this.data) {
                sj.add(apiData.getJavaCode());
            }
            codeBuilder.append(sj.toString()).append(")");
        }
        if (this.headers != null && this.headers.size() > 0) {
            codeBuilder.append(", ");
            StringJoiner joiner = new StringJoiner(", ");
            for (CalculatedProperty calculatedProperty : this.headers) {
                joiner.add(calculatedProperty.getJavaCode());
            }
            codeBuilder.append(joiner.toString());
        }
        codeBuilder.append(")");
        return codeBuilder;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        if (this.isPassed()) {
            this.method.uncrypt(ts);
            if (this.headers != null) {
                this.headers.stream().forEach(h -> h.getValue().uncrypt(ts));
            }
            this.getCurrentChannel().api(this.status, this);
            this.status.endDuration();
            JsonObject value = new JsonObject();
            value.addProperty("method", this.method.getSafeCalculated());
            value.addProperty("type", this.type);
            value.addProperty("cached", Boolean.valueOf(this.useCache));
            value.addProperty("port", (Number)this.port);
            JsonArray headersValue = new JsonArray();
            for (ApiData header : this.headers) {
                headersValue.add((JsonElement)header.getJson());
            }
            value.add("headers", (JsonElement)headersValue);
            if (this.data != null && this.data.size() > 0) {
                StringJoiner join = new StringJoiner("|");
                for (CalculatedProperty calculatedProperty : this.data) {
                    calculatedProperty.getValue().uncrypt(ts);
                    join.add(calculatedProperty.getValue().getSafeCalculated());
                }
                ts.getRecorder().update(value.toString(), join.toString());
            } else {
                ts.getRecorder().update(value.toString());
            }
        }
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("type", this.type);
        data.addProperty("method", this.method.getCalculated());
        Object statusData = this.status.getData();
        if (statusData == null) {
            data.addProperty(this.status.getMessage(), "");
        } else {
            data.addProperty(this.status.getMessage(), statusData.toString());
        }
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public CalculatedValue getMethod() {
        return this.method;
    }

    public void setMethod(CalculatedValue endPoint) {
        this.method = endPoint;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = POST.equalsIgnoreCase(type) || PUT.equalsIgnoreCase(type) || DELETE.equalsIgnoreCase(type) || SOAP.equalsIgnoreCase(type) || PATCH.equalsIgnoreCase(type) ? type.toUpperCase() : GET;
    }

    public List<ApiData> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<ApiData> data) {
        this.headers = data;
    }

    public List<ApiData> getData() {
        return this.data;
    }

    public void setData(List<ApiData> value) {
        this.data = value;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean value) {
        this.useCache = value;
    }
}

