/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.script.actions.condition.ExecuteOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ActionGesturePress
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "press";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g);
    private ArrayList<String> paths;
    private int duration = 2;

    public ActionGesturePress() {
    }

    public ActionGesturePress(Script script, ExecuteOptions options, int stopPolicy, ArrayList<String> paths, ArrayList<String> elements) {
        super(script, options, stopPolicy, elements);
        this.setPaths(paths);
    }

    public ActionGesturePress(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, int duration, String[] paths) {
        super(script, options, stopPolicy, maxTry, delay, element);
        this.setDuration(duration);
        this.setPaths(new ArrayList<String>(Arrays.asList(paths)));
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", ").append(this.duration).append(", ").append("new java.lang.String[]{");
        List myFinalList = this.getPaths().stream().map(path -> "\"" + path.trim() + "\"").collect(Collectors.toList());
        String test = String.join((CharSequence)",", myFinalList);
        codeBuilder.append(test);
        codeBuilder.append("}").append(")");
        return codeBuilder;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            ts.getRecorder().updateScreen(true);
            this.getTestElement().press(this.getDuration(), this.getPaths());
            this.status.endAction();
            ts.getRecorder().updateScreen(this.status);
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = Math.max(duration, 0);
    }

    public ArrayList<String> getPaths() {
        return this.paths;
    }

    public void setPaths(ArrayList<String> paths) {
        this.paths = paths;
    }
}

