/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.mouse.MouseSwipe;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionMouse;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionMouseSwipe
extends ActionMouse {
    public static final String SCRIPT_LABEL = "swipe";
    public static final Predicate<String> PREDICATE = "swipe"::equals;
    private MouseDirection direction;

    public ActionMouseSwipe() {
    }

    public ActionMouseSwipe(AtsScript script, ExecuteOptions options, String type, String direction, int stopPolicy, ArrayList<String> objectArray) {
        super(script, options, type, stopPolicy, objectArray);
        this.setDirection(new MouseDirection(script, new ExecuteOptions(script, direction.split(", ")), false));
    }

    public ActionMouseSwipe(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, MouseSwipe mouse) {
        super(script, options, stopPolicy, maxTry, delay, element, mouse);
        this.setDirection(mouse.getDirection());
    }

    @Override
    public StringBuilder getJavaCode() {
        this.setSpareCode(this.direction.getDirectionJavaCode());
        return super.getJavaCode();
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.getTestElement().swipe(this.status, this.getPosition(), this.direction);
            this.status.endDuration();
            ts.getRecorder().updateScreen(this.status);
        }
        this.getCurrentChannel().sleep(50);
        ts.getRecorder().updateScreen(false);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public MouseDirection getDirection() {
        return this.direction;
    }

    public void setDirection(MouseDirection value) {
        this.direction = value;
    }
}

