/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.channels.Channel;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionWindow;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.logger.ExecutionLogger;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.openqa.selenium.WindowType;

public class ActionWindowNew
extends ActionWindow {
    private static final String SCRIPT_NEW_LABEL = "window-new";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_NEW_LABEL.equals(g);
    private WindowType type = WindowType.TAB;
    private CalculatedValue url;

    public ActionWindowNew() {
    }

    public ActionWindowNew(Script script, ExecuteOptions options, String type, ArrayList<String> data) {
        super(script, options);
        this.setType(type);
        if (data.size() > 0) {
            this.setUrl(new CalculatedValue(script, data.get(0).trim()));
        }
    }

    public ActionWindowNew(Script script, ExecuteOptions options, String type, CalculatedValue url) {
        super(script, options);
        this.setType(type);
        this.setUrl(url);
    }

    public ActionWindowNew(Script script, ExecuteOptions options, String type) {
        super(script, options);
        this.setType(type);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode().append("\"").append(this.type.toString()).append("\"");
        if (this.url != null) {
            codeBuilder.append(", ").append(this.url.getJavaCode());
        }
        return codeBuilder.append(")");
    }

    @Override
    public String exec(Channel channel, ExecutionLogger logger) {
        channel.newWindow(this.status, this.type, this.url);
        return this.type.toString();
    }

    public String getType() {
        return this.type.toString();
    }

    public void setType(String value) {
        if (WindowType.TAB.toString().equalsIgnoreCase(value)) {
            this.type = WindowType.TAB;
        } else if (WindowType.WINDOW.toString().equalsIgnoreCase(value)) {
            this.type = WindowType.WINDOW;
        }
    }

    public CalculatedValue getUrl() {
        return this.url;
    }

    public void setUrl(CalculatedValue url) {
        this.url = url;
    }
}

