/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.channels.Channel;
import com.ats.generator.objects.BoundData;
import com.ats.script.Script;
import com.ats.script.actions.ActionWindow;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.logger.ExecutionLogger;
import com.google.gson.JsonObject;
import java.util.function.Predicate;

public class ActionWindowResize
extends ActionWindow {
    private static final String SCRIPT_RESIZE_LABEL = "window-resize";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_RESIZE_LABEL.equals(g);
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private BoundData x;
    private BoundData y;
    private BoundData width;
    private BoundData height;

    public ActionWindowResize() {
    }

    public ActionWindowResize(Script script, ExecuteOptions options, String size) {
        super(script, options);
        String[] sizeData;
        block12: for (String data : sizeData = size.split(",")) {
            String[] dataValue = data.split("=");
            if (dataValue.length != 2) continue;
            switch (dataValue[0].trim().toLowerCase()) {
                case "x": {
                    this.x = this.getBoundData(dataValue[1].trim(), false);
                    continue block12;
                }
                case "y": {
                    this.y = this.getBoundData(dataValue[1].trim(), false);
                    continue block12;
                }
                case "width": {
                    this.width = this.getBoundData(dataValue[1].trim(), true);
                    continue block12;
                }
                case "height": {
                    this.height = this.getBoundData(dataValue[1].trim(), true);
                }
            }
        }
    }

    private BoundData getBoundData(String data, boolean absolute) {
        try {
            return new BoundData(Integer.parseInt(data), absolute);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public ActionWindowResize(Script script, ExecuteOptions options, Integer x, Integer y, Integer width, Integer height) {
        super(script, options);
        this.setX(this.getBoundDataValue(x, false));
        this.setY(this.getBoundDataValue(y, false));
        this.setWidth(this.getBoundDataValue(width, true));
        this.setHeight(this.getBoundDataValue(height, true));
    }

    private BoundData getBoundDataValue(Integer value, boolean absolute) {
        if (value != null) {
            return new BoundData(value, absolute);
        }
        return null;
    }

    private String getBoundDataJavaCode(BoundData value) {
        if (value != null) {
            return String.valueOf(value.getValue());
        }
        return null;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.getBoundDataJavaCode(this.x)).append(", ").append(this.getBoundDataJavaCode(this.y)).append(", ").append(this.getBoundDataJavaCode(this.width)).append(", ").append(this.getBoundDataJavaCode(this.height)).append(")");
        return codeBuilder;
    }

    @Override
    public String exec(Channel channel, ExecutionLogger logger) {
        return channel.updateWindowBound(this.getStatus(), this.x, this.y, this.width, this.height);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        if (this.x != null) {
            data.addProperty(X, (Number)this.x.getValue());
        }
        if (this.y != null) {
            data.addProperty(Y, (Number)this.y.getValue());
        }
        if (this.width != null) {
            data.addProperty(WIDTH, (Number)this.width.getValue());
        }
        if (this.height != null) {
            data.addProperty(HEIGHT, (Number)this.height.getValue());
        }
        data.addProperty("duration", (Number)this.status.getDuration());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public BoundData getX() {
        return this.x;
    }

    public void setX(BoundData x) {
        this.x = x;
    }

    public BoundData getY() {
        return this.y;
    }

    public void setY(BoundData y) {
        this.y = y;
    }

    public BoundData getWidth() {
        return this.width;
    }

    public void setWidth(BoundData width) {
        this.width = width;
    }

    public BoundData getHeight() {
        return this.height;
    }

    public void setHeight(BoundData height) {
        this.height = height;
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("window-").append(" -> ");
    }
}

