/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

public class RegexpTimeoutException
extends RuntimeException {
    private static final long serialVersionUID = 6437153127902393756L;
    private final String regularExpression;
    private final String stringToMatch;
    private final long timeoutMillis;

    public RegexpTimeoutException() {
        this.regularExpression = null;
        this.stringToMatch = null;
        this.timeoutMillis = 0L;
    }

    public RegexpTimeoutException(String message, Throwable cause) {
        super(message, cause);
        this.regularExpression = null;
        this.stringToMatch = null;
        this.timeoutMillis = 0L;
    }

    public RegexpTimeoutException(String message) {
        super(message);
        this.regularExpression = null;
        this.stringToMatch = null;
        this.timeoutMillis = 0L;
    }

    public RegexpTimeoutException(Throwable cause) {
        super(cause);
        this.regularExpression = null;
        this.stringToMatch = null;
        this.timeoutMillis = 0L;
    }

    public RegexpTimeoutException(String regularExpression, String stringToMatch, long timeoutMillis) {
        super("Timeout occurred after " + timeoutMillis + "ms while processing regular expression '" + regularExpression + "' on input '" + stringToMatch + "'!");
        this.regularExpression = regularExpression;
        this.stringToMatch = stringToMatch;
        this.timeoutMillis = timeoutMillis;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public String getStringToMatch() {
        return this.stringToMatch;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }
}

