/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.logger.prefix;

import com.ats.tools.logger.prefix.ILogType;

public class Terminal
implements ILogType {
    protected static String ERROR;
    protected static String FAILED;
    protected static String EXEC;
    protected static String SUITE;
    protected static String TEST;
    protected static String LOGGER;
    protected static String INFO;
    protected static String WARNING;
    protected static String ACTION;
    protected static String COMMENT;
    protected static String DRIVER_INFO;
    protected static String DRIVER_WARNING;
    protected static String DRIVER_ERROR;
    protected static String DRIVER_OUTPUT;

    protected String getBracketLog(String log) {
        return "[" + log + "] ";
    }

    @Override
    public String getErrorData() {
        return this.getBracketLog(ERROR);
    }

    @Override
    public String getFailData(String actionName, String testName, int line, String info, String details) {
        StringBuilder sb = new StringBuilder(this.getBracketLog(FAILED)).append(actionName).append(" (").append(testName).append(":").append(line).append(")").append(" -> ").append(info);
        return sb.toString();
    }

    @Override
    public String getScriptData(String value) {
        return this.getBracketLog(EXEC);
    }

    @Override
    public String getTestData(String value) {
        return this.getBracketLog(TEST);
    }

    @Override
    public String getLoggerData() {
        return this.getBracketLog(LOGGER);
    }

    @Override
    public String getInfoData() {
        return this.getBracketLog(INFO);
    }

    @Override
    public String getWarningData() {
        return this.getBracketLog(WARNING);
    }

    @Override
    public String getActionData() {
        return this.getBracketLog(ACTION);
    }

    @Override
    public String getCommentData(String message) {
        StringBuilder sb = new StringBuilder(this.getBracketLog(COMMENT)).append(" <![CDATA[\n").append(message).append("\n]]>");
        return sb.toString();
    }

    @Override
    public String getDriverLog() {
        return this.getBracketLog(DRIVER_INFO);
    }

    @Override
    public String getDriverWarning() {
        return this.getBracketLog(DRIVER_WARNING);
    }

    @Override
    public String getDriverError() {
        return this.getBracketLog(DRIVER_ERROR);
    }

    @Override
    public String getDriverOutput() {
        return this.getBracketLog(DRIVER_OUTPUT);
    }

    @Override
    public String getSuiteData() {
        return this.getBracketLog(SUITE);
    }

    static {
        String ATS2 = "ATS-";
        ERROR = ATS2 + "ERROR";
        FAILED = ATS2 + "FAILED";
        EXEC = ATS2 + "EXEC";
        SUITE = ATS2 + "SUITE";
        TEST = ATS2 + "TEST";
        LOGGER = ATS2 + "LOGGER";
        INFO = ATS2 + "INFO";
        WARNING = ATS2 + "WARNING";
        ACTION = ATS2 + "ACTION";
        COMMENT = ATS2 + "COMMENT";
        DRIVER_INFO = ATS2 + "DRIVER-INFO";
        DRIVER_WARNING = ATS2 + "DRIVER-WARNING";
        DRIVER_ERROR = ATS2 + "DRIVER-ERROR";
        DRIVER_OUTPUT = ATS2 + "DRIVER-OUTPUT";
    }
}

