/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;

public class Constants {
    private Constants() {
    }

    public static class StatusIcons {
        public static String FAIL_ICON = "result-failed-icon";
        public static String FAIL_TRANSPARENT_ICON = "result-failed-icon-transparent";
        public static String FAIL_PASS_ICON = "result-fail-pass-icon";
        public static String PASS_ICON = "result-pass-icon";
        public static String PASS_TRANSPARENT_ICON = "result-pass-icon-transparent";
        public static String PASS_CONTINUE_ICON = "result-pass-icon-continue";

        private StatusIcons() {
        }
    }

    public static enum Status {
        FAIL(false, "FAIL", StatusIcons.FAIL_ICON, StatusIcons.FAIL_TRANSPARENT_ICON),
        PASS(true, "PASS", StatusIcons.PASS_ICON, StatusIcons.PASS_TRANSPARENT_ICON);

        private final boolean booleanValue;
        private final String value;
        private final String icon;
        private final String transparentIcon;

        private Status(boolean booleanValue, String value, String icon, String transparentIcon) {
            this.booleanValue = booleanValue;
            this.value = value;
            this.icon = icon;
            this.transparentIcon = transparentIcon;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String getValue() {
            return this.value;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getTransparentIcon() {
            return this.transparentIcon;
        }

        public static Status fromValue(String value) {
            Validate.notBlank((CharSequence)value);
            return Stream.of(Status.values()).filter(status -> status.getValue().equals(value)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Invalid Staus %s", value)));
        }
    }

    public static enum SummaryStatus {
        FAIL("0", StatusIcons.FAIL_ICON, StatusIcons.FAIL_TRANSPARENT_ICON),
        PASS("1", StatusIcons.PASS_ICON, StatusIcons.PASS_TRANSPARENT_ICON),
        PASS_CONTINUE("2", StatusIcons.PASS_CONTINUE_ICON, "");

        private final String numericValue;
        private final String icon;
        private final String transparentIcon;

        private SummaryStatus(String numericValue, String icon, String transparentIcon) {
            this.numericValue = numericValue;
            this.icon = icon;
            this.transparentIcon = transparentIcon;
        }

        public String getNumericValue() {
            return this.numericValue;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getTransparentIcon() {
            return this.transparentIcon;
        }

        public static SummaryStatus fromNumericValue(String numericValue) {
            Validate.notBlank((CharSequence)numericValue);
            return Stream.of(SummaryStatus.values()).filter(summaryStatus -> summaryStatus.getNumericValue().equals(numericValue)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("Invalid Summary Staus %s", numericValue)));
        }
    }
}

