/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.AtsSingleton;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.testng.TestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

@JsonIgnoreProperties(value={"imageGray"})
public class SuitesReportItem {
    public static final String CALLSCRIPT_ITERATION = "ats-callscript-iteration";
    public static final String CALLSCRIPT_PARAMETER_FILE = "ats-callscript-parameters";
    public static final String ITERATION_PROPERTY = "ats-iteration";
    public static final String ITERATION_COUNT_PROPERTY = "ats-iteration-count";
    public static final String DATA_FILE = "ats-data-file";
    public static final String IMAGE_QUALITY = "ats-image-quality";
    public static final String DATE_ORDER = "ats-date-order";
    private static final String ATS_LOG_LEVEL = "ats.log.level";
    private static final String ATS_REPORT_IMAGE_QUALITY = "visual.report";
    private static final String ATS_REPORT_WEBP_IMAGE = "webp.image.format";
    private static final String ATSV_HTML = "atsv.html";
    private static final String ATS_REPORT_DEV_LEVEL = "ats.report.dev.level";
    private static final String ATS_REPORT_MGT_LEVEL = "ats.report.mgt.level";
    private static final String ATS_REPORT_VALID_LEVEL = "ats.report.validation.level";
    private static final String ATS_SUITE_DESCRIPTION = "ats.suite.description";
    private static final String ATS_SUITE_DATE_ORDER = "ats.suite.date.order";
    public static final String ATS_WEBP_FORMAT_SYSTEM_PROPERTY = "ATS_WEBP_FORMAT";
    public String devReportLvl = "";
    public String mgtReportLvl = "";
    public String validReportLvl = "";
    public List<String> tests;
    private String name;
    private String description = "";
    private boolean useWebpFormat = false;
    private int visualQuality = 3;
    private boolean atsvHtml = false;
    private String dateOrder = "";
    private Map<String, String> parameters;
    private List<String> includedGroups = new ArrayList<String>();
    private List<String> excludedGroups = new ArrayList<String>();
    private boolean reporting = false;
    private transient String ouputDir;
    private transient String projectId;
    private transient String projectUuid;
    private transient boolean noSuiteLaunch;
    private transient boolean subScriptIteration = false;
    private long started = System.currentTimeMillis();

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String value) {
        if (value == null) {
            value = "";
        }
        this.description = value;
    }

    public boolean isUseWebpFormat() {
        String useWebPFormat = System.getenv().get(ATS_WEBP_FORMAT_SYSTEM_PROPERTY);
        if (StringUtils.isNotEmpty((CharSequence)useWebPFormat)) {
            AtsLogger.printLog("Using webp format: " + useWebPFormat);
            return Boolean.parseBoolean(useWebPFormat);
        }
        return this.useWebpFormat;
    }

    public int getVisualQuality() {
        return this.visualQuality;
    }

    public String getVisualQualityLabel() {
        switch (this.visualQuality) {
            case 1: {
                return "size-optimized";
            }
            case 2: {
                return "speed-optimized";
            }
            case 3: {
                return "quality";
            }
            case 4: {
                return "max-quality";
            }
        }
        return "undefined";
    }

    public void setVisualQuality(String value) {
        this.visualQuality = Utils.string2Int(value, 3);
    }

    public boolean isAtsvHtml() {
        return this.atsvHtml;
    }

    public void setAtsvHtml(String value) {
        this.atsvHtml = "true".equalsIgnoreCase(value);
    }

    public String getDateOrder() {
        return this.dateOrder.toUpperCase();
    }

    private void setDateOrder(String value) {
        if (value == null) {
            value = "";
        }
        this.dateOrder = value;
    }

    public Set<Map.Entry<String, String>> getParametersEntries() {
        return this.parameters.entrySet();
    }

    public List<String> getIncludedGroups() {
        return this.includedGroups;
    }

    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public boolean isSubScriptIteration() {
        return this.subScriptIteration;
    }

    public SuitesReportItem(String projectUuid, String projectId, TestRunner runner) {
        this(runner);
        this.projectUuid = projectUuid;
        this.projectId = projectId;
        this.name = runner.getSuite().getName();
        XmlSuite xmlSuite = runner.getSuite().getXmlSuite();
        if (xmlSuite.getFileName() == null) {
            this.noSuiteLaunch = true;
            this.useWebpFormat = false;
        }
        if (xmlSuite.getGroups() != null) {
            this.includedGroups = xmlSuite.getGroups().getRun().getIncludes();
            this.excludedGroups = xmlSuite.getGroups().getRun().getExcludes();
        }
        this.ouputDir = runner.getOutputDirectory();
        this.tests = new ArrayList<String>();
        if (this.subScriptIteration) {
            for (XmlTest test : xmlSuite.getTests()) {
                List classes = test.getClasses();
                if (classes.size() <= 0) continue;
                XmlClass xmlTestClass = (XmlClass)classes.get(0);
                this.tests.add(xmlTestClass.getName() + "-" + test.getName());
            }
        } else {
            for (XmlTest test : xmlSuite.getTests()) {
                List classes = test.getClasses();
                for (XmlClass cla : classes) {
                    this.tests.add(cla.getName());
                }
            }
        }
    }

    public SuitesReportItem(TestRunner runner) {
        String logLevel = "";
        String scriptIteration = (String)runner.getTest().getAllParameters().get(CALLSCRIPT_ITERATION);
        if (scriptIteration != null) {
            this.subScriptIteration = true;
            logLevel = runner.getSuite().getXmlSuite().getParameter(ATS_LOG_LEVEL);
            Map inheritedParameters = runner.getTest().getAllParameters();
            this.setVisualQuality((String)inheritedParameters.get(ATS_REPORT_IMAGE_QUALITY));
            this.setAtsvHtml((String)inheritedParameters.get(ATSV_HTML));
            this.setDateOrder((String)inheritedParameters.get(ATS_SUITE_DATE_ORDER));
            this.setDescription("Callscript as a suite = " + scriptIteration);
            String webp = (String)inheritedParameters.get(ATS_REPORT_WEBP_IMAGE);
            if (webp != null && "true".equalsIgnoreCase(webp)) {
                this.useWebpFormat = true;
            }
            this.parameters = ImmutableMap.of((Object)DATA_FILE, (Object)((String)inheritedParameters.get(CALLSCRIPT_PARAMETER_FILE)));
        } else {
            this.parameters = runner.getTest().getAllParameters();
            if (this.parameters != null) {
                logLevel = this.parameters.remove(ATS_LOG_LEVEL);
                this.setDevLevel(this.parameters.remove(ATS_REPORT_DEV_LEVEL));
                this.setMgtLevel(this.parameters.remove(ATS_REPORT_MGT_LEVEL));
                this.setValidLevel(this.parameters.remove(ATS_REPORT_VALID_LEVEL));
                this.setVisualQuality(this.parameters.remove(ATS_REPORT_IMAGE_QUALITY));
                this.setAtsvHtml(this.parameters.remove(ATSV_HTML));
                this.setDateOrder(this.parameters.remove(ATS_SUITE_DATE_ORDER));
                this.setDescription(this.parameters.remove(ATS_SUITE_DESCRIPTION));
                String webp = this.parameters.remove(ATS_REPORT_WEBP_IMAGE);
                if (webp != null && "false".equalsIgnoreCase(webp)) {
                    this.useWebpFormat = false;
                }
            }
        }
        AtsSingleton.getInstance().setLoglevel(logLevel);
    }

    public boolean isNoSuiteLaunch() {
        return this.noSuiteLaunch;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public long getStarted() {
        return this.started;
    }

    public String getStartLog() {
        JsonObject logs = new JsonObject();
        logs.addProperty("name", this.name);
        logs.addProperty("tests", (Number)this.tests.size());
        return "suite started -> " + logs.toString();
    }

    public File getSuitesFile() {
        return Paths.get(this.ouputDir, new String[0]).getParent().resolve("ats-suites.json").toFile();
    }

    private void setDevLevel(String value) {
        if (value != null) {
            this.devReportLvl = value;
            if (!"0".equals(this.devReportLvl)) {
                this.reporting = true;
            }
        }
    }

    private void setMgtLevel(String value) {
        if (value != null) {
            this.mgtReportLvl = value;
            if (!"0".equals(this.mgtReportLvl)) {
                this.reporting = true;
            }
        }
    }

    private void setValidLevel(String value) {
        if (value != null) {
            this.validReportLvl = value;
            if (!"0".equals(this.validReportLvl)) {
                this.reporting = true;
            }
        }
    }

    public int getTestsCount() {
        return this.tests.size();
    }

    public String getSingleTest() {
        if (this.tests.size() > 0) {
            return this.tests.getFirst();
        }
        return null;
    }

    public boolean isReporting() {
        return this.reporting;
    }

    public void setIsNoSuiteLaunch(boolean isNoSuiteLaunch) {
        this.noSuiteLaunch = isNoSuiteLaunch;
    }

    public void setReporting(boolean reporting) {
        this.reporting = reporting;
    }
}

